/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl.adhoc;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

public abstract class AbstractAdHocCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(AbstractAdHocCommand.class.getCanonicalName());
    @Inject
    private RTBLComponent component;
    @Inject
    private RTBLRepository repository;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.isAction("cancel")) {
                response.cancelSession();
            } else if (data == null) {
                response.getElements().add(this.prepareForm(request, response).getElement());
                response.startSession();
            } else {
                Form responseForm;
                Form form = new Form(data);
                if (form.isType("submit") && (responseForm = this.submitForm(request, response, form)) != null) {
                    response.getElements().add(responseForm.getElement());
                }
            }
        }
        catch (AdHocCommandException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Exception during execution of adhoc command " + this.getNode(), e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }

    protected RTBLRepository getRepository() {
        return this.repository;
    }

    protected abstract Form prepareForm(AdhHocRequest var1, AdHocResponse var2) throws AdHocCommandException;

    protected abstract Form submitForm(AdhHocRequest var1, AdHocResponse var2, Form var3) throws AdHocCommandException;

    protected String assertNotEmpty(String input, String message) throws AdHocCommandException {
        if (input == null || input.isBlank()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, message);
        }
        return input.trim();
    }
}

