/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.extdisco;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.db.TigaseDBException;
import tigase.db.comp.ComponentRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.extdisco.ExtServiceDiscoItem;
import tigase.server.extdisco.ExternalServiceDiscoveryComponent;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;

@Bean(name="extDiscoModule", parent=ExternalServiceDiscoveryComponent.class, active=true)
public class ExternalServiceDiscoveryModule
implements Module {
    private static final Logger log = Logger.getLogger(ExternalServiceDiscoveryModule.class.getCanonicalName());
    private static final String XMLNS = "urn:xmpp:extdisco:2";
    private static final Criteria CRITERIA = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"services", (String)"urn:xmpp:extdisco:2"));
    @Inject
    private PacketWriter packetWriter;
    @Inject
    private ComponentRepository<ExtServiceDiscoItem> repo;

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRITERIA;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() == StanzaType.error) {
            log.log(Level.FINEST, "Received packet of type ''error'', dropping packet = {0}", packet);
            return;
        }
        if (packet.getType() != StanzaType.get) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid packet type");
        }
        String type = packet.getElement().getChild("services", XMLNS).getAttributeStaticStr("type");
        List<ExtServiceDiscoItem> services = this.getServices(type);
        Element servicesEl = new Element("services");
        servicesEl.setXMLNS(XMLNS);
        services.forEach(service -> {
            Element item = service.toElement();
            String host = item.getAttributeStaticStr("host");
            if (host != null && host.contains("{clusterNode}")) {
                item.setAttribute("host", host.replace("{clusterNode}", DNSResolverFactory.getInstance().getSecondaryHost()));
            }
            item.removeAttribute("key");
            servicesEl.addChild((XMLNodeIfc)item);
        });
        this.packetWriter.write(packet.okResult(servicesEl, 0));
    }

    protected List<ExtServiceDiscoItem> getServices(String type) {
        try {
            ArrayList<ExtServiceDiscoItem> items = new ArrayList<ExtServiceDiscoItem>(this.repo.allItems());
            if (type != null) {
                items.removeIf(item -> !type.equals(item.getType()));
            }
            return items;
        }
        catch (TigaseDBException ex) {
            throw new RuntimeException("Exception reading items from repository", ex);
        }
    }
}

