/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.UserNotFoundException;
import tigase.db.util.JDBCPasswordObfuscator;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.util.ExceptionUtilities;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(isDefault=true, supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class JDBCMsgRepository
extends MsgRepository<Long, DataRepository>
implements RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(JDBCMsgRepository.class.getName());
    protected DataRepository data_repo = null;
    @ConfigField(desc="Query to add message", alias="add-message-query")
    private String MSGS_ADD_MESSAGE = "{ call Tig_OfflineMessages_AddMessage(?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to count messages", alias="count-messages-query")
    private String MSGS_COUNT_MESSAGES = "{ call Tig_OfflineMessages_GetMessagesCount(?) }";
    @ConfigField(desc="Query to delete message", alias="delete-message-query")
    private String MSGS_DELETE_MESSAGE = "{ call Tig_OfflineMessages_DeleteMessage(?) }";
    @ConfigField(desc="Query to delete messages", alias="delete-messages-query")
    private String MSGS_DELETE_MESSAGES = "{ call Tig_OfflineMessages_DeleteMessages(?) }";
    @ConfigField(desc="Query to delete messages by ids", alias="delete-messages-by-ids-query")
    private String MSGS_DELETE_MESSAGES_BY_IDS = "{ call Tig_OfflineMessages_DeleteMessagesByIds(?,?,?,?,?) }";
    @ConfigField(desc="Query to select expired messages", alias="get-expired-messages-query")
    private String MSGS_GET_EXPIRED_MESSAGES = "{ call Tig_OfflineMessages_GetExpiredMessages(?) }";
    @ConfigField(desc="Query to select expired messages before passed time", alias="get-expired-messages-before-query")
    private String MSGS_GET_EXPIRED_MESSAGES_BEFORE = "{ call Tig_OfflineMessages_GetExpiredMessagesBefore(?) }";
    @ConfigField(desc="Query to load messages", alias="get-messages-query")
    private String MSGS_GET_MESSAGES = "{ call Tig_OfflineMessages_GetMessages(?) }";
    @ConfigField(desc="Query to load messages by ids", alias="get-messages-by-ids-query")
    private String MSGS_GET_MESSAGES_BY_IDS = "{ call Tig_OfflineMessages_GetMessagesByIds(?,?,?,?,?) }";
    @ConfigField(desc="Query to list messages", alias="list-messages-query")
    private String MSGS_LIST_MESSAGES = "{ call Tig_OfflineMessages_ListMessages(?) }";
    private boolean initialized = false;
    private final ReentrantReadWriteLock[] locks = (ReentrantReadWriteLock[])IntStream.range(0, 128).mapToObj(i -> new ReentrantReadWriteLock()).toArray(ReentrantReadWriteLock[]::new);

    @Override
    public void setDataSource(DataRepository data_repo) {
        try {
            data_repo.initPreparedStatement(this.MSGS_ADD_MESSAGE, this.MSGS_ADD_MESSAGE);
            data_repo.initPreparedStatement(this.MSGS_COUNT_MESSAGES, this.MSGS_COUNT_MESSAGES);
            data_repo.initPreparedStatement(this.MSGS_LIST_MESSAGES, this.MSGS_LIST_MESSAGES);
            data_repo.initPreparedStatement(this.MSGS_GET_MESSAGES, this.MSGS_GET_MESSAGES);
            data_repo.initPreparedStatement(this.MSGS_GET_MESSAGES_BY_IDS, this.MSGS_GET_MESSAGES_BY_IDS);
            data_repo.initPreparedStatement(this.MSGS_DELETE_MESSAGE, this.MSGS_DELETE_MESSAGE);
            data_repo.initPreparedStatement(this.MSGS_DELETE_MESSAGES, this.MSGS_DELETE_MESSAGES);
            data_repo.initPreparedStatement(this.MSGS_DELETE_MESSAGES_BY_IDS, this.MSGS_DELETE_MESSAGES_BY_IDS);
            data_repo.initPreparedStatement(this.MSGS_GET_EXPIRED_MESSAGES, this.MSGS_GET_EXPIRED_MESSAGES);
            data_repo.initPreparedStatement(this.MSGS_GET_EXPIRED_MESSAGES_BEFORE, this.MSGS_GET_EXPIRED_MESSAGES_BEFORE);
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "MsgRepository not initialized due to exception", ExceptionUtilities.getExceptionRootCause((Exception)ex, (boolean)true));
            throw new RuntimeException("Could not initialize JDBCMsgRepository instance for " + JDBCPasswordObfuscator.obfuscatePassword(data_repo.getResourceUri()), ex);
        }
        this.data_repo = data_repo;
    }

    @Override
    @Deprecated
    public void initRepository(String conn_str, Map<String, String> map) throws DBInitException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.log(Level.CONFIG, "Initializing dbAccess for db connection url: {0}", conn_str);
        super.initRepository(conn_str, map);
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
            this.data_repo.checkSchemaVersion(this, true);
            this.setDataSource(this.data_repo);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "MsgRepository not initialized due to exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Enum, Long> getMessagesCount(JID to) {
        HashMap<Enum, Long> result = new HashMap<Enum, Long>(MsgRepository.MSG_TYPES.values().length);
        try {
            PreparedStatement number_of_messages;
            ResultSet rs = null;
            PreparedStatement preparedStatement = number_of_messages = this.data_repo.getPreparedStatement(to.getBareJID(), this.MSGS_COUNT_MESSAGES);
            synchronized (preparedStatement) {
                number_of_messages.setString(1, to.getBareJID().toString());
                rs = number_of_messages.executeQuery();
                while (rs.next()) {
                    int msgType = rs.getInt(1);
                    long msgCount = rs.getLong(2);
                    result.put(MsgRepository.MSG_TYPES.getFromInt(msgType), msgCount);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + String.valueOf(to), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Element> getMessagesList(JID to) {
        LinkedList<Element> result = new LinkedList<Element>();
        ResultSet rs = null;
        try {
            PreparedStatement select_messages_list;
            PreparedStatement preparedStatement = select_messages_list = this.data_repo.getPreparedStatement(to.getBareJID(), this.MSGS_LIST_MESSAGES);
            synchronized (preparedStatement) {
                try {
                    select_messages_list.setString(1, to.getBareJID().toString());
                    rs = select_messages_list.executeQuery();
                    while (rs.next()) {
                        long msgId = rs.getLong(1);
                        int mType = rs.getInt(2);
                        MsgRepository.MSG_TYPES messageType = MsgRepository.MSG_TYPES.getFromInt(mType);
                        String sender = rs.getString(3);
                        if (msgId == 0L || messageType == MsgRepository.MSG_TYPES.none || sender == null) continue;
                        Element item = new Element("item", new String[]{"jid", "node", "type", "name"}, new String[]{to.getBareJID().toString(), String.valueOf(msgId), messageType.name(), sender});
                        result.add(item);
                    }
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + String.valueOf(to), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        LinkedList<Element> result = null;
        BareJID to = null;
        try {
            to = session.getBareJID();
            if (db_ids == null || db_ids.size() == 0) {
                return this.loadMessagesToJID(session, delete, proc);
            }
            ResultSet rs = null;
            result = new LinkedList<Element>();
            Iterator<String> ids = db_ids.iterator();
            while (ids.hasNext()) {
                PreparedStatement select_ids_to_jid_st;
                PreparedStatement preparedStatement = select_ids_to_jid_st = this.data_repo.getPreparedStatement(to, this.MSGS_GET_MESSAGES_BY_IDS);
                synchronized (preparedStatement) {
                    try {
                        select_ids_to_jid_st.setString(1, to.toString());
                        for (int j = 0; j < 4; ++j) {
                            String id = ids.hasNext() ? ids.next() : null;
                            select_ids_to_jid_st.setString(j + 2, id);
                        }
                        rs = select_ids_to_jid_st.executeQuery();
                        result.addAll(this.parseLoadedMessages(proc, rs));
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            if (delete) {
                this.deleteMessagesToJID(null, session);
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + String.valueOf(to), e);
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.WARNING, "Session not authorized yet!", ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        int affectedRows = 0;
        BareJID to = null;
        try {
            to = session.getBareJID();
            if (db_ids == null || db_ids.size() == 0) {
                PreparedStatement delete_to_jid_st = this.data_repo.getPreparedStatement(to, this.MSGS_DELETE_MESSAGES);
                ResultSet rs = null;
                PreparedStatement preparedStatement = delete_to_jid_st;
                synchronized (preparedStatement) {
                    try {
                        delete_to_jid_st.setString(1, to.toString());
                        delete_to_jid_st.executeUpdate();
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                    return ++affectedRows;
                }
            }
            Iterator<String> ids = db_ids.iterator();
            while (ids.hasNext()) {
                PreparedStatement delete_to_jid_st = this.data_repo.getPreparedStatement(to, this.MSGS_DELETE_MESSAGES_BY_IDS);
                ResultSet rs = null;
                PreparedStatement preparedStatement = delete_to_jid_st;
                synchronized (preparedStatement) {
                    try {
                        delete_to_jid_st.setString(1, to.toString());
                        for (int j = 0; j < 4; ++j) {
                            String id = ids.hasNext() ? ids.next() : null;
                            delete_to_jid_st.setString(j + 2, id);
                        }
                        rs = delete_to_jid_st.executeQuery();
                        if (rs.next()) {
                            affectedRows += rs.getInt(1);
                        }
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
            }
            return affectedRows;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + String.valueOf(to), e);
            return affectedRows;
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.WARNING, "Session not authorized yet!", ex);
        }
        return affectedRows;
    }

    @Override
    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
        return this.loadMessagesToJID(session, delete, null);
    }

    private ReentrantReadWriteLock getLock(BareJID jid) {
        if (jid == null) {
            return this.locks[0];
        }
        return this.locks[Math.abs(jid.hashCode() % this.locks.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        Queue<Element> result;
        block19: {
            result = null;
            BareJID to = null;
            ReentrantReadWriteLock.WriteLock lock = null;
            try {
                PreparedStatement select_to_jid_st;
                to = session.getBareJID();
                lock = this.getLock(to).writeLock();
                lock.lock();
                ResultSet rs = null;
                PreparedStatement preparedStatement = select_to_jid_st = this.data_repo.getPreparedStatement(to, this.MSGS_GET_MESSAGES);
                synchronized (preparedStatement) {
                    try {
                        select_to_jid_st.setString(1, to.toString());
                        rs = select_to_jid_st.executeQuery();
                        result = this.parseLoadedMessages(proc, rs);
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                }
                if (!delete) break block19;
                rs = null;
                try {
                    PreparedStatement delete_to_jid_st;
                    PreparedStatement preparedStatement2 = delete_to_jid_st = this.data_repo.getPreparedStatement(to, this.MSGS_DELETE_MESSAGES);
                    synchronized (preparedStatement2) {
                        delete_to_jid_st.setString(1, to.toString());
                        delete_to_jid_st.executeUpdate();
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting offline messages for user: " + String.valueOf(to), e);
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "Session not authorized yet!", ex);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Storring expired: {0} message: {1}", new Object[]{expired, Packet.elemToString(msg)});
        }
        boolean result = false;
        ReentrantReadWriteLock.ReadLock lock = this.getLock(to == null ? null : to.getBareJID()).readLock();
        lock.lock();
        try {
            PreparedStatement insert_msg_st;
            long msgs_store_limit = this.getMsgsStoreLimit(to.getBareJID(), userRepo);
            PreparedStatement preparedStatement = insert_msg_st = this.data_repo.getPreparedStatement(to.getBareJID(), this.MSGS_ADD_MESSAGE);
            synchronized (preparedStatement) {
                int msg_type;
                insert_msg_st.setString(1, to.getBareJID().toString());
                insert_msg_st.setString(2, from.getBareJID().toString());
                try {
                    String name = msg.getName();
                    MsgRepository.MSG_TYPES valueOf = MsgRepository.MSG_TYPES.valueOf(name);
                    msg_type = valueOf.ordinal();
                }
                catch (IllegalArgumentException e) {
                    msg_type = Integer.MAX_VALUE;
                }
                insert_msg_st.setInt(3, msg_type);
                this.data_repo.setTimestamp(insert_msg_st, 4, new Timestamp(System.currentTimeMillis()));
                insert_msg_st.setString(5, msg.toString());
                if (expired == null) {
                    insert_msg_st.setNull(6, 93);
                } else {
                    Timestamp time = new Timestamp(expired.getTime());
                    this.data_repo.setTimestamp(insert_msg_st, 6, time);
                }
                insert_msg_st.setLong(7, msgs_store_limit);
                try (ResultSet rs = insert_msg_st.executeQuery();){
                    if (rs.next()) {
                        result = rs.getLong(1) != 0L;
                    }
                }
            }
            if (expired != null) {
                if (expired.getTime() < this.earliestOffline) {
                    this.earliestOffline = expired.getTime();
                }
                if (this.awaitingInExpiredQueue.get() == 0) {
                    this.loadExpiredQueue(1);
                }
            }
        }
        catch (DataTruncation dte) {
            log.log(Level.FINE, "Data truncated for message from {0} to {1}", new Object[]{from, to});
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1366 || e.getMessage() != null && e.getMessage().startsWith("Incorrect string value")) {
                log.log(Level.WARNING, "Your MySQL configuration can't handle extended Unicode (for example emoji) correctly. Please refer to <Support for emoji and other icons> section of the server documentation");
            } else {
                log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    protected Queue<Element> parseLoadedMessages(MsgRepository.OfflineMessagesProcessor proc, ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        Queue<Object> result = new LinkedList<Element>();
        if (proc == null) {
            while (rs.next()) {
                sb.append(rs.getString(1));
            }
            if (sb.length() > 0) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, sb.toString().toCharArray(), 0, sb.length());
                result = domHandler.getParsedElements();
            }
        } else {
            result = new LinkedList();
            while (rs.next()) {
                String msg = rs.getString(1);
                long msgId = rs.getLong(2);
                if (msg == null) continue;
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, msg.toCharArray(), 0, msg.length());
                Queue parsedElements = domHandler.getParsedElements();
                Element msgEl = (Element)parsedElements.poll();
                if (msgEl == null || msgId <= 0L) continue;
                proc.stamp(msgEl, String.valueOf(msgId));
                result.add(msgEl);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMessage(Long msg_id) {
        try {
            PreparedStatement delete_id_st;
            PreparedStatement preparedStatement = delete_id_st = this.data_repo.getPreparedStatement(null, this.MSGS_DELETE_MESSAGE);
            synchronized (preparedStatement) {
                delete_id_st.setLong(1, msg_id);
                delete_id_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem removing entry from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExpiredQueue(int min_elements) {
        try {
            PreparedStatement select_expired_st;
            ResultSet rs = null;
            PreparedStatement preparedStatement = select_expired_st = this.data_repo.getPreparedStatement(null, this.MSGS_GET_EXPIRED_MESSAGES);
            synchronized (preparedStatement) {
                try {
                    select_expired_st.setInt(1, min_elements);
                    rs = select_expired_st.executeQuery();
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    int counter = 0;
                    while (rs.next() && (this.expiredQueue.size() < 1000 || counter++ < min_elements)) {
                        MsgRepository.MsgDBItem item = this.parseExpiredMessage(domHandler, rs);
                        if (item == null) continue;
                        this.expiredQueue.offer(item);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExpiredQueue(Date expired) {
        try {
            PreparedStatement select_expired_before_st;
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
                this.awaitingInExpiredQueue.set(0);
            }
            ResultSet rs = null;
            PreparedStatement preparedStatement = select_expired_before_st = this.data_repo.getPreparedStatement(null, this.MSGS_GET_EXPIRED_MESSAGES_BEFORE);
            synchronized (preparedStatement) {
                try {
                    this.data_repo.setTimestamp(select_expired_before_st, 1, new Timestamp(expired.getTime()));
                    rs = select_expired_before_st.executeQuery();
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    int counter = 0;
                    while (rs.next() && counter++ < 1000) {
                        MsgRepository.MsgDBItem item = this.parseExpiredMessage(domHandler, rs);
                        if (item == null) continue;
                        this.expiredQueue.offer(item);
                    }
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    protected MsgRepository.MsgDBItem parseExpiredMessage(DomBuilderHandler domHandler, ResultSet rs) throws SQLException {
        String msg_str = rs.getString(3);
        this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
        Queue elems = domHandler.getParsedElements();
        Element msg = (Element)elems.poll();
        if (msg == null) {
            log.log(Level.CONFIG, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
            return null;
        }
        Timestamp ts = this.data_repo.getTimestamp(rs, 2);
        return new MsgRepository.MsgDBItem<Long>(rs.getLong(1), msg, ts);
    }
}

