/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;

public class BeanUtils {
    public static Field[] getAllFields(Class<?> klass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(klass.getDeclaredFields()));
        if (klass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(BeanUtils.getAllFields(klass.getSuperclass())));
        }
        return fields.toArray(new Field[0]);
    }

    public static Method[] getAllMethods(Class<?> klass) {
        ArrayList<Method> fields = new ArrayList<Method>();
        fields.addAll(Arrays.asList(klass.getDeclaredMethods()));
        if (klass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(BeanUtils.getAllMethods(klass.getSuperclass())));
        }
        return fields.toArray(new Method[0]);
    }

    public static Field getField(BeanConfig bc, String fieldName) {
        Field[] fields;
        Class<?> cl = bc.getClazz();
        for (Field field : fields = DependencyManager.getAllFields(cl)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Type getGetterSetterMethodsParameterType(Field f) {
        Method getter = BeanUtils.prepareGetterMethod(f);
        if (getter == null) {
            return null;
        }
        Class<?> rt = getter.getReturnType();
        Method setter = BeanUtils.prepareSetterMethod(f, rt);
        return setter == null ? null : getter.getGenericReturnType();
    }

    public static Object getValue(Object fromBean, Field field) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setter = BeanUtils.prepareGetterMethod(field);
        if (setter != null) {
            return setter.invoke(fromBean, new Object[0]);
        }
        field.setAccessible(true);
        return field.get(fromBean);
    }

    public static String prepareAccessorMainPartName(String fieldName) {
        if (fieldName.length() == 1) {
            return fieldName.toUpperCase();
        }
        Object r = Character.isUpperCase(fieldName.charAt(1)) ? fieldName.substring(0, 1) : fieldName.substring(0, 1).toUpperCase();
        r = (String)r + fieldName.substring(1);
        return r;
    }

    public static Method prepareGetterMethod(Field f) {
        String gm;
        String t = BeanUtils.prepareAccessorMainPartName(f.getName());
        if (f.getType().isPrimitive() && f.getType().equals(Boolean.TYPE)) {
            String sm = "set" + t;
            gm = "is" + t;
        } else {
            String sm = "set" + t;
            gm = "get" + t;
        }
        try {
            Method m = f.getDeclaringClass().getMethod(gm, new Class[0]);
            return m;
        }
        catch (NoClassDefFoundError ex) {
            throw BeanUtils.createExceptionForMissingClassForField(f, ex);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method prepareSetterMethod(Field f) {
        return BeanUtils.prepareSetterMethod(f, f.getType());
    }

    public static Method prepareSetterMethod(Field f, Class type) {
        String sm;
        String t = BeanUtils.prepareAccessorMainPartName(f.getName());
        if (f.getType().isPrimitive() && f.getType().equals(Boolean.TYPE)) {
            sm = "set" + t;
            String gm = "is" + t;
        } else {
            sm = "set" + t;
            String gm = "get" + t;
        }
        try {
            Method m = f.getDeclaringClass().getMethod(sm, type);
            return m;
        }
        catch (NoClassDefFoundError ex) {
            throw BeanUtils.createExceptionForMissingClassForField(f, ex);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static ArrayList<Method> prepareSetterMethods(Class<?> destination, String fieldName) {
        String t = BeanUtils.prepareAccessorMainPartName(fieldName);
        ArrayList<Method> result = new ArrayList<Method>();
        try {
            for (Method m : BeanUtils.getAllMethods(destination)) {
                if (!m.getName().equals("set" + t)) continue;
                result.add(m);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setValue(Object toBean, Field field, Object valueToSet) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setter = BeanUtils.prepareSetterMethod(field);
        if (valueToSet != null && setter == null) {
            setter = BeanUtils.prepareSetterMethod(field, valueToSet.getClass());
        }
        if (setter != null) {
            setter.invoke(toBean, valueToSet);
        } else {
            field.setAccessible(true);
            field.set(toBean, valueToSet);
        }
    }

    public static void setValue(Object toBean, String fieldName, Object valueToSet) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        ArrayList<Method> setters = BeanUtils.prepareSetterMethods(toBean.getClass(), fieldName);
        if (setters == null || setters.isEmpty()) {
            throw new NoSuchMethodException("No setter for property '" + fieldName + "'.");
        }
        for (Method s : setters) {
            try {
                s.invoke(toBean, valueToSet);
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Cannot set value type " + valueToSet.getClass().getName() + " to property '" + fieldName + "'.");
    }

    private static IllegalArgumentException createExceptionForMissingClassForField(Field f, Throwable cause) {
        return new IllegalArgumentException("Missing class in classpath for field '" + String.valueOf(f) + "' in class " + String.valueOf(f.getDeclaringClass()) + " from " + String.valueOf(f.getDeclaringClass().getResource("/" + f.getDeclaringClass().getName().replace('.', '/') + ".class")), cause);
    }

    private BeanUtils() {
    }
}

