/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import tigase.io.IOInterface;
import tigase.io.JcaTLSWrapper;
import tigase.io.SSLContextContainerIfc;
import tigase.io.SampleSocketThread;
import tigase.io.SocketIO;
import tigase.io.TLSIO;
import tigase.io.TLSUtil;
import tigase.util.log.LogFormatter;

public class TelnetServer
implements SampleSocketThread.SocketHandler {
    private static final Logger log = Logger.getLogger("tigase.io.TelnetServer");
    private static final Charset coder = Charset.forName("UTF-8");
    private static boolean continuous = false;
    private static boolean debug = false;
    private static long delay = 100L;
    private static String file = null;
    private static String hostname = "localhost";
    private static int port = 7777;
    private static boolean ssl = false;
    private IOInterface iosock = null;
    private SampleSocketThread reader = new SampleSocketThread(this);

    public static String help() {
        return "\nParameters:\n -?                this help message\n -h hostname       host name\n -p port           port number\n -ssl              turn SSL on for all connections\n -f file           file with content to send to remote host\n -c                continuous sending file content\n -t millis         delay between sending file content\n -v                prints server version info\n -d [true|false]   turn on|off debug mode\n";
    }

    public static void main(String[] args) throws Exception {
        TelnetServer.parseParams(args);
        if (debug) {
            TelnetServer.turnDebugOn();
        }
        if (ssl) {
            LinkedHashMap<String, Object> tls_params = new LinkedHashMap<String, Object>();
            tls_params.put("keys-store", "certs/keystore");
            tls_params.put("keys-store-password", "keystore");
            tls_params.put("trusts-store", "certs/truststore");
            tls_params.put("trusts-store-password", "truststore");
            TLSUtil.configureSSLContext(tls_params);
        }
        TelnetServer server = new TelnetServer(port);
        server.run();
    }

    public static void parseParams(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-?")) {
                    System.out.print(TelnetServer.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(TelnetServer.version());
                    System.exit(0);
                }
                if (args[i].equals("-f")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetServer.help());
                        System.exit(1);
                    } else {
                        file = args[++i];
                    }
                }
                if (args[i].equals("-h")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetServer.help());
                        System.exit(1);
                    } else {
                        hostname = args[++i];
                    }
                }
                if (args[i].equals("-p")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetServer.help());
                        System.exit(1);
                    } else {
                        port = Integer.decode(args[++i]);
                    }
                }
                if (args[i].equals("-d")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        debug = true;
                    } else {
                        boolean bl = debug = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (args[i].equals("-c")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        continuous = true;
                    } else {
                        boolean bl = continuous = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (!args[i].equals("-ssl")) continue;
                ssl = i + 1 == args.length || args[i + 1].startsWith("-") ? true : args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
            }
        }
    }

    public static void turnDebugOn() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(".level", "ALL");
        properties.put("handlers", "java.util.logging.ConsoleHandler");
        properties.put("java.util.logging.ConsoleHandler.formatter", LogFormatter.class.getName());
        properties.put("java.util.logging.ConsoleHandler.level", "ALL");
        Set entries = properties.entrySet();
        StringBuilder buff = new StringBuilder();
        for (Map.Entry entry : entries) {
            buff.append((String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buff.toString().getBytes());
            LogManager.getLogManager().readConfiguration(bis);
            bis.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not configure logManager", e);
        }
    }

    public static String version() {
        return "\n-- \nTigase XMPP Telnet, version: " + TelnetServer.class.getPackage().getImplementationVersion() + "\nAuthor:  Artur Hefczyc <artur.hefczyc@tigase.org>\n-- \n";
    }

    public TelnetServer(int port) throws IOException {
        this.reader.start();
        this.reader.addForAccept(new InetSocketAddress(port));
    }

    @Override
    public void handleIOInterface(IOInterface ioifc) throws IOException {
        ByteBuffer socketInput = ByteBuffer.allocate(ioifc.getSocketChannel().socket().getReceiveBufferSize());
        ByteBuffer tmpBuffer = ioifc.read(socketInput);
        if (ioifc.bytesRead() > 0) {
            tmpBuffer.flip();
            CharBuffer cb = coder.decode(tmpBuffer);
            tmpBuffer.clear();
            if (cb != null) {
                System.out.print(new String(cb.array()));
            }
        }
        if (!ioifc.isConnected()) {
            throw new EOFException("Channel has been closed.");
        }
        this.reader.addIOInterface(ioifc);
    }

    @Override
    public void handleSocketAccept(SocketChannel sc) throws IOException {
        this.iosock = new SocketIO(sc);
        if (ssl) {
            SSLContextContainerIfc sslContextContainer = TLSUtil.getRootSslContextContainer();
            this.iosock = new TLSIO(this.iosock, new JcaTLSWrapper(sslContextContainer.getSSLContext("SSL", null, false), null, null, 0, false, false), ByteOrder.BIG_ENDIAN);
        }
        this.reader.addIOInterface(this.iosock);
        if (file != null) {
            FileReader fr = new FileReader(file);
            char[] file_buff = new char[65536];
            int res = -1;
            while ((res = fr.read(file_buff)) != -1) {
                ByteBuffer dataBuffer = coder.encode(CharBuffer.wrap(file_buff, 0, res));
                this.iosock.write(dataBuffer);
            }
            fr.close();
        }
    }

    public void run() throws IOException {
        InputStreamReader isr = new InputStreamReader(System.in);
        char[] buff = new char[1024];
        while (true) {
            int res = isr.read(buff);
            if (this.iosock != null) {
                ByteBuffer dataBuffer = coder.encode(CharBuffer.wrap(buff, 0, res));
                this.iosock.write(dataBuffer);
                continue;
            }
            System.err.println("Can't write to socket, no open socket.");
        }
    }
}

