/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;

public class JcaTLSWrapper
implements TLSWrapper {
    private static final Logger log = Logger.getLogger(JcaTLSWrapper.class.getName());
    private int appBuffSize = 0;
    private String debugId = null;
    private TLSEventHandler eventHandler = null;
    private int netBuffSize = 0;
    protected SSLEngine tlsEngine = null;
    private SSLEngineResult tlsEngineResult = null;
    private InternalHandshakeStatus handshakeStatus = InternalHandshakeStatus.handshaking;

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth) {
        this(sslc, eventHandler, hostname, port, clientMode, wantClientAuth, false);
    }

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth) {
        this(sslc, eventHandler, hostname, port, clientMode, wantClientAuth, needClientAuth, null, null);
    }

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String remote_hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth, String[] enabledCiphers, String[] enabledProtocols) {
        this.tlsEngine = clientMode && remote_hostname != null ? sslc.createSSLEngine(remote_hostname, port) : sslc.createSSLEngine();
        this.tlsEngine.setUseClientMode(clientMode);
        if (enabledCiphers != null) {
            this.tlsEngine.setEnabledCipherSuites(enabledCiphers);
        }
        if (enabledProtocols != null) {
            this.tlsEngine.setEnabledProtocols(enabledProtocols);
        }
        this.netBuffSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBuffSize = Math.min(eventHandler.getSocketInputSize(), this.tlsEngine.getSession().getApplicationBufferSize());
        this.eventHandler = eventHandler;
        if (!clientMode && wantClientAuth) {
            this.tlsEngine.setWantClientAuth(true);
        }
        if (!clientMode && needClientAuth) {
            this.tlsEngine.setNeedClientAuth(true);
        }
        if (log.isLoggable(Level.FINE)) {
            String mode = clientMode ? "client" : "server";
            String enabledCiphersDebug = this.tlsEngine.getEnabledCipherSuites() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledCipherSuites());
            String enabledProtocolsDebug = this.tlsEngine.getEnabledProtocols() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledProtocols());
            String sessionCipher = this.tlsEngine.getSession() == null ? "n/a" : this.tlsEngine.getSession().getCipherSuite();
            log.log(Level.FINE, "Created {0} TLSWrapper. Protocols: {1}; Ciphers: {2}; Session cipher: {3}", new Object[]{mode, enabledProtocolsDebug, enabledCiphersDebug, sessionCipher});
        }
    }

    protected void tlsEngineHandshakeCompleted() {
        if (this.handshakeStatus == InternalHandshakeStatus.handshaking) {
            this.handshakeStatus = InternalHandshakeStatus.finished;
        } else {
            log.log(Level.FINEST, "Handshake completed, already reported [{0}]", new Object[]{this.debugId});
        }
    }

    @Override
    public void notifyIfHandshakeFinished() {
        if (this.handshakeStatus == InternalHandshakeStatus.finished) {
            this.handshakeStatus = InternalHandshakeStatus.not_handshaking;
            if (log.isLoggable(Level.FINE)) {
                SSLSession session = null;
                try {
                    session = this.tlsEngine.getHandshakeSession();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (session != null && session.isValid()) {
                    log.log(Level.FINE, "Handshake completed with: {1}, cipher: {2}, application protocol: {3} [{0}]", new Object[]{this.debugId, session.getProtocol(), session.getCipherSuite(), this.tlsEngine.getApplicationProtocol()});
                } else {
                    log.log(Level.FINEST, "Handshake completed, but details are unavailable [{0}]", new Object[]{this.debugId});
                }
            }
            this.eventHandler.handshakeCompleted(this);
        }
    }

    @Override
    public int bytesConsumed() {
        return this.tlsEngineResult.bytesConsumed();
    }

    @Override
    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
        this.tlsEngine.getSession().invalidate();
    }

    @Override
    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    @Override
    public CertCheckResult getCertificateStatus(boolean revocationEnabled, SSLContextContainerIfc sslContextContainer) {
        Certificate[] peerChain = null;
        try {
            peerChain = this.tlsEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            return CertCheckResult.none;
        }
        try {
            return CertificateUtil.validateCertificate((Certificate[])peerChain, (KeyStore)sslContextContainer.getTrustStore(), (boolean)revocationEnabled);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem validating certificate", ex);
            return CertCheckResult.invalid;
        }
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.tlsEngine.getHandshakeStatus();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.tlsEngine.getSession().getLocalCertificates();
    }

    @Override
    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    @Override
    public int getPacketBuffSize() {
        return this.tlsEngine.getSession().getPacketBufferSize();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.tlsEngine.getSession().getPeerCertificates();
    }

    @Override
    public TLSStatus getStatus() {
        TLSStatus status = null;
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            status = TLSStatus.UNDERFLOW;
        } else if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            status = TLSStatus.CLOSED;
        } else {
            switch (this.tlsEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    status = TLSStatus.NEED_WRITE;
                    break;
                }
                case NEED_UNWRAP: {
                    status = TLSStatus.NEED_READ;
                    break;
                }
                default: {
                    status = TLSStatus.OK;
                }
            }
        }
        return status;
    }

    @Override
    public byte[] getTlsUniqueBindingData() {
        return null;
    }

    @Override
    public byte[] getTlsExporterBindingData() {
        return null;
    }

    @Override
    public boolean isClientMode() {
        return this.tlsEngine.getUseClientMode();
    }

    @Override
    public boolean isNeedClientAuth() {
        return this.tlsEngine.getNeedClientAuth();
    }

    @Override
    public void setDebugId(String id) {
        this.debugId = id;
    }

    @Override
    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        out.order(app.order());
        this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "unwrap() tlsEngineResult.getStatus() = {1}, tlsEngineResult.getHandshakeStatus() = {2} [{0}]", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.tlsEngineHandshakeCompleted();
            this.notifyIfHandshakeFinished();
        }
        if (this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            out = this.resizeApplicationBuffer(net, out);
            this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "unwrap() doTasks(), handshake: {1} [{0}]", new Object[]{this.debugId, this.tlsEngine.getHandshakeStatus()});
            }
        }
        return out;
    }

    @Override
    public boolean wantClientAuth() {
        return this.tlsEngine.getWantClientAuth();
    }

    @Override
    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2} [{0}]", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.tlsEngineHandshakeCompleted();
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "doTasks(): {1} [{0}]", new Object[]{this.debugId, this.tlsEngine.getHandshakeStatus()});
            }
        }
    }

    private void doTasks() {
        Runnable runnable = null;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer net, ByteBuffer app) {
        int newSize = app.capacity() * 2;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Resizing tlsInput to {1} bytes [{0}]", new Object[]{this.debugId, newSize});
        }
        ByteBuffer bb = ByteBuffer.allocate(newSize);
        bb.order(app.order());
        app.flip();
        bb.put(app);
        return bb;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", JcaTLSWrapper.class.getSimpleName() + "[", "]").add("WrapperStatus = " + String.valueOf((Object)this.getStatus()));
        if (this.tlsEngineResult != null) {
            joiner.add("TLSEngineStatus = " + String.valueOf((Object)this.tlsEngineResult.getStatus())).add("HandshakeStatus = " + String.valueOf((Object)this.tlsEngineResult.getHandshakeStatus()));
        }
        return joiner.toString();
    }

    static enum InternalHandshakeStatus {
        handshaking,
        finished,
        not_handshaking;

    }
}

