/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.Repository;
import tigase.util.Version;
import tigase.xml.db.XMLDB;

@Repository.Meta(supportedUris={"memory://.*"})
public class XMLDataSource
implements DataSource {
    private static final Logger log = Logger.getLogger(XMLDataSource.class.getCanonicalName());
    private String resource_uri;
    private XMLDB xmldb;

    @Override
    public Optional<Version> getSchemaVersion(String component) {
        return Optional.empty();
    }

    @Override
    public String getResourceUri() {
        return this.resource_uri;
    }

    @Override
    public void initialize(String file) throws RepositoryException {
        this.initRepository(file, new HashMap<String, String>());
    }

    @Override
    @Deprecated
    public void initRepository(String file, Map<String, String> params) throws DBInitException {
        this.resource_uri = file;
        String file_name = file;
        log.log(Level.FINEST, "Initializing repository, file: {0}, params: {1}", new Object[]{file, params});
        try {
            int idx = file.indexOf("?");
            if (idx > 0) {
                file_name = file.substring(0, idx);
            }
            this.xmldb = new XMLDB(file_name);
        }
        catch (Exception e) {
            log.warning("Can not open existing user repository file, creating new one, " + String.valueOf(e));
            this.xmldb = XMLDB.createDB((String)file_name, (String)"users", (String)"user");
        }
    }

    public XMLDB getXMLDB() {
        return this.xmldb;
    }
}

