/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.locker;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.db.util.JDBCPasswordObfuscator;
import tigase.db.util.locker.MssqlConnectionLock;
import tigase.db.util.locker.MysqlConnectionLock;
import tigase.db.util.locker.PostgresqlConnectionLock;

public abstract class ConnectionLock {
    static final Logger log = Logger.getLogger(ConnectionLock.class.getCanonicalName());
    protected boolean isLocked = false;
    protected String jdbcConnection;
    protected int lockAttemptDelay = 1000;
    protected int lockAttemptsLimit = 10;
    String lockName = "tigase";
    private Connection connection;

    public static Optional<ConnectionLock> getConnectionLocker(String db_conn) throws IllegalArgumentException {
        DataRepository.dbTypes dbType = DataRepositoryImpl.parseDatabaseType(db_conn);
        if (dbType == null) {
            return Optional.empty();
        }
        ConnectionLock connectionLock = null;
        switch (dbType) {
            case postgresql: {
                connectionLock = new PostgresqlConnectionLock(db_conn);
                break;
            }
            case mysql: {
                connectionLock = new MysqlConnectionLock(db_conn);
                break;
            }
            case jtds: 
            case sqlserver: {
                connectionLock = new MssqlConnectionLock(db_conn);
                break;
            }
            default: {
                log.log(Level.WARNING, "Database locking is not supported for: " + String.valueOf((Object)dbType));
            }
        }
        return Optional.ofNullable(connectionLock);
    }

    protected ConnectionLock(String db_conn) {
        this.jdbcConnection = db_conn;
        try {
            this.connection = DriverManager.getConnection(db_conn);
            log.log(Level.INFO, "Prepared connection for locking");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed preparing connection for locking: " + e.getMessage());
        }
    }

    public boolean lock() {
        log.log(Level.INFO, "Trying to get lock for database, current state: " + this.isLocked);
        if (this.connection == null) {
            log.log(Level.WARNING, "No connection available!");
            return false;
        }
        if (this.isLocked) {
            log.log(Level.WARNING, "Connection already locked!");
            return false;
        }
        boolean gotLocked = false;
        for (int attempt = 0; !gotLocked && attempt < this.lockAttemptsLimit; ++attempt) {
            log.log(Level.FINEST, "Trying to get lock for database, attempt {0} of {1}", new Object[]{attempt, this.lockAttemptsLimit});
            gotLocked = this.lockDatabase(this.connection);
            if (!this.isLocked && gotLocked) {
                this.isLocked = true;
                break;
            }
            this.wait(this.lockAttemptDelay);
        }
        if (this.isLocked) {
            log.log(Level.INFO, "Obtained lock for connection: " + JDBCPasswordObfuscator.obfuscatePassword(this.jdbcConnection));
        } else {
            log.log(Level.WARNING, "FAILED to obtain lock for connection: " + JDBCPasswordObfuscator.obfuscatePassword(this.jdbcConnection));
        }
        return this.isLocked;
    }

    public boolean unlock() {
        boolean gotUnlocked = false;
        if (this.connection == null) {
            log.log(Level.WARNING, "No connection available!");
            return false;
        }
        if (this.isLocked) {
            log.log(Level.INFO, "Unlocking database");
            for (int attempt = 0; !gotUnlocked && attempt < this.lockAttemptsLimit; ++attempt) {
                log.log(Level.FINEST, "Trying to unlock the database, attempt {0} of {1}", new Object[]{attempt, this.lockAttemptsLimit});
                gotUnlocked = this.unlockDatabase(this.connection);
                if (this.isLocked && gotUnlocked) {
                    this.isLocked = false;
                    break;
                }
                this.wait(this.lockAttemptDelay);
            }
        } else {
            log.log(Level.INFO, "Connection was not locked, skipping unlocking ");
        }
        return gotUnlocked;
    }

    public void cleanup() {
        if (!this.isLocked && this.connection != null) {
            try {
                log.log(Level.INFO, "Closing lock connection");
                this.connection.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed closing connection", e);
            }
        }
    }

    public boolean isLocked() {
        log.log(Level.FINE, "Lock state: " + this.isLocked);
        return this.isLocked;
    }

    protected abstract boolean lockDatabase(Connection var1);

    protected void release(Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINEST, "Failed to release ResultSet or Statement");
        }
    }

    protected abstract boolean unlockDatabase(Connection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeQuery(Connection connection, String query) {
        boolean isLocked = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                isLocked = resultSet.getBoolean(1);
            }
            this.release(statement, resultSet);
        }
        catch (Exception e) {
            try {
                log.log(Level.WARNING, e.getMessage(), e);
                this.release(statement, resultSet);
            }
            catch (Throwable throwable) {
                this.release(statement, resultSet);
                throw throwable;
            }
        }
        return isLocked;
    }

    private void wait(int delay) {
        try {
            TimeUnit.MILLISECONDS.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

