/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.XmppSaslException;
import tigase.auth.credentials.Credentials;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(isDefault=true, supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class TigaseCustomAuth
extends AbstractAuthRepositoryWithCredentials
implements DataSourceAware<DataRepository>,
RepositoryVersionAware {
    public static final String DEF_CONNVALID_KEY = "conn-valid-query";
    public static final String DEF_INITDB_KEY = "init-db-query";
    public static final String DEF_ADDUSER_KEY = "add-user-query";
    public static final String DEF_DELUSER_KEY = "del-user-query";
    public static final String DEF_GETPASSWORD_KEY = "get-password-query";
    public static final String DEF_UPDATEPASSWORD_KEY = "update-password-query";
    public static final String DEF_USERLOGIN_KEY = "user-login-query";
    public static final String DEF_USERLOGOUT_KEY = "user-logout-query";
    public static final String DEF_UPDATELOGINTIME_KEY = "update-login-time-query";
    public static final String DEF_USERS_COUNT_KEY = "users-count-query";
    public static final String DEF_ACTIVE_USERS_COUNT_KEY = "active-users-count-query";
    public static final String DEF_USERS_DOMAIN_COUNT_KEY = "users-domain-count-query";
    public static final String DEF_LISTDISABLEDACCOUNTS_KEY = "users-list-disabled-accounts-query";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String DEF_DISABLEACCOUNT_KEY = "user-disable-account-query";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String DEF_ENABLEACCOUNT_KEY = "user-enable-account-query";
    public static final String DEF_UPDATEACCOUNTSTATUS_KEY = "user-update-account-status-query";
    public static final String DEF_ACCOUNTSTATUS_KEY = "user-account-status-query";
    public static final String DEF_NONSASL_MECHS_KEY = "non-sasl-mechs";
    public static final String DEF_SASL_MECHS_KEY = "sasl-mechs";
    public static final String NO_QUERY = "none";
    public static final String DEF_INITDB_QUERY = "{ call TigInitdb() }";
    public static final String DEF_ADDUSER_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    public static final String DEF_DELUSER_QUERY = "{ call TigRemoveUser(?) }";
    public static final String DEF_GETPASSWORD_QUERY = "{ call TigGetPassword(?) }";
    public static final String DEF_USERS_COUNT_QUERY = "{ call TigAllUsersCount() }";
    public static final String DEF_ACTIVE_USERS_COUNT_QUERY = "select count(*) from tig_users where last_used > ?";
    public static final String DEF_USERS_DOMAIN_COUNT_QUERY = "select count(*) from tig_users where user_id like ?";
    public static final String DEF_LISTDISABLEDACCOUNTS_QUERY = "{ call TigDisabledAccounts() }";
    public static final String DEF_UPDATEACCOUNTSTATUS_QUERY = "{ call TigUpdateAccountStatus(?, ?) }";
    public static final String DEF_ACCOUNTSTATUS_QUERY = "{ call TigAccountStatus(?) }";
    public static final String DEF_NONSASL_MECHS = "password";
    public static final String DEF_SASL_MECHS = "PLAIN";
    public static final String SP_STARTS_WITH = "{ call";
    private static final Logger log = Logger.getLogger(TigaseCustomAuth.class.getName());
    private static final String DEF_UPDATELOGINTIME_QUERY = "{ call TigUpdateLoginTime(?) }";
    @ConfigField(desc="Checks account status", alias="user-account-status-query")
    private String accountstatus_query = "{ call TigAccountStatus(?) }";
    @ConfigField(desc="Query adding a new user to the database", alias="add-user-query")
    private String adduser_query = "{ call TigAddUserPlainPw(?, ?) }";
    private DataRepository data_repo = null;
    @ConfigField(desc="Removes a user from the database", alias="del-user-query")
    private String deluser_query = "{ call TigRemoveUser(?) }";
    @ConfigField(desc="Select list of credentials for account and credential-id", alias="get-account-credentials-query")
    private String getaccountcredentials_query = "{ call TigUserCredentials_Get(?,?) }";
    @ConfigField(desc="Select list of credential IDs for account", alias="get-account-credentialids-query")
    private String getaccountcredentialids_query = "{ call TigUserUsernames_Get(?) }";
    @ConfigField(desc="Database initialization query which is run after the server is started", alias="init-db-query")
    private String initdb_query = null;
    @ConfigField(desc="Lists disabled accounts", alias="users-list-disabled-accounts-query")
    private String listdisabledaccounts_query = "{ call TigDisabledAccounts() }";
    @ConfigField(desc="Comma separated list of NON-SASL authentication mechanisms", alias="non-sasl-mechs")
    private String[] nonsasl_mechs = "password".split(",");
    @ConfigField(desc="Remove credential for account and credential ID", alias="remove-account-credential-query")
    private String removeaccountcredential_query = "{ call TigUserCredential_Remove(?,?) }";
    @ConfigField(desc="Comma separated list of SASL authentication mechanisms", alias="sasl-mechs")
    private String[] sasl_mechs = "PLAIN".split(",");
    @ConfigField(desc="Update credential for account and credential ID", alias="update-account-credential-query")
    private String updateaccountcredential_query = "{ call TigUserCredential_Update(?,?,?,?) }";
    @ConfigField(desc="Updates (changes) account status", alias="user-update-account-status-query")
    private String updateaccountstatus_query = "{ call TigUpdateAccountStatus(?, ?) }";
    @ConfigField(desc="Updates last login/logout timestamps", alias="update-login-time-query")
    private String updatelastlogin_query = "{ call TigUpdateLoginTime(?) }";
    @ConfigField(desc="Count users for domain", alias="users-domain-count-query")
    private String userdomaincount_query = "select count(*) from tig_users where user_id like ?";
    private boolean userlogin_active = false;
    @ConfigField(desc="Performs user login", alias="user-login-query")
    private String userlogin_query = null;
    @ConfigField(desc="Performs user logout", alias="user-logout-query")
    private String userlogout_query = null;
    @ConfigField(desc="Counts users", alias="users-count-query")
    private String userscount_query = "{ call TigAllUsersCount() }";
    @ConfigField(desc="Counts active users in defined period of time", alias="active-users-count-query")
    private String active_users_count_query = "select count(*) from tig_users where last_used > ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(BareJID user, String password) throws TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding account: {0}", new Object[]{user});
        }
        if (this.adduser_query == null) {
            return;
        }
        try {
            PreparedStatement add_user;
            ResultSet rs = null;
            PreparedStatement preparedStatement = add_user = this.data_repo.getPreparedStatement(user, this.adduser_query);
            synchronized (preparedStatement) {
                try {
                    add_user.setString(1, user.toString());
                    add_user.setString(2, password);
                    boolean is_result = add_user.execute();
                    if (is_result) {
                        rs = add_user.getResultSet();
                    }
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
            this.updateCredential(user, "default", password);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user possibly exists: " + String.valueOf(user), e);
        }
        catch (SQLException e) {
            if (e.getMessage() != null && (e.getMessage().contains("Violation of UNIQUE KEY") || e.getMessage().contains("violates unique constraint \"user_id\"")) || e.getMessage().contains("DerbySQLIntegrityConstraintViolationException")) {
                throw new UserExistsException("Error while adding user to repository, user possibly exists: " + String.valueOf(user), e);
            }
            throw new TigaseDBException("Problem accessing repository for user: " + String.valueOf(user), e);
        }
    }

    private boolean digestAuth(BareJID user, String digest, String id, String alg) throws TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            throw new AuthorizationException("Not supported.");
        }
        String db_password = this.getPassword(user);
        try {
            String digest_db_pass = Algorithms.hexDigest((String)id, (String)db_password, (String)alg);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Comparing passwords, given: {0}, db: {1}", new Object[]{digest, digest_db_pass});
            }
            return digest.equals(digest_db_pass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("No such algorithm.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        if (this.accountstatus_query == null) {
            return null;
        }
        try {
            PreparedStatement get_status;
            ResultSet rs = null;
            PreparedStatement preparedStatement = get_status = this.data_repo.getPreparedStatement(user, this.accountstatus_query);
            synchronized (preparedStatement) {
                block9: {
                    AuthRepository.AccountStatus accountStatus;
                    try {
                        get_status.setString(1, user.toString());
                        rs = get_status.executeQuery();
                        if (!rs.next()) break block9;
                        int v = rs.getInt(1);
                        AuthRepository.AccountStatus accountStatus2 = AuthRepository.AccountStatus.byValue(v);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Got account: {0} status: {1}", new Object[]{user, accountStatus2});
                        }
                        accountStatus = accountStatus2;
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    return accountStatus;
                }
                throw new UserNotFoundException("User does not exist: " + String.valueOf(user));
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving account status.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials(final BareJID user, String credentialId) throws TigaseDBException {
        if (this.userlogin_active) {
            return new AuthRepository.SingleCredential(user, this.getAccountStatus(user), new Credentials.Entry(){

                @Override
                public String getMechanism() {
                    return "STORED-PROCEDURE";
                }

                @Override
                public boolean verifyPlainPassword(String password) {
                    try {
                        return TigaseCustomAuth.this.userLoginAuth(user, password);
                    }
                    catch (AuthorizationException | TigaseDBException e) {
                        log.log(Level.FINEST, "authorization failed with an error", e);
                        return false;
                    }
                }
            });
        }
        try {
            PreparedStatement get_credentials = this.data_repo.getPreparedStatement(user, this.getaccountcredentials_query);
            ArrayList<AuthRepository.DefaultCredentials.RawEntry> entries = new ArrayList<AuthRepository.DefaultCredentials.RawEntry>();
            AuthRepository.AccountStatus accountStatus = null;
            PreparedStatement preparedStatement = get_credentials;
            synchronized (preparedStatement) {
                ResultSet rs = null;
                try {
                    get_credentials.setString(1, user.toString());
                    get_credentials.setString(2, credentialId);
                    rs = get_credentials.executeQuery();
                    while (rs.next()) {
                        String mechanism = rs.getString(1);
                        String value = rs.getString(2);
                        accountStatus = AuthRepository.AccountStatus.byValue(rs.getInt(3));
                        entries.add(new AuthRepository.DefaultCredentials.RawEntry(mechanism, value));
                    }
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
            if (accountStatus == null && entries.isEmpty()) {
                throw new UserNotFoundException("No credentials found for the user: " + String.valueOf(user) + " (credential ID: " + credentialId + ")");
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Got account: {0} credentials: {1}", new Object[]{user, accountStatus});
            }
            return new AuthRepository.DefaultCredentials(user, accountStatus, entries, this.getCredentialsDecoder());
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving credentials for account " + String.valueOf(user) + " and credential ID " + credentialId, e);
        }
    }

    protected String getParamWithDef(Map<String, String> params, String key, String def) {
        if (params == null) {
            return def;
        }
        String result = params.get(key);
        if (result != null) {
            log.log(Level.CONFIG, "Custom query loaded for ''{0}'': ''{1}''", new Object[]{key, result});
        } else {
            result = def;
            log.log(Level.CONFIG, "Default query loaded for ''{0}'': ''{1}''", new Object[]{key, def});
        }
        if (result != null && ((result = result.trim()).isEmpty() || result.equals(NO_QUERY))) {
            result = null;
        }
        return result;
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getCredentialIds(BareJID user) throws TigaseDBException {
        try {
            PreparedStatement credentialIdsStatement = this.data_repo.getPreparedStatement(user, this.getaccountcredentialids_query);
            ArrayList<String> result = new ArrayList<String>();
            PreparedStatement preparedStatement = credentialIdsStatement;
            synchronized (preparedStatement) {
                ResultSet rs = null;
                try {
                    credentialIdsStatement.setString(1, user.toString());
                    rs = credentialIdsStatement.executeQuery();
                    while (rs.next()) {
                        String credentialId = rs.getString(1);
                        result.add(credentialId);
                    }
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Account: {0} has credentialId: {1}", new Object[]{user, result});
            }
            return result;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving credential IDs for account " + String.valueOf(user), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveUsersCountIn(Duration duration) {
        if (this.active_users_count_query == null) {
            return -1L;
        }
        try {
            PreparedStatement active_users_count;
            long users = -1L;
            ResultSet rs = null;
            PreparedStatement preparedStatement = active_users_count = this.data_repo.getPreparedStatement(null, this.active_users_count_query);
            synchronized (preparedStatement) {
                try {
                    Instant instant = Instant.now().minus(duration);
                    active_users_count.setTimestamp(1, Timestamp.from(instant));
                    rs = active_users_count.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        if (this.userscount_query == null) {
            return -1L;
        }
        try {
            PreparedStatement users_count;
            long users = -1L;
            ResultSet rs = null;
            PreparedStatement preparedStatement = users_count = this.data_repo.getPreparedStatement(null, this.userscount_query);
            synchronized (preparedStatement) {
                try {
                    rs = users_count.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        if (this.userdomaincount_query == null) {
            return -1L;
        }
        try {
            PreparedStatement users_domain_count;
            long users = -1L;
            ResultSet rs = null;
            PreparedStatement preparedStatement = users_domain_count = this.data_repo.getPreparedStatement(null, this.userdomaincount_query);
            synchronized (preparedStatement) {
                try {
                    users_domain_count.setString(1, "%@" + domain);
                    rs = users_domain_count.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        PreparedStatement init_db;
        if (this.initdb_query == null) {
            return;
        }
        PreparedStatement preparedStatement = init_db = this.data_repo.getPreparedStatement(null, this.initdb_query);
        synchronized (preparedStatement) {
            init_db.executeUpdate();
        }
    }

    @Override
    @Deprecated
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            this.initdb_query = this.getParamWithDef(params, DEF_INITDB_KEY, null);
            this.adduser_query = this.getParamWithDef(params, DEF_ADDUSER_KEY, DEF_ADDUSER_QUERY);
            this.deluser_query = this.getParamWithDef(params, DEF_DELUSER_KEY, DEF_DELUSER_QUERY);
            this.userlogin_query = this.getParamWithDef(params, DEF_USERLOGIN_KEY, null);
            this.userlogout_query = this.getParamWithDef(params, DEF_USERLOGOUT_KEY, null);
            this.updatelastlogin_query = this.getParamWithDef(params, DEF_UPDATELOGINTIME_KEY, DEF_UPDATELOGINTIME_QUERY);
            this.userscount_query = this.getParamWithDef(params, DEF_USERS_COUNT_KEY, DEF_USERS_COUNT_QUERY);
            this.active_users_count_query = this.getParamWithDef(params, DEF_ACTIVE_USERS_COUNT_KEY, DEF_ACTIVE_USERS_COUNT_QUERY);
            this.userdomaincount_query = this.getParamWithDef(params, DEF_USERS_DOMAIN_COUNT_KEY, DEF_USERS_DOMAIN_COUNT_QUERY);
            this.listdisabledaccounts_query = this.getParamWithDef(params, DEF_LISTDISABLEDACCOUNTS_KEY, DEF_LISTDISABLEDACCOUNTS_QUERY);
            this.updateaccountstatus_query = this.getParamWithDef(params, DEF_UPDATEACCOUNTSTATUS_KEY, DEF_UPDATEACCOUNTSTATUS_QUERY);
            this.accountstatus_query = this.getParamWithDef(params, DEF_ACCOUNTSTATUS_KEY, DEF_ACCOUNTSTATUS_QUERY);
            this.nonsasl_mechs = this.getParamWithDef(params, DEF_NONSASL_MECHS_KEY, DEF_NONSASL_MECHS).split(",");
            this.sasl_mechs = this.getParamWithDef(params, DEF_SASL_MECHS_KEY, DEF_SASL_MECHS).split(",");
            if (this.data_repo == null) {
                DataRepository dataRepo = RepositoryFactory.getDataRepository(null, connection_str, params);
                dataRepo.checkSchemaVersion(this, true);
                this.setDataSource(dataRepo);
            }
            if (params != null && params.get("init-db") != null) {
                this.initDb();
            }
        }
        catch (Exception e) {
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        if (DEF_SASL_MECHS.equals(mechanism)) {
            return true;
        }
        if (this.userlogin_active) {
            return false;
        }
        return super.isMechanismSupported(domain, mechanism);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        block6: {
            if (this.updatelastlogin_query == null) {
                return;
            }
            try {
                PreparedStatement ps = this.data_repo.getPreparedStatement(user, this.updatelastlogin_query);
                if (ps == null) break block6;
                PreparedStatement preparedStatement = ps;
                synchronized (preparedStatement) {
                    ps.setString(1, user.toString());
                    ps.execute();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Problem accessing repository.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(BareJID user) throws TigaseDBException {
        block6: {
            if (this.userlogout_query == null) {
                return;
            }
            try {
                PreparedStatement user_logout = this.data_repo.getPreparedStatement(user, this.userlogout_query);
                if (user_logout == null) break block6;
                PreparedStatement preparedStatement = user_logout;
                synchronized (preparedStatement) {
                    user_logout.setString(1, user.toString());
                    user_logout.execute();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Problem accessing repository.", e);
            }
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals(DEF_SASL_MECHS)) {
                try {
                    if (this.saslPlainAuth(props)) {
                        return true;
                    }
                    throw new AuthorizationException("Authentication failed.");
                }
                catch (TigaseStringprepException ex) {
                    throw new AuthorizationException("Stringprep failed for: " + String.valueOf(props), ex);
                }
            }
            return this.saslAuth(props);
        }
        if (proto.equals("nonsasl")) {
            String password = (String)props.get(DEF_NONSASL_MECHS);
            BareJID user_id = (BareJID)props.get("user-id");
            if (password != null) {
                return this.plainAuth(user_id, password);
            }
            String digest = (String)props.get("digest");
            if (digest != null) {
                String digest_id = (String)props.get("digest-id");
                return this.digestAuth(user_id, digest, digest_id, "SHA");
            }
        }
        throw new AuthorizationException("Protocol is not supported.");
    }

    private boolean plainAuth(BareJID user, String password) throws TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            return this.userLoginAuth(user, password);
        }
        String db_password = this.getPassword(user);
        return password != null && db_password != null && db_password.equals(password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", this.nonsasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", this.sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredential(BareJID user, String credentialId) throws TigaseDBException {
        try {
            PreparedStatement removeCredential_stmt;
            PreparedStatement preparedStatement = removeCredential_stmt = this.data_repo.getPreparedStatement(user, this.removeaccountcredential_query);
            synchronized (preparedStatement) {
                removeCredential_stmt.setString(1, user.toString());
                removeCredential_stmt.setString(2, credentialId);
                removeCredential_stmt.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(BareJID user) throws TigaseDBException {
        if (this.deluser_query == null) {
            return;
        }
        try {
            PreparedStatement remove_user;
            PreparedStatement preparedStatement = remove_user = this.data_repo.getPreparedStatement(user, this.deluser_query);
            synchronized (preparedStatement) {
                remove_user.setString(1, user.toString());
                remove_user.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            byte[] in_data;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] byArray = in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "response: {0}", new String(in_data));
            }
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "challenge: {0}", challenge != null ? new String(challenge) : "null");
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    private boolean saslPlainAuth(Map<String, Object> props) throws TigaseDBException, AuthorizationException, TigaseStringprepException {
        int user_idx;
        int auth_idx;
        String data_str = (String)props.get("data");
        String domain = (String)props.get("realm");
        props.put("result", null);
        byte[] in_data = data_str != null ? Base64.decode((String)data_str) : new byte[]{};
        for (auth_idx = 0; in_data[auth_idx] != 0 && auth_idx < in_data.length; ++auth_idx) {
        }
        String authoriz = new String(in_data, 0, auth_idx);
        for (user_idx = ++auth_idx; in_data[user_idx] != 0 && user_idx < in_data.length; ++user_idx) {
        }
        String user_name = new String(in_data, auth_idx, user_idx - auth_idx);
        BareJID jid = null;
        jid = BareJID.parseJID((String)user_name)[0] == null ? BareJID.bareJIDInstance((String)user_name, (String)domain) : BareJID.bareJIDInstance((String)user_name);
        props.put("user-id", jid);
        String passwd = new String(in_data, ++user_idx, in_data.length - user_idx);
        return this.plainAuth(jid, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus value) throws TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Setting account: {0} status to: {1}", new Object[]{user, value});
        }
        try {
            PreparedStatement changeState;
            PreparedStatement preparedStatement = changeState = this.data_repo.getPreparedStatement(user, this.updateaccountstatus_query);
            synchronized (preparedStatement) {
                changeState.setString(1, user.toString());
                changeState.setInt(2, value.getValue());
                changeState.execute();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINEST, "problem with changing user account state", e);
            throw new TigaseDBException("Problem with changing user account state", e);
        }
    }

    @Override
    public void setDataSource(DataRepository data_repo) throws DBInitException {
        try {
            if (this.initdb_query != null) {
                data_repo.initPreparedStatement(this.initdb_query, this.initdb_query);
            }
            if (this.adduser_query != null) {
                data_repo.initPreparedStatement(this.adduser_query, this.adduser_query);
            }
            if (this.deluser_query != null) {
                data_repo.initPreparedStatement(this.deluser_query, this.deluser_query);
            }
            if (this.userlogin_query != null) {
                data_repo.initPreparedStatement(this.userlogin_query, this.userlogin_query);
                this.userlogin_active = true;
            }
            if (this.userlogout_query != null) {
                data_repo.initPreparedStatement(this.userlogout_query, this.userlogout_query);
            }
            if (this.updatelastlogin_query != null) {
                data_repo.initPreparedStatement(this.updatelastlogin_query, this.updatelastlogin_query);
            }
            if (this.userscount_query != null) {
                data_repo.initPreparedStatement(this.userscount_query, this.userscount_query);
            }
            if (this.active_users_count_query != null) {
                data_repo.initPreparedStatement(this.active_users_count_query, this.active_users_count_query);
            }
            if (this.userdomaincount_query != null) {
                data_repo.initPreparedStatement(this.userdomaincount_query, this.userdomaincount_query);
            }
            if (this.listdisabledaccounts_query != null) {
                data_repo.initPreparedStatement(this.listdisabledaccounts_query, this.listdisabledaccounts_query);
            }
            if (this.updateaccountstatus_query != null) {
                data_repo.initPreparedStatement(this.updateaccountstatus_query, this.updateaccountstatus_query);
            }
            if (this.accountstatus_query != null) {
                data_repo.initPreparedStatement(this.accountstatus_query, this.accountstatus_query);
            }
            if (this.getaccountcredentials_query != null) {
                data_repo.initPreparedStatement(this.getaccountcredentials_query, this.getaccountcredentials_query);
            }
            if (this.getaccountcredentialids_query != null) {
                data_repo.initPreparedStatement(this.getaccountcredentialids_query, this.getaccountcredentialids_query);
            }
            if (this.removeaccountcredential_query != null) {
                data_repo.initPreparedStatement(this.removeaccountcredential_query, this.removeaccountcredential_query);
            }
            if (this.updateaccountcredential_query != null) {
                data_repo.initPreparedStatement(this.updateaccountcredential_query, this.updateaccountcredential_query);
            }
            this.data_repo = data_repo;
            if (this.initdb_query != null) {
                this.initDb();
            }
        }
        catch (SQLException ex) {
            data_repo = null;
            throw new DBInitException("Could not initialize TigaseCustomAuth instance", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredential(BareJID user, String credentialId, String password) throws TigaseDBException {
        List<String[]> entries = this.getCredentialsEncoder().encodeForAllMechanisms(user, password);
        try {
            PreparedStatement updateCredential_stmt;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Updating credentials for user: {0}, credentialId: {1}", new Object[]{user, credentialId});
            }
            this.removeCredential(user, credentialId);
            PreparedStatement preparedStatement = updateCredential_stmt = this.data_repo.getPreparedStatement(user, this.updateaccountcredential_query);
            synchronized (preparedStatement) {
                for (String[] entry : entries) {
                    updateCredential_stmt.setString(1, user.toString());
                    updateCredential_stmt.setString(2, credentialId);
                    updateCredential_stmt.setString(3, entry[0]);
                    updateCredential_stmt.setString(4, entry[1]);
                    updateCredential_stmt.addBatch();
                }
                updateCredential_stmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Problem accessing repository.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredential(BareJID user, String credentialId, String mechanism, String data) throws TigaseDBException {
        try {
            PreparedStatement updateCredential_stmt;
            PreparedStatement preparedStatement = updateCredential_stmt = this.data_repo.getPreparedStatement(user, this.updateaccountcredential_query);
            synchronized (preparedStatement) {
                updateCredential_stmt.setString(1, user.toString());
                updateCredential_stmt.setString(2, credentialId);
                updateCredential_stmt.setString(3, mechanism);
                updateCredential_stmt.setString(4, data);
                updateCredential_stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Problem accessing repository.", ex);
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        this.updateCredential(user, "default", password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userLoginAuth(BareJID user, String password) throws TigaseDBException, AuthorizationException {
        if (this.userlogin_query == null) {
            return false;
        }
        String res_string = null;
        try {
            PreparedStatement user_login;
            ResultSet rs = null;
            PreparedStatement preparedStatement = user_login = this.data_repo.getPreparedStatement(user, this.userlogin_query);
            synchronized (preparedStatement) {
                block13: {
                    block14: {
                        boolean bl;
                        try {
                            user_login.setString(1, user.toString());
                            user_login.setString(2, password);
                            switch (this.data_repo.getDatabaseType()) {
                                case sqlserver: {
                                    user_login.executeUpdate();
                                    rs = user_login.getGeneratedKeys();
                                    break;
                                }
                                default: {
                                    rs = user_login.executeQuery();
                                }
                            }
                            boolean auth_result_ok = false;
                            if (!rs.next()) break block13;
                            res_string = rs.getString(1);
                            if (res_string != null) {
                                BareJID result = BareJID.bareJIDInstance((String)res_string);
                                auth_result_ok = user.equals((Object)result);
                            }
                            if (!auth_result_ok) break block14;
                            bl = true;
                            this.data_repo.release(null, rs);
                        }
                        catch (Throwable throwable) {
                            this.data_repo.release(null, rs);
                            throw throwable;
                        }
                        return bl;
                    }
                    if (!log.isLoggable(Level.FINE)) break block13;
                    log.log(Level.FINE, "Login failed, for user: ''{0}'', password: ''{1}'', from DB got: {2}", new Object[]{user, password, res_string});
                }
                this.data_repo.release(null, rs);
                throw new UserNotFoundException("User does not exist: " + String.valueOf(user) + ", in database: " + this.getResourceUri());
            }
        }
        catch (TigaseStringprepException ex) {
            throw new AuthorizationException("Stringprep failed for: " + res_string, ex);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            BareJID jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "RealmCallback: {0}", realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = BareJID.bareJIDInstanceNS((String)user_name, (String)((String)this.options.get("realm")));
                    try {
                        AuthRepository.AccountStatus accountStatus = TigaseCustomAuth.this.getAccountStatus(jid);
                        if (accountStatus.isInactive()) {
                            throw XmppSaslException.getExceptionFor(accountStatus);
                        }
                    }
                    catch (TigaseDBException e) {
                        throw new IOException("Account Status retrieving problem.", e);
                    }
                    this.options.put("user-id", jid);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "NameCallback: {0}", user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = TigaseCustomAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.log(Level.FINEST, "PasswordCallback: {0}", passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
                    }
                    String authorId = authCallback.getAuthorizationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
                    }
                    if (!authenId.equals(authorId)) continue;
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

