/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import tigase.db.DataSourceAware;
import tigase.db.beans.MDRepositoryBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsInvocationHandler;
import tigase.stats.StatisticsList;

public abstract class MDRepositoryBeanWithStatistics<T extends DataSourceAware>
extends MDRepositoryBean<T>
implements ComponentStatisticsProvider {
    private final Class<?>[] repoInterfaces;
    private ConcurrentHashMap<String, StatisticsInvocationHandler<T>> handlers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, T> reposProxy = new ConcurrentHashMap();
    @ConfigField(desc="Enable statistics", alias="statistics")
    private boolean statisticsEnabled = true;

    public MDRepositoryBeanWithStatistics(Class<?> ... repoClazz) {
        this.repoInterfaces = repoClazz;
    }

    @Override
    public void everyHour() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everyHour);
        }
    }

    @Override
    public void everyMinute() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everyMinute);
        }
    }

    @Override
    public void everySecond() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everySecond);
        }
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        this.handlers.values().forEach(handler -> handler.getStatistics(compName, this.getName(), list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatisticsEnabled(boolean value) {
        if (this.statisticsEnabled != value) {
            MDRepositoryBeanWithStatistics mDRepositoryBeanWithStatistics = this;
            synchronized (mDRepositoryBeanWithStatistics) {
                if (value) {
                    super.getRepositories().forEach(this::wrapInProxy);
                }
                this.statisticsEnabled = value;
                if (!value) {
                    this.reposProxy.clear();
                }
            }
        }
    }

    public void wrapInProxy(String name, T repo) {
        Class[] repoInterfaces = (Class[])Stream.concat(Arrays.stream(this.repoInterfaces), Stream.of(DataSourceAware.class)).filter(cls -> cls.isAssignableFrom(repo.getClass())).toArray(Class[]::new);
        StatisticsInvocationHandler<T> handler = new StatisticsInvocationHandler<T>(name, repo, repoInterfaces);
        DataSourceAware proxy = (DataSourceAware)Proxy.newProxyInstance(repo.getClass().getClassLoader(), repoInterfaces, handler);
        this.handlers.put(name, handler);
        this.reposProxy.put(name, proxy);
    }

    @Override
    protected T getRepository(String domain) {
        if (this.statisticsEnabled) {
            DataSourceAware repo = (DataSourceAware)this.reposProxy.get(this.aliases.getOrDefault(domain, domain));
            if (repo == null) {
                repo = (DataSourceAware)this.reposProxy.get("default");
            }
            return (T)repo;
        }
        return super.getRepository(domain);
    }

    @Override
    protected Map<String, T> getRepositories() {
        if (this.statisticsEnabled) {
            return Collections.unmodifiableMap(this.reposProxy);
        }
        return super.getRepositories();
    }

    @Override
    protected void updateDataSourceAware(String domain, T newRepo, T oldRepo) {
        if (this.statisticsEnabled && newRepo != null) {
            this.wrapInProxy(domain, newRepo);
        } else {
            this.reposProxy.remove(domain);
        }
        super.updateDataSourceAware(domain, newRepo, oldRepo);
    }
}

