/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import tigase.annotations.TigaseDeprecated;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.beans.MDPoolBeanWithStatistics;
import tigase.db.beans.UserRepositoryMDPoolBean;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Inject;
import tigase.xmpp.jid.BareJID;

public abstract class UserRepositoryMDImpl
extends MDPoolBeanWithStatistics<UserRepository, UserRepositoryMDPoolBean.UserRepositoryConfigBean>
implements UserRepository {
    private static final Logger log = Logger.getLogger(UserRepositoryMDImpl.class.getName());
    @Inject
    private EventBus eventBus;

    public UserRepositoryMDImpl() {
        super(UserRepository.class);
    }

    @Override
    public void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addDataList(user, subnode, key, list);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void addUser(BareJID user) throws UserExistsException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addUser(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, subnode, key, def);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, subnode, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public Map<String, String> getDataMap(BareJID user, String subnode) throws TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getDataMap(user, subnode);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public Map<BareJID, String> getDataMap(@NonNull String key) throws UserNotFoundException, TigaseDBException {
        try {
            return ((Stream)this.repositoriesStream().sequential()).flatMap(userRepository -> {
                try {
                    return userRepository.getDataMap(key).entrySet().stream();
                }
                catch (TigaseDBException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof TigaseDBException) {
                throw new TigaseDBException("Could not retrieve list of users", cause);
            }
            throw ex;
        }
    }

    @Override
    public <T> Map<String, T> getDataMap(BareJID user, String subnode, Function<String, T> converter) throws TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getDataMap(user, subnode, converter);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getDataList(user, subnode, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getKeys(user, subnode);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getKeys(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getResourceUri() {
        return ((UserRepository)this.getDefaultRepository()).getResourceUri();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="Support for multi-level nodes will be removed")
    public String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getSubnodes(user, subnode);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getSubnodes(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public long getUserUID(BareJID user) throws TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getUserUID(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return -1L;
    }

    @Override
    public List<BareJID> getUsers() throws TigaseDBException {
        try {
            return ((Stream)this.repositoriesStream().sequential()).flatMap(userRepository -> {
                try {
                    return userRepository.getUsers().stream();
                }
                catch (TigaseDBException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof TigaseDBException) {
                throw new TigaseDBException("Could not retrieve list of users", cause);
            }
            throw ex;
        }
    }

    @Override
    public long getUsersCount() {
        return this.repositoriesStream().mapToLong(UserRepository::getUsersCount).sum();
    }

    @Override
    public long getUsersCount(String domain) {
        UserRepository repo = (UserRepository)this.getRepo(domain);
        if (repo != null) {
            return repo.getUsersCount(domain);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + domain + ", not even default one!");
        return -1L;
    }

    @Override
    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        log.log(Level.CONFIG, "Multi-domain repository pool initialized: " + resource_uri + ", params: " + String.valueOf(params));
    }

    @Override
    public void removeData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeData(user, subnode, key);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeData(user, key);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeSubnode(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeSubnode(user, subnode);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            this.eventBus.fire(new UserRepository.UserBeforeRemovedEvent(user));
            repo.removeUser(user);
            this.eventBus.fire(new UserRepository.UserRemovedEvent(user));
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setData(user, subnode, key, value);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setData(user, key, value);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setDataList(user, subnode, key, list);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public boolean userExists(BareJID user) {
        UserRepository repo = (UserRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.userExists(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return false;
    }
}

