/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.db.beans.AuthRepositoryMDPoolBean;
import tigase.db.beans.MDPoolBeanWithStatistics;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.xmpp.jid.BareJID;

public abstract class AuthRepositoryMDImpl
extends MDPoolBeanWithStatistics<AuthRepository, AuthRepositoryMDPoolBean.AuthRepositoryConfigBean>
implements AuthRepository {
    private static final Logger log = Logger.getLogger(AuthRepositoryMDImpl.class.getName());
    private EventBus eventBus = EventBusFactory.getInstance();

    public AuthRepositoryMDImpl() {
        super(AuthRepository.class);
    }

    @Override
    public void addUser(BareJID user, String password) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addUser(user, password);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getAccountStatus(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public Credentials getCredentials(BareJID user, String credentialId) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getCredentials(user, credentialId);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getPassword(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getPassword(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getResourceUri() {
        return ((AuthRepository)this.getDefaultRepository()).getResourceUri();
    }

    @Override
    public Collection<String> getCredentialIds(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getCredentialIds(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public long getActiveUsersCountIn(Duration duration) {
        AuthRepository repo = (AuthRepository)this.getRepo(null);
        if (repo != null) {
            return repo.getActiveUsersCountIn(duration);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository, not even default one!");
        return -1L;
    }

    @Override
    public long getUsersCount() {
        return this.repositoriesStream().mapToLong(AuthRepository::getUsersCount).sum();
    }

    @Override
    public long getUsersCount(String domain) {
        AuthRepository repo = (AuthRepository)this.getRepo(domain);
        if (repo != null) {
            return repo.getUsersCount(domain);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + domain + ", not even default one!");
        return -1L;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        log.log(Level.CONFIG, "Multi-domain repository pool initialized: " + resource_uri + ", params: " + String.valueOf(params));
    }

    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        AuthRepository repo = (AuthRepository)this.getRepo(domain);
        if (repo != null) {
            return repo.isMechanismSupported(domain, mechanism);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + domain + ", not even default one!");
        return false;
    }

    @Override
    public boolean isUserDisabled(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.isUserDisabled(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return false;
    }

    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.loggedIn(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void logout(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.logout(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> authProps) throws TigaseDBException, AuthorizationException {
        AuthRepository repo = (AuthRepository)this.getRepo((String)authProps.get("server-name"));
        if (repo != null) {
            return repo.otherAuth(authProps);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + String.valueOf(authProps.get("server-name")) + ", not even default one!");
        return false;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        AuthRepository repo = (AuthRepository)this.getRepo((String)authProps.get("server-name"));
        if (repo != null) {
            repo.queryAuth(authProps);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + String.valueOf(authProps.get("server-name")) + ", not even default one!");
        }
    }

    @Override
    public void removeCredential(BareJID user, String credentialId) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeCredential(user, credentialId);
            this.eventBus.fire(new AuthRepository.PasswordChangedEvent(user, credentialId, null));
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeUser(BareJID user) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            this.eventBus.fire(new UserRepository.UserBeforeRemovedEvent(user));
            repo.removeUser(user);
            this.eventBus.fire(new UserRepository.UserRemovedEvent(user));
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setAccountStatus(user, status);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setUserDisabled(user, value);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void updateCredential(BareJID user, String credentialId, String password) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.updateCredential(user, credentialId, password);
            this.eventBus.fire(new AuthRepository.PasswordChangedEvent(user, credentialId, null));
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void updateCredential(BareJID user, String credentialId, String mechanism, String data) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.updateCredential(user, credentialId, mechanism, data);
            this.eventBus.fire(new AuthRepository.PasswordChangedEvent(user, credentialId, mechanism));
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        AuthRepository repo = (AuthRepository)this.getRepo(user.getDomain());
        if (repo != null) {
            repo.updatePassword(user, password);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }
}

