/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.util.Arrays;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.conf.LoggingBean;
import tigase.kernel.core.Kernel;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.AbstractScriptCommand;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

public class SetLoggingCommand
extends AbstractScriptCommand {
    private static final Logger log = Logger.getLogger(SetLoggingCommand.class.getCanonicalName());
    private static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private final Kernel kernel;

    public SetLoggingCommand(Kernel kernel) {
        this.kernel = kernel;
        super.init("logging-set", "Set package logging", "Configuration");
    }

    @Override
    public Bindings getBindings() {
        return null;
    }

    @Override
    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        block7: {
            try {
                try {
                    LoggingBean loggingBean = this.kernel.getParent().getInstance(LoggingBean.class);
                    String packageName = Command.getFieldValue(packet, "package-name");
                    Level level = null;
                    String levelStr = Command.getFieldValue(packet, "level");
                    if (levelStr != null) {
                        level = Level.parse(levelStr);
                    }
                    if (packageName == null || packageName.isBlank() || level == null) {
                        Iq result = (Iq)packet.commandResult(Command.DataType.form);
                        new Command.Builder(result).addAction(Command.Action.execute).addDataForm(Command.DataType.form).addTitle("Set packet logging").withFields(builder -> {
                            builder.addField(DataForm.FieldType.TextSingle, "package-name").setLabel("Package name").setRequired(true).setValue(packageName).build();
                            builder.addField(DataForm.FieldType.ListSingle, "level").setLabel("Level").setRequired(true).setOptions((String[])Arrays.stream(LEVELS).map(Level::getName).toArray(String[]::new)).setValue(levelStr).build();
                        });
                        results.offer(result);
                        break block7;
                    }
                    loggingBean.setPackageLoggingLevel(packageName, level);
                    results.offer(packet.commandResult(Command.DataType.result));
                }
                catch (Throwable ex) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Execution of command " + this.getCommandId() + " failed! " + ex.getMessage(), ex);
                    }
                    results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Execution of command " + this.getCommandId() + " failed: " + ex.getMessage(), false));
                }
            }
            catch (PacketErrorTypeException ex) {
                if (!log.isLoggable(Level.FINEST)) break block7;
                log.log(Level.FINEST, "Packet already of type 'error'");
            }
        }
    }
}

