/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigurationCache;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;
import tigase.xml.db.XMLDBException;

public class ConfigXMLRepository
extends ConfigurationCache {
    public static final String COMPONENT_NODE = "component";
    public static final String ROOT_NODE = "tigase-config";
    public static final String XMPP_CONFIG_FILE_PROPERTY_KEY = "xmpp.config.file";
    public static final String XMPP_CONFIG_FILE_PROPERTY_VAL = "xmpp_server.xml";
    private static final Logger log = Logger.getLogger("tigase.conf.ConfigRepository");
    private static Map<String, ConfigXMLRepository> configs = new LinkedHashMap<String, ConfigXMLRepository>();
    private static ConfigXMLRepository def_config = null;
    private String config_file = null;
    private XMLDB xmldb = null;

    public static ConfigXMLRepository getConfigRepository() throws XMLDBException {
        return ConfigXMLRepository.getConfigRepository(null);
    }

    public static ConfigXMLRepository getConfigRepository(String file_name) throws XMLDBException {
        return ConfigXMLRepository.getConfigRepository(false, file_name);
    }

    public static ConfigXMLRepository getConfigRepository(boolean debug, String file_name) throws XMLDBException {
        ConfigXMLRepository config = null;
        config = file_name == null ? def_config : configs.get(file_name);
        if (config == null) {
            config = file_name == null ? new ConfigXMLRepository(debug) : new ConfigXMLRepository(debug, file_name);
        }
        return config;
    }

    public ConfigXMLRepository() {
    }

    private ConfigXMLRepository(boolean debug) throws XMLDBException {
        this.config_file = System.getProperty(XMPP_CONFIG_FILE_PROPERTY_KEY, XMPP_CONFIG_FILE_PROPERTY_VAL);
        this.init();
        def_config = this;
    }

    private ConfigXMLRepository(boolean debug, String file) throws XMLDBException {
        this.config_file = file;
        this.init();
    }

    @Override
    public void addItem(String compName, ConfigItem item) {
        try {
            this.xmldb.setData(item.getCompName(), item.getNodeName(), item.getKeyName(), item.getConfigVal());
        }
        catch (NodeNotFoundException e1) {
            try {
                this.xmldb.addNode1(item.getCompName());
                this.xmldb.setData(item.getCompName(), item.getNodeName(), item.getKeyName(), item.getConfigVal());
            }
            catch (Exception e2) {
                log.log(Level.WARNING, "Can't add item for compName=" + item.getCompName() + ", node=" + item.getNodeName() + ", key=" + item.getKeyName() + ", value=" + item.getConfigValToString(), e2);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't add item for compName=" + item.getCompName() + ", node=" + item.getNodeName() + ", key=" + item.getKeyName() + ", value=" + item.getConfigValToString(), e);
        }
    }

    @Override
    public Collection<ConfigItem> allItems() throws TigaseDBException {
        LinkedHashSet<ConfigItem> result = new LinkedHashSet<ConfigItem>();
        String[] compNames = this.getCompNames();
        if (compNames != null) {
            for (String comp : compNames) {
                result.addAll(this.getItemsForComponent(comp));
            }
        }
        return result;
    }

    @Override
    public String[] getCompNames() {
        List comps = this.xmldb.getAllNode1s();
        if (comps != null) {
            return comps.toArray(new String[comps.size()]);
        }
        return null;
    }

    @Override
    public ConfigItem getItem(String compName, String node, String key) {
        try {
            Object value = this.xmldb.getData(compName, node, key, null);
            ConfigItem item = this.getItemInstance();
            item.set(compName, node, key, value);
            return item;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't load value for compName=" + compName + ", node=" + node + ", key=" + key, e);
            return null;
        }
    }

    @Override
    public Set<ConfigItem> getItemsForComponent(String compName) {
        LinkedHashSet<ConfigItem> result = new LinkedHashSet<ConfigItem>();
        ArrayList<String> allNodes = new ArrayList<String>();
        String subnode = "";
        this.getSubnodes(allNodes, compName, subnode);
        Object[] keys = this.getKeys(compName, null);
        log.config("Found keys: " + Arrays.toString(keys));
        this.addVals(result, compName, null, (String[])keys);
        for (String node : allNodes) {
            keys = this.getKeys(compName, node);
            log.config("In node : '" + node + "' found keys: " + Arrays.toString(keys));
            this.addVals(result, compName, node, (String[])keys);
        }
        return result;
    }

    @Override
    public String[] getKeys(String root, String node) {
        try {
            return this.xmldb.getKeys(root, node);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public void initRepository(String repo_uri, Map<String, String> params) throws DBInitException {
        this.config_file = params.get("-c");
        try {
            this.init();
        }
        catch (XMLDBException ex) {
            throw new DBInitException("Can not initialize configuration repository: ", ex);
        }
    }

    public String nodeForPackage(Class cls) {
        return cls.getPackage().getName().replace('.', '/');
    }

    @Override
    public void removeItem(String compName, ConfigItem item) {
        try {
            this.xmldb.removeData(item.getCompName(), item.getNodeName(), item.getKeyName());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't remove item for compName=" + item.getCompName() + ", node=" + item.getNodeName() + ", key=" + item.getKeyName() + ", value=" + item.getConfigValToString(), e);
        }
    }

    @Override
    public int size() {
        return (int)this.xmldb.getAllNode1sCount();
    }

    @Override
    public void store() throws TigaseDBException {
        try {
            this.xmldb.sync();
        }
        catch (IOException ex) {
            throw new TigaseDBException("Problem saving configuration data: ", ex);
        }
    }

    private void addVals(Set<ConfigItem> props, String compName, String node, String[] keys) {
        if (keys != null) {
            for (String key : keys) {
                try {
                    Object value = this.xmldb.getData(compName, node, key, null);
                    ConfigItem item = this.getItemInstance();
                    item.set(compName, node, key, value);
                    props.add(item);
                }
                catch (NodeNotFoundException ex) {
                    log.log(Level.WARNING, "Can't load value for compName=" + compName + ", node=" + node + ", key=" + key, ex);
                }
            }
        }
    }

    private void getSubnodes(List<String> result, String root, String node) {
        Object node_tmp;
        String[] subnodes = this.getSubnodes(root, node);
        Object object = node_tmp = node.equals("") ? node : node + "/";
        if (subnodes != null) {
            for (String subnode : subnodes) {
                result.add((String)node_tmp + subnode);
                log.config("Adding subnode: " + (String)node_tmp + subnode);
                this.getSubnodes(result, root, (String)node_tmp + subnode);
            }
        }
    }

    private String[] getSubnodes(String root, String node) {
        try {
            return this.xmldb.getSubnodes(root, node);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    private void init() throws XMLDBException {
        try {
            this.xmldb = new File(this.config_file).exists() ? new XMLDB(this.config_file) : XMLDB.createDB((String)this.config_file, (String)ROOT_NODE, (String)COMPONENT_NODE);
        }
        catch (IOException e) {
            log.warning("Can not open existing configuration file, creating new one, " + String.valueOf(e));
            this.xmldb = XMLDB.createDB((String)this.config_file, (String)ROOT_NODE, (String)COMPONENT_NODE);
        }
        configs.put(this.config_file, this);
    }
}

