/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class XTokenCredentialsEntry
implements Credentials.Entry {
    private final byte[] secretKey;
    private boolean oneTime;

    public XTokenCredentialsEntry(byte[] secretKey, boolean oneTime) {
        this.secretKey = secretKey;
        this.oneTime = oneTime;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    @Override
    public String getMechanism() {
        return "XTOKEN-HMAC-SHA-256";
    }

    @Override
    public boolean verifyPlainPassword(String plain) {
        return false;
    }

    public String encoded() {
        return "t=" + Base64.encode((byte[])this.getSecretKey()) + ",o=" + this.isOneTime();
    }

    @Bean(name="XTOKEN-HMAC-SHA-256", parent=CredentialsEncoderBean.class, active=false)
    public static class Encoder
    implements Credentials.Encoder<XTokenCredentialsEntry> {
        @ConfigField(desc="Mechanism name")
        private String name;

        @Override
        public String encode(BareJID user, String password) {
            return null;
        }

        @Override
        public String encode(BareJID user, XTokenCredentialsEntry entry) {
            return entry.encoded();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    @Bean(name="XTOKEN-HMAC-SHA-256", parent=CredentialsDecoderBean.class, active=false)
    public static class Decoder
    implements Credentials.Decoder<XTokenCredentialsEntry> {
        @ConfigField(desc="Mechanism name")
        private String name;

        @Override
        public XTokenCredentialsEntry decode(BareJID user, String value) {
            byte[] secretKey = null;
            boolean isOT = false;
            int pos = 0;
            while (pos < value.length()) {
                char c = value.charAt(pos);
                int x = value.indexOf(",", pos + 2);
                String part = value.substring(pos + 2, x == -1 ? value.length() : x);
                switch (c) {
                    case 't': {
                        secretKey = Base64.decode((String)part);
                        break;
                    }
                    case 'o': {
                        isOT = Boolean.parseBoolean(part);
                    }
                }
                if (x == -1) break;
                pos = x + 1;
            }
            if (secretKey == null) {
                throw new RuntimeException("secret key cannot be null!");
            }
            return new XTokenCredentialsEntry(secretKey, isOT);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

