/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.TypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.map.ClusterMapFactory;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsList;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="brute-force-locker", parent=SessionManager.class, active=true)
public class BruteForceLockerBean
implements Initializable,
UnregisterAware,
ComponentStatisticsProvider {
    private static final String ANY = "*";
    private static final String LOCK_ENABLED_KEY = "brute-force-lock-enabled";
    private static final String LOCK_AFTER_FAILS_KEY = "brute-force-lock-after-fails";
    private static final String LOCK_DISABLE_ACCOUNT_FAILS_KEY = "brute-force-disable-after-fails";
    private static final String LOCK_TIME_KEY = "brute-force-lock-time";
    private static final String LOCK_PERIOD_TIME_KEY = "brute-force-period-time";
    private static final String LOCK_MODE_KEY = "brute-force-mode";
    private static final String MAP_TYPE = "brute-force-invalid-logins";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, StatHolder> otherStatHolders = new ConcurrentHashMap<String, StatHolder>();
    private final StatHolder statHolder = new StatHolder();
    @ConfigField(desc="Allows storing detailed, per IP/JID statistics of blocked attempts")
    private boolean detailedStatistics = false;
    @Inject
    private EventBus eventBus;
    private Map<Key, Value> map;
    @Inject
    private SessionManager sessionManager;

    public static String getClientIp(XMPPResourceConnection session) {
        try {
            return Optional.ofNullable(session.getConnectionId()).map(JID::getResource).map(res -> res.split("_")[2]).filter(ip -> !"null".equals(ip)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addInvalidLogin(XMPPResourceConnection session, String ip, BareJID jid) {
        this.addInvalidLogin(session, ip, jid, System.currentTimeMillis());
    }

    public void addInvalidLogin(XMPPResourceConnection session, String ip, BareJID jid, long currentTime) {
        long lockAfterFails;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Adding new entry, JID: {0}, ip: {1}, time: {2}", new Object[]{jid, ip, currentTime});
        }
        if (ip == null || "null".equals(ip)) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "IP is null. Skip adding entry.");
            }
            return;
        }
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        Key key = this.createKey(session, ip, jid);
        Value value = this.map.get(key);
        if (value == null) {
            value = new Value(session != null ? session.getDomain().getVhost().toString() : null, ip, jid);
            value.setBadLoginCounter(0);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Entry didn't exists. Create new one.");
            }
        }
        if (value.getInvalidateAtTime() < currentTime) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Entry exists and is old, reset counter.");
            }
            value.setBadLoginCounter(0);
        }
        value.setBadLoginCounter(value.getBadLoginCounter() + 1);
        BruteForceLockerVHostExtension extension = session != null ? session.getDomain().getExtension(BruteForceLockerVHostExtension.class) : null;
        long l = lockAfterFails = extension == null ? 3L : extension.getLockAccountAfterFailedAttempt();
        if ((long)value.getBadLoginCounter() <= lockAfterFails) {
            long periodTime = (extension == null ? 10L : extension.getPeriodTime()) * 1000L;
            value.setInvalidateAtTime(currentTime + periodTime);
        } else {
            long lockTime = (extension == null ? 10L : extension.getLockTime()) * 1000L;
            value.setInvalidateAtTime(currentTime + lockTime);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("New invalidate time for " + String.valueOf(key) + " == " + value.getInvalidateAtTime() + "; getBadLoginCounter == " + value.getBadLoginCounter());
        }
        this.map.put(key, value);
        this.addToStatistic(value);
    }

    public boolean canUserBeDisabled(XMPPResourceConnection session, String ip, BareJID jid) {
        long disableAfterFails;
        Key key = this.createKey(session, ip, jid);
        if (!key.isJIDPresent()) {
            return false;
        }
        Value value = this.map.get(key);
        if (value == null) {
            return false;
        }
        BruteForceLockerVHostExtension extension = session != null ? session.getDomain().getExtension(BruteForceLockerVHostExtension.class) : null;
        long l = disableAfterFails = extension == null ? 20L : extension.getDisableAccountAfterFailedAttempts();
        if (disableAfterFails == 0L) {
            return false;
        }
        return (long)value.getBadLoginCounter() > disableAfterFails;
    }

    public void clearAll() {
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        this.map.clear();
    }

    public void clearOutdated() {
        this.clearOutdated(System.currentTimeMillis());
    }

    public void clearOutdated(long currentTime) {
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        HashSet toRemove = new HashSet();
        this.map.forEach((key, value) -> {
            if (value.getInvalidateAtTime() < currentTime) {
                toRemove.add(key);
            }
        });
        toRemove.forEach(key -> this.map.remove(key));
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        this.clearOutdated();
        String keyName = compName + "/BruteForceLocker";
        ArrayList<Value> l = new ArrayList<Value>(this.map.values());
        for (Value value : l) {
            list.add(keyName, "Present locks: " + String.valueOf(value.jid) + " from " + value.ip, value.badLoginCounter, Level.FINER);
        }
        StatHolder tmp = new StatHolder();
        this.statHolder.ips.forEach((ip, count) -> tmp.addIP((String)ip, (int)count));
        this.statHolder.jids.forEach((jid, count) -> tmp.addJID((BareJID)jid, (int)count));
        this.otherStatHolders.values().forEach(otherSH -> {
            otherSH.ips.forEach((ip, count) -> tmp.addIP((String)ip, (int)count));
            otherSH.jids.forEach((jid, count) -> tmp.addJID((BareJID)jid, (int)count));
        });
        list.add(keyName, "Blocked IPs", tmp.ips.size(), Level.INFO);
        list.add(keyName, "Blocked JIDs", tmp.jids.size(), Level.INFO);
        list.add(keyName, "Total blocked IP attempts", tmp.ips.values().stream().mapToInt(Integer::intValue).sum(), Level.FINE);
        list.add(keyName, "Total blocked JID attempts", tmp.jids.values().stream().mapToInt(Integer::intValue).sum(), Level.FINE);
    }

    @Override
    public void initialize() {
        this.map = ClusterMapFactory.get().createMap(MAP_TYPE, Key.class, Value.class, new String[0]);
        assert (this.map != null) : "Distributed Map is NULL!";
        assert (this.sessionManager != null) : "SessionManager is NULL!";
        if (this.eventBus != null) {
            this.eventBus.registerAll(this);
        }
    }

    public boolean isEnabled(XMPPResourceConnection session) {
        BruteForceLockerVHostExtension extension = session != null ? session.getDomain().getExtension(BruteForceLockerVHostExtension.class) : null;
        return extension != null && extension.isEnabled();
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void handleStatisticsEmitEvent(StatisticsEmitEvent event) {
        if (event.getNodeName() == null) {
            return;
        }
        this.otherStatHolders.put(event.getNodeName(), event.getStatHolder());
    }

    public boolean isLoginAllowed(XMPPResourceConnection session, String ip, BareJID jid) {
        return this.isLoginAllowed(session, ip, jid, System.currentTimeMillis());
    }

    public boolean isLoginAllowed(XMPPResourceConnection session, String ip, BareJID jid, long currentTime) {
        if (ip == null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("IP is null. Return true.");
            }
            return true;
        }
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return false;
        }
        Key key = this.createKey(session, ip, jid);
        Value value = this.map.get(key);
        if (value == null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("No entry for " + String.valueOf(key) + ". Return true.");
            }
            return true;
        }
        return this.isLoginAllowed(session, key, value, currentTime);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @Override
    public void everyHour() {
    }

    @Override
    public void everyMinute() {
        String clusterNode = this.sessionManager.getComponentId().getDomain();
        this.eventBus.fire(new StatisticsEmitEvent(clusterNode, this.statHolder));
    }

    @Override
    public void everySecond() {
    }

    void setMap(HashMap<Key, Value> map) {
        this.map = map;
    }

    final Key createKey(XMPPResourceConnection session, String ip, BareJID jid) {
        BruteForceLockerVHostExtension extension = session != null ? session.getDomain().getExtension(BruteForceLockerVHostExtension.class) : null;
        Mode mode = extension == null ? Mode.IpJid : extension.getMode();
        return this.createKey(mode, session, ip, jid);
    }

    final Key createKey(Mode mode, XMPPResourceConnection session, String ip, BareJID jid) {
        String domain = session == null ? ANY : session.getDomain().getVhost().toString();
        switch (mode.ordinal()) {
            case 2: {
                return new Key(ANY, jid == null ? ANY : jid.toString(), domain);
            }
            case 0: {
                return new Key(ip == null ? ANY : ip, ANY, domain);
            }
            case 1: {
                return new Key(ip == null ? ANY : ip, jid == null ? ANY : jid.toString(), domain);
            }
        }
        throw new RuntimeException("Unknown mode " + String.valueOf((Object)mode));
    }

    private void addToStatistic(Value v) {
        if (v.ip != null) {
            this.statHolder.addIP(v.ip);
        }
        if (v.jid != null) {
            this.statHolder.addJID(v.jid);
        }
    }

    private boolean isLoginAllowed(XMPPResourceConnection session, Key key, Value value, long currentTime) {
        boolean r;
        if (value.getInvalidateAtTime() < currentTime) {
            this.map.remove(key);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Entry existed, but was too old. Entry removed. Return true.");
            }
            return true;
        }
        BruteForceLockerVHostExtension extension = session != null ? session.getDomain().getExtension(BruteForceLockerVHostExtension.class) : null;
        long lockAfterFails = extension == null ? 3L : extension.getLockAccountAfterFailedAttempt();
        boolean bl = r = (long)value.badLoginCounter <= lockAfterFails;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entry exist. lockAfterFails=" + lockAfterFails + ", value.badLoginCounter=" + value.badLoginCounter + ", result=" + r);
        }
        return r;
    }

    public static class StatHolder
    implements TypesConverter.Parcelable {
        private final Map<String, Integer> ips = new ConcurrentHashMap<String, Integer>();
        private final Map<BareJID, Integer> jids = new ConcurrentHashMap<BareJID, Integer>();
        private final DefaultTypesConverter typesConverter = new DefaultTypesConverter();

        public Map<String, Integer> getIps() {
            return this.ips;
        }

        public Map<BareJID, Integer> getJids() {
            return this.jids;
        }

        public void clear() {
            this.ips.clear();
            this.jids.clear();
        }

        public int addIP(String ip) {
            return this.add(this.ips, ip, 1);
        }

        public int addJID(BareJID jid) {
            return this.add(this.jids, jid, 1);
        }

        public int addIP(String ip, int value) {
            return this.add(this.ips, ip, value);
        }

        public int addJID(BareJID jid, int value) {
            return this.add(this.jids, jid, value);
        }

        @Override
        public String[] encodeToStrings() {
            String[] r = new String[2 + this.ips.size() * 2 + this.jids.size() * 2];
            r[0] = String.valueOf(this.ips.size());
            r[1] = String.valueOf(this.jids.size());
            this.fillTab(this.ips, r, 2);
            this.fillTab(this.jids, r, 2 + this.ips.size() * 2);
            return r;
        }

        @Override
        public void fillFromString(String[] encoded) {
            try {
                int lenIps = Integer.parseInt(encoded[0]);
                int lenJids = Integer.parseInt(encoded[1]);
                this.ips.clear();
                this.ips.putAll(this.read(encoded, 2, lenIps, key -> key));
                this.jids.clear();
                this.jids.putAll(this.read(encoded, 2 + lenIps * 2, lenJids, BareJID::bareJIDInstanceNS));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot decode parcel: " + Arrays.toString(encoded), e);
            }
        }

        private <T> HashMap<T, Integer> read(String[] src, int offset, int len, Function<String, T> keyCnv) {
            HashMap<T, Integer> r = new HashMap<T, Integer>();
            for (int i = 0; i < len; ++i) {
                r.put(keyCnv.apply(src[offset + 2 * i]), Integer.parseInt(src[offset + 2 * i + 1]));
            }
            return r;
        }

        private <T> void fillTab(Map<T, Integer> src, String[] dst, int offset) {
            int idx = offset;
            for (Map.Entry<T, Integer> x : src.entrySet()) {
                String key = x.getKey().toString();
                Integer value = x.getValue();
                dst[idx] = key;
                dst[idx + 1] = String.valueOf(value);
                idx += 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> int add(Map<T, Integer> map, T key, int value) {
            Map<T, Integer> map2 = map;
            synchronized (map2) {
                Integer v = map.get(key);
                v = (v == null ? 0 : v) + value;
                map.put(key, v);
                return v;
            }
        }
    }

    public static class Key
    implements TypesConverter.Parcelable {
        private String domain;
        private String ip;
        private String jid;

        public Key() {
        }

        public Key(String ip, String jid, String domain) {
            this.ip = ip;
            this.jid = jid;
            this.domain = domain;
        }

        @Override
        public String[] encodeToStrings() {
            return new String[]{this.jid, this.ip, this.domain};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.domain.equals(key.domain)) {
                return false;
            }
            if (!this.ip.equals(key.ip)) {
                return false;
            }
            return this.jid.equals(key.jid);
        }

        @Override
        public void fillFromString(String[] encoded) {
            this.jid = encoded[0];
            this.ip = encoded[1];
            this.domain = encoded[2];
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + this.ip.hashCode();
            result = 31 * result + this.jid.hashCode();
            return result;
        }

        public boolean isJIDPresent() {
            return this.jid != null && !this.jid.equals(BruteForceLockerBean.ANY);
        }

        public String toString() {
            return "Key[ip=" + this.ip + ", jid=" + this.jid + ", domain=" + this.domain + "]";
        }
    }

    public static class Value
    implements TypesConverter.Parcelable {
        private int badLoginCounter;
        private String domain;
        private long invalidateAtTime;
        private String ip;
        private BareJID jid;

        public Value() {
        }

        public Value(String domain, String ip, BareJID jid) {
            this.domain = domain;
            this.ip = ip;
            this.jid = jid;
        }

        @Override
        public String[] encodeToStrings() {
            return new String[]{Integer.toString(this.badLoginCounter), Long.toString(this.invalidateAtTime)};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            if (this.badLoginCounter != value.badLoginCounter) {
                return false;
            }
            return this.invalidateAtTime == value.invalidateAtTime;
        }

        @Override
        public void fillFromString(String[] encoded) {
            this.badLoginCounter = Integer.valueOf(encoded[0]);
            this.invalidateAtTime = Long.valueOf(encoded[1]);
        }

        public int getBadLoginCounter() {
            return this.badLoginCounter;
        }

        public void setBadLoginCounter(int badLoginCounter) {
            this.badLoginCounter = badLoginCounter;
        }

        public long getInvalidateAtTime() {
            return this.invalidateAtTime;
        }

        public void setInvalidateAtTime(long invalidateAtTime) {
            this.invalidateAtTime = invalidateAtTime;
        }

        public int hashCode() {
            int result = this.badLoginCounter;
            result = 31 * result + (int)(this.invalidateAtTime ^ this.invalidateAtTime >>> 32);
            return result;
        }
    }

    public static class BruteForceLockerVHostExtension
    extends AbstractVHostItemExtension<BruteForceLockerVHostExtension>
    implements VHostItemExtensionBackwardCompatible<BruteForceLockerVHostExtension> {
        public static final String ID = "brute-force-locker";
        private static final long DEF_lockAccountAfterFailedAttempt = 3L;
        private static final long DEF_disableAccountAfterFailedAttempts = 20L;
        private static final long DEF_periodTime = 60L;
        private static final long DEF_lockTime = 60L;
        private static final Mode DEF_mode = Mode.IpJid;
        private boolean enabled = true;
        private long lockAccountAfterFailedAttempt = 3L;
        private long disableAccountAfterFailedAttempts = 20L;
        private long periodTime = 60L;
        private long lockTime = 60L;
        private Mode mode = DEF_mode;

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getLockAccountAfterFailedAttempt() {
            return this.lockAccountAfterFailedAttempt;
        }

        public long getDisableAccountAfterFailedAttempts() {
            return this.disableAccountAfterFailedAttempts;
        }

        public long getPeriodTime() {
            return this.periodTime;
        }

        public long getLockTime() {
            return this.lockTime;
        }

        public Mode getMode() {
            return this.mode;
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void initFromElement(Element item) {
            this.enabled = !"false".equals(item.getAttributeStaticStr("enabled"));
            String tmp = item.getAttributeStaticStr("lock-after-fails");
            if (tmp != null) {
                this.lockAccountAfterFailedAttempt = Long.parseLong(tmp);
            }
            if ((tmp = item.getAttributeStaticStr("disable-after-fails")) != null) {
                this.disableAccountAfterFailedAttempts = Long.parseLong(tmp);
            }
            if ((tmp = item.getAttributeStaticStr("period-time")) != null) {
                this.periodTime = Long.parseLong(tmp);
            }
            if ((tmp = item.getAttributeStaticStr("lock-time")) != null) {
                this.lockTime = Long.parseLong(tmp);
            }
            if ((tmp = item.getAttributeStaticStr("mode")) != null) {
                this.mode = Mode.valueOf(tmp);
            }
        }

        @Override
        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            Optional.ofNullable(Command.getFieldValue(packet, prefix + "-enabled")).ifPresent(s -> {
                this.enabled = Boolean.parseBoolean(s);
            });
            String value = Command.getFieldValue(packet, prefix + "-lock-after-fails");
            if (value != null) {
                this.lockAccountAfterFailedAttempt = Long.parseLong(value);
            }
            if ((value = Command.getFieldValue(packet, prefix + "-disable-after-fails")) != null) {
                this.disableAccountAfterFailedAttempts = Long.parseLong(value);
            }
            if ((value = Command.getFieldValue(packet, prefix + "-period-time")) != null) {
                this.periodTime = Long.parseLong(value);
            }
            if ((value = Command.getFieldValue(packet, prefix + "-lock-time")) != null) {
                this.lockTime = Long.parseLong(value);
            }
            if ((value = Command.getFieldValue(packet, prefix + "-mode")) != null) {
                this.mode = Mode.valueOf(value);
            }
        }

        @Override
        public String toDebugString() {
            return "enabled: " + this.enabled + ",mode: " + String.valueOf((Object)this.mode) + ", lockAfter: " + this.lockAccountAfterFailedAttempt + ", disableAfter: " + this.disableAccountAfterFailedAttempts + ", period: " + this.periodTime + ", lockTime: " + this.lockTime;
        }

        @Override
        public Element toElement() {
            if (this.enabled && this.lockAccountAfterFailedAttempt == 3L && this.disableAccountAfterFailedAttempts == 20L && this.periodTime == 60L && this.lockTime == 60L && this.mode == DEF_mode) {
                return null;
            }
            Element el = new Element(ID);
            if (!this.enabled) {
                el.setAttribute("enabled", String.valueOf(this.enabled));
            }
            if (this.lockAccountAfterFailedAttempt != 3L) {
                el.setAttribute("lock-after-fails", String.valueOf(this.lockAccountAfterFailedAttempt));
            }
            if (this.disableAccountAfterFailedAttempts != 20L) {
                el.setAttribute("disable-after-fails", String.valueOf(this.disableAccountAfterFailedAttempts));
            }
            if (this.periodTime != 60L) {
                el.setAttribute("period-time", String.valueOf(this.periodTime));
            }
            if (this.lockTime != 60L) {
                el.setAttribute("lock-time", String.valueOf(this.lockTime));
            }
            if (this.mode != DEF_mode) {
                el.setAttribute("mode", this.mode.name());
            }
            return el;
        }

        @Override
        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
            DataForm.addFieldValue(commandEl, prefix + "-enabled", String.valueOf(this.enabled), "boolean", "Brute Force Prevention Enabled");
            DataForm.addFieldValue(commandEl, prefix + "-lock-after-fails", String.valueOf(this.lockAccountAfterFailedAttempt), "text-single", "Number of allowed invalid login");
            DataForm.addFieldValue(commandEl, prefix + "-disable-after-fails", String.valueOf(this.disableAccountAfterFailedAttempts), "text-single", "Disable account after failed login");
            DataForm.addFieldValue(commandEl, prefix + "-period-time", String.valueOf(this.periodTime), "text-single", "Failed login in period of time [sec]");
            DataForm.addFieldValue(commandEl, prefix + "-lock-time", String.valueOf(this.lockTime), "text-single", "Lock time [sec]");
            DataForm.addFieldValue(commandEl, prefix + "-mode", this.mode.name(), "Brute Force Prevention Mode", new String[]{Mode.Ip.name(), Mode.Jid.name(), Mode.IpJid.name()}, new String[]{Mode.Ip.name(), Mode.Jid.name(), Mode.IpJid.name()});
        }

        @Override
        public void initFromData(Map<String, Object> data) {
            String mode;
            Long tmp;
            Boolean enabled = (Boolean)data.remove(BruteForceLockerBean.LOCK_ENABLED_KEY);
            if (enabled != null) {
                this.enabled = enabled;
            }
            if ((tmp = (Long)data.remove(BruteForceLockerBean.LOCK_AFTER_FAILS_KEY)) != null) {
                this.lockAccountAfterFailedAttempt = tmp;
            }
            if ((tmp = (Long)data.remove(BruteForceLockerBean.LOCK_DISABLE_ACCOUNT_FAILS_KEY)) != null) {
                this.disableAccountAfterFailedAttempts = tmp;
            }
            if ((tmp = (Long)data.remove(BruteForceLockerBean.LOCK_PERIOD_TIME_KEY)) != null) {
                this.periodTime = tmp;
            }
            if ((tmp = (Long)data.remove(BruteForceLockerBean.LOCK_TIME_KEY)) != null) {
                this.lockTime = tmp;
            }
            if ((mode = (String)data.remove(BruteForceLockerBean.LOCK_MODE_KEY)) != null) {
                this.mode = Mode.valueOf(mode);
            }
        }

        @Override
        public BruteForceLockerVHostExtension mergeWithDefaults(BruteForceLockerVHostExtension defaults) {
            BruteForceLockerVHostExtension merged = new BruteForceLockerVHostExtension();
            merged.enabled = this.enabled || defaults.enabled;
            merged.mode = this.mode.merge(defaults.mode);
            merged.lockTime = Math.max(this.lockTime, defaults.lockTime);
            merged.periodTime = Math.max(this.periodTime, defaults.periodTime);
            merged.disableAccountAfterFailedAttempts = Math.min(this.disableAccountAfterFailedAttempts, defaults.disableAccountAfterFailedAttempts);
            merged.lockAccountAfterFailedAttempt = Math.min(this.lockAccountAfterFailedAttempt, defaults.lockAccountAfterFailedAttempt);
            return merged;
        }
    }

    public static class StatisticsEmitEvent
    implements Serializable,
    EventBusEvent {
        private String nodeName;
        private StatHolder statHolder;

        public StatisticsEmitEvent() {
        }

        public StatisticsEmitEvent(String nodeName, StatHolder statHolder) {
            this.nodeName = nodeName;
            this.statHolder = statHolder;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public StatHolder getStatHolder() {
            return this.statHolder;
        }

        public void setStatHolder(StatHolder statHolder) {
            this.statHolder = statHolder;
        }
    }

    public static enum Mode {
        Ip,
        IpJid,
        Jid;


        public Mode merge(Mode mode) {
            switch (this.ordinal()) {
                case 0: {
                    if (mode == Ip) {
                        return Ip;
                    }
                    return IpJid;
                }
                case 2: {
                    if (mode == Jid) {
                        return Jid;
                    }
                    return IpJid;
                }
                case 1: {
                    return IpJid;
                }
            }
            return this;
        }
    }

    @Bean(name="brute-force-locker", parent=VHostItemExtensionManager.class, active=true)
    public static class BruteForceLockerVHostExtensionProvider
    implements VHostItemExtensionProvider<BruteForceLockerVHostExtension> {
        @Override
        public String getId() {
            return "brute-force-locker";
        }

        @Override
        public Class<BruteForceLockerVHostExtension> getExtensionClazz() {
            return BruteForceLockerVHostExtension.class;
        }
    }

    public static class LoginLockedException
    extends Exception {
    }
}

