/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import tigase.disco.ServiceIdentity;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.xml.Element;
import tigase.xmpp.impl.PresenceCapabilitiesManager;

public class PresenceCapabilitiesManagerTest {
    @Test
    public void generateVerificationStringSimpleExample() {
        String[] features = new String[]{"http://jabber.org/protocol/caps", "http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/muc"};
        ServiceIdentity exodus = new ServiceIdentity("client", "pc", "Exodus 0.9.1");
        String[] identities = new String[]{exodus.getAsCapsString()};
        String s = PresenceCapabilitiesManager.generateVerificationString((String[])identities, (String[])features, null);
        Assert.assertEquals((Object)"QgayPKawpkPSDYmwT/WM94uAlu0=", (Object)s);
    }

    @Test
    public void generateVerificationStringComplexExample() {
        String[] features = new String[]{"http://jabber.org/protocol/caps", "http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/muc"};
        ServiceIdentity psi_en = new ServiceIdentity("client", "pc", "Psi 0.11", "en");
        ServiceIdentity psi_el = new ServiceIdentity("client", "pc", "\u03a8 0.11", "el");
        String[] identities = new String[]{psi_en.getAsCapsString(), psi_el.getAsCapsString()};
        Element form = DataForm.createDataForm((Command.DataType)Command.DataType.result);
        DataForm.addHiddenField((Element)form, (String)"FORM_TYPE", (String)"urn:xmpp:dataforms:softwareinfo");
        DataForm.addFieldMultiValue((Element)form, (String)"ip_version", Arrays.asList("ipv4", "ipv6"));
        DataForm.addFieldMultiValue((Element)form, (String)"os", Arrays.asList("Mac"));
        DataForm.addFieldMultiValue((Element)form, (String)"os_version", Arrays.asList("10.5.1"));
        DataForm.addFieldMultiValue((Element)form, (String)"software", Arrays.asList("Psi"));
        DataForm.addFieldMultiValue((Element)form, (String)"software_version", Arrays.asList("0.11"));
        String s = PresenceCapabilitiesManager.generateVerificationString((String[])identities, (String[])features, (Element)form);
        Assert.assertEquals((Object)"q07IKJEyjvHSyhy//CH0CxmKi8w=", (Object)s);
    }
}

