/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.vhosts.DummyVHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MessageDeliveryLogicTest
extends ProcessorTestCase {
    static final String domain = "example.com";
    private MessageDeliveryLogic messageDeliveryLogic;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(MessageDeliveryLogic.class).exec();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.messageDeliveryLogic = this.getInstance(MessageDeliveryLogic.class);
        DummyVHostManager vHostManager = this.getInstance(DummyVHostManager.class);
        vHostManager.addVhost(domain);
    }

    @Test
    public void testProcessingErrorMessageBareJidOffline() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        Element packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", destinationUserJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, null);
        Assert.assertTrue((String)"BareJID: No Available or Connected Resources > 8.5.2.2.1. Message: drop message", (boolean)block);
    }

    @Test
    public void testProcessingErrorMessageBareJidOnline() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        JID fullDestinationJid = JID.jidInstance((BareJID)destinationUserJid, (String)"res1");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), fullDestinationJid);
        Element packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", destinationUserJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertTrue((String)"BareJID: Available or Connected Resources > 8.5.2.1.1. Message: drop message", (boolean)block);
    }

    @Test
    public void testProcessingErrorMessageFullJidOnlineWithMatchingResource() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        JID fullDestinationJid = JID.jidInstance((BareJID)destinationUserJid, (String)"res1");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), fullDestinationJid);
        Element packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", fullDestinationJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertFalse((String)"FullJID: 8.5.3.1.  Resource Matches. Message: deliver message", (boolean)block);
    }

    @Test
    public void testProcessingErrorMessageFullJidOnlineWithouthMatchingResource() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        JID fullDestinationJidPacketTo = JID.jidInstance((BareJID)destinationUserJid, (String)"res1");
        JID fullDestinationJidSession = JID.jidInstance((BareJID)destinationUserJid, (String)"res2");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), fullDestinationJidSession);
        Element packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", fullDestinationJidPacketTo.toString()});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertTrue((String)"FullJID: No Resource Matches > 8.5.3.2.1. Message: drop message", (boolean)block);
    }

    @Test
    public void testProcessingErrorMessagePubSubPayload() throws Exception {
        JID destinationChannelJid = JID.jidInstance((String)"channel", (String)"mix.example.com", (String)UUID.randomUUID().toString());
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), JID.jidInstance((String)"user1@example.com/res1"));
        Element packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", destinationChannelJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertFalse((String)"Message error addressed to PubSub/MIX should be correctly forwarded to the component", (boolean)block);
        BareJID destinationChannelFullJid = BareJID.bareJIDInstance((String)"channel", (String)"mix.example.com");
        packetElelement = new Element("message", new String[]{"type", "from", "to"}, new String[]{"error", "remote-user@test.com/res1", destinationChannelFullJid.toString()});
        packet = Packet.packetInstance((Element)packetElelement);
        block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertFalse((String)"Message error addressed to PubSub/MIX should be correctly forwarded to the component", (boolean)block);
    }

    @Test
    public void testProcessingFailureErrorMissingToMissingFrom() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        JID fullDestinationJid = JID.jidInstance((BareJID)destinationUserJid, (String)"res1");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), fullDestinationJid);
        Element packetElelement = new Element("failure", new String[]{"type", "xmlns"}, new String[]{"error", "urn:ietf:params:xml:ns:xmpp-sasl"});
        packetElelement.addChild((XMLNodeIfc)new Element("not-authorized", new String[]{" xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}));
        packetElelement.addChild((XMLNodeIfc)new Element("text", "Password not verified"));
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertFalse((String)"Only Message packets should be processed", (boolean)block);
    }

    @Test
    public void testProcessingIqErrorMissingTo() throws Exception {
        BareJID destinationUserJid = BareJID.bareJIDInstance((String)"user1", (String)domain);
        JID fullDestinationJid = JID.jidInstance((BareJID)destinationUserJid, (String)"res1");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + String.valueOf(UUID.randomUUID()))), fullDestinationJid);
        Element packetElelement = new Element("iq", new String[]{"type", "from"}, new String[]{"error", "remote-user@test.com/res1"});
        Packet packet = Packet.packetInstance((Element)packetElelement);
        boolean block = this.messageDeliveryLogic.preProcessFilter(packet, session);
        Assert.assertFalse((String)"Only Message packets should be processed", (boolean)block);
    }
}

