/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqCommand;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class JabberIqCommandTest
extends ProcessorTestCase {
    @Before
    public void prepare() {
        this.getKernel().registerBean(SessionManager.DefaultHandlerProc.class).exec();
        this.getKernel().registerBean(JabberIqCommand.class).setActive(true).exec();
    }

    @Test
    public void testIqDelivery1() throws XMPPException, TigaseStringprepException {
        JID jid1 = JID.jidInstance((String)"user1@example.com/res1");
        JID jid2 = JID.jidInstance((String)"user1@example.com/res2");
        XMPPResourceConnection session = this.getSession(jid1, jid1);
        Element iqEl = new Element("iq", new String[]{"from", "to", "xmlns", "type"}, new String[]{jid1.toString(), jid2.toString(), "jabber:client", "get"});
        iqEl.addChild((XMLNodeIfc)new Element("command", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/commands"}));
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(jid1);
        JabberIqCommand handler = (JabberIqCommand)this.getKernel().getInstance(JabberIqCommand.class);
        TestCase.assertEquals((Object)Authorization.AUTHORIZED, (Object)handler.canHandle(iq, session));
        LinkedList results = new LinkedList();
        handler.process(iq, session, null, results, new HashMap());
        TestCase.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testIqDelivery2() throws XMPPException, TigaseStringprepException {
        JID jid1 = JID.jidInstance((String)"user1@example.com/res1");
        JID jid2 = JID.jidInstance((String)"user1@example.com/res2");
        XMPPResourceConnection session = this.getSession(jid2, jid2);
        Element iqEl = new Element("iq", new String[]{"from", "to", "xmlns", "type"}, new String[]{jid1.toString(), jid2.toString(), "jabber:client", "get"});
        iqEl.addChild((XMLNodeIfc)new Element("command", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/commands"}));
        Packet iq = Packet.packetInstance((Element)iqEl);
        JabberIqCommand handler = (JabberIqCommand)this.getKernel().getInstance(JabberIqCommand.class);
        TestCase.assertEquals((Object)Authorization.AUTHORIZED, (Object)handler.canHandle(iq, session));
        LinkedList results = new LinkedList();
        handler.process(iq, session, null, results, new HashMap());
        TestCase.assertEquals((int)1, (int)results.size());
    }
}

