/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.util.Collections;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import tigase.server.rtbl.RTBL;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

public class RTBLTest {
    private BareJID pubsubJid = BareJID.bareJIDInstanceNS((String)"test@localhost");
    private String node = "test";
    private String hash = "SHA-256";

    @Test
    public void testCreation() {
        RTBL rtbl = new RTBL(this.pubsubJid, this.node, this.hash, Collections.emptySet());
        TestCase.assertEquals((Object)this.pubsubJid, (Object)rtbl.getJID());
        TestCase.assertEquals((String)this.node, (String)rtbl.getNode());
        TestCase.assertEquals((String)this.hash, (String)rtbl.getHash());
        TestCase.assertEquals((int)0, (int)rtbl.getBlocked().size());
    }

    @Test
    public void testUserBlocking() {
        RTBL rtbl = new RTBL(this.pubsubJid, this.node, this.hash, Collections.emptySet());
        BareJID user1 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-1");
        BareJID user2 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-1");
        BareJID user3 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-2");
        String userHash = Algorithms.sha256((String)user1.toString());
        rtbl.getBlocked().add(userHash);
        TestCase.assertTrue((boolean)rtbl.isBlocked(user1));
        Assert.assertFalse((boolean)rtbl.isBlocked(user2));
        Assert.assertFalse((boolean)rtbl.isBlocked(user3));
    }

    @Test
    public void testDomainBlocking() {
        RTBL rtbl = new RTBL(this.pubsubJid, this.node, this.hash, Collections.emptySet());
        BareJID user1 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-1");
        BareJID user2 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-1");
        BareJID user3 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain-2");
        String domainHash = Algorithms.sha256((String)user1.getDomain().toString());
        rtbl.getBlocked().add(domainHash);
        TestCase.assertTrue((boolean)rtbl.isBlocked(user1));
        TestCase.assertTrue((boolean)rtbl.isBlocked(user1));
        Assert.assertFalse((boolean)rtbl.isBlocked(user3));
    }
}

