/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.db.TigaseDBException;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.kernel.AbstractKernelWithUserRepositoryTestCase;
import tigase.kernel.core.Kernel;
import tigase.server.rtbl.RTBL;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

public class RTBLRepositoryTest
extends AbstractKernelWithUserRepositoryTestCase {
    private BareJID pubsubJid = BareJID.bareJIDInstanceNS((String)"test@localhost");
    private String node = "test";
    private String hash = "SHA-256";
    private static final int limit = 30;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)new EventBusImplementation()).exec();
        kernel.registerBean(RTBLRepository.class).exec();
    }

    @Test
    public void test() throws TigaseDBException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        RTBLRepository repository = this.getInstance(RTBLRepository.class);
        TestCase.assertEquals((int)0, (int)repository.getBlockLists().size());
        repository.add(this.pubsubJid, this.node, this.hash);
        this.waitUntil(() -> repository.getBlockLists().size() != 2);
        TestCase.assertEquals((int)1, (int)repository.getBlockLists().size());
        BareJID user = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain");
        repository.update(this.pubsubJid, this.node, RTBLRepository.Action.add, Algorithms.sha256((String)user.toString()));
        this.waitUntil(() -> !repository.isBlocked(user));
        TestCase.assertTrue((boolean)repository.isBlocked(user));
        Field f = RTBLRepository.class.getDeclaredField("cache");
        f.setAccessible(true);
        Map cache = (Map)f.get(repository);
        cache.clear();
        TestCase.assertEquals((int)0, (int)repository.getBlockLists().size());
        TestCase.assertFalse((boolean)repository.isBlocked(user));
        repository.reload();
        TestCase.assertEquals((int)1, (int)repository.getBlockLists().size());
        RTBL rtbl = repository.getBlockList(this.pubsubJid, this.node);
        TestCase.assertNotNull((Object)rtbl);
        TestCase.assertEquals((String)this.hash, (String)rtbl.getHash());
        TestCase.assertTrue((boolean)repository.isBlocked(user));
        BareJID user2 = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain");
        rtbl = new RTBL(rtbl.getKey(), this.hash, Set.of(Algorithms.sha256((String)user.toString()), Algorithms.sha256((String)user2.toString())));
        repository.update(rtbl);
        this.waitUntil(() -> !repository.isBlocked(user));
        TestCase.assertTrue((boolean)repository.isBlocked(user));
        TestCase.assertTrue((boolean)repository.isBlocked(user2));
        rtbl = new RTBL(rtbl.getKey(), this.hash, Set.of(Algorithms.sha256((String)user2.toString())));
        repository.update(rtbl);
        this.waitUntil(() -> !repository.isBlocked(user2));
        TestCase.assertFalse((boolean)repository.isBlocked(user));
        TestCase.assertTrue((boolean)repository.isBlocked(user2));
    }

    private void waitUntil(Supplier<Boolean> function) throws InterruptedException {
        for (int i = 0; i < 30 && function.get().booleanValue(); ++i) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }
}

