/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.modular;

import java.util.Collection;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.component.DSLBeanConfigurator;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.RegistrarKernel;
import tigase.kernel.modular.ComponentsManager;
import tigase.kernel.modular.c1.Component1Registrar;
import tigase.kernel.modular.c2.Component2Registrar;

public class ApplicationTest {
    private static final Logger log = TestLogger.getLogger(ApplicationTest.class);

    @Test
    public void testBootstrapModules() {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.setName("root");
        krnl.registerBean(DefaultTypesConverter.class).exportable().exec();
        krnl.registerBean(DSLBeanConfigurator.class).exportable().exec();
        krnl.registerBean(ComponentsManager.class).exec();
        krnl.registerBean(Component1Registrar.class).exec();
        krnl.registerBean(Component2Registrar.class).exec();
        ComponentsManager componentsManager = (ComponentsManager)krnl.getInstance(ComponentsManager.class);
        Assert.assertNotNull((Object)componentsManager.getComponents());
        Assert.assertEquals((long)2L, (long)componentsManager.getComponents().length);
        Collection<String> response = componentsManager.process("call1");
        Assert.assertTrue((boolean)response.contains("response:Component1(h:call1)"));
        Assert.assertTrue((boolean)response.contains("response:Component2(call1)"));
    }
}

