/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.EventListener;
import tigase.eventbus.FillRoutedEvent;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.RouteEvent;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.impl.AbstractHandler;
import tigase.eventbus.impl.AbstractListenerHandler;
import tigase.eventbus.impl.Event1;
import tigase.eventbus.impl.Event12;
import tigase.eventbus.impl.Event2;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.eventbus.impl.ObjectEventsListenerHandler;
import tigase.xml.Element;

public class EventBusImplementationTest {
    private EventBusImplementation eventBus;

    @Before
    public void setUp() throws Exception {
        this.eventBus = new EventBusImplementation();
        this.eventBus.setExecutor(new Executor(this){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Test
    public void test1() {
        final String[] value = new String[5];
        this.eventBus.addListener(Event1.class, (EventListener)new EventListener<Event1>(){

            public void onEvent(Event1 event) {
                value[1] = "l";
            }
        });
        this.eventBus.addListener(Event12.class, (EventListener)new EventListener<Event12>(){

            public void onEvent(Event12 event) {
                value[2] = "l";
            }
        });
        this.eventBus.addListener(Event2.class, (EventListener)new EventListener<Event2>(){

            public void onEvent(Event2 event) {
                value[3] = "l";
            }
        });
        Event1 event = new Event1();
        this.eventBus.fire((EventBusEvent)event);
        Assert.assertNull((Object)value[0]);
        Assert.assertEquals((Object)"l", (Object)value[1]);
        Assert.assertNull((Object)value[2]);
        Assert.assertNull((Object)value[3]);
        Assert.assertNull((Object)value[4]);
    }

    @Test
    public void testAddListener() {
        final Object[] resp = new Object[]{null, null, null, null, null};
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNull((Object)resp[2]);
        Assert.assertNull((Object)resp[3]);
        Assert.assertNull((Object)resp[4]);
        this.eventBus.addListener(Event1.class, e -> {
            resp[0] = e;
        });
        this.eventBus.addListener(Event12.class, e -> {
            resp[1] = e;
        });
        this.eventBus.addListener(Event1.class.getPackage().getName(), Event1.class.getSimpleName(), e -> {
            resp[2] = e;
        });
        this.eventBus.addListener(Event12.class.getPackage().getName(), Event12.class.getSimpleName(), e -> {
            resp[3] = e;
        });
        this.eventBus.addHandler((AbstractHandler)new AbstractListenerHandler(this, null, null, new Object()){

            public void dispatch(Object event, Object source, boolean remotelyGeneratedEvent) {
                resp[4] = event;
            }

            public AbstractHandler.Type getRequiredEventType() {
                return AbstractHandler.Type.asIs;
            }
        });
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNotNull((Object)resp[0]);
        Assert.assertNotNull((Object)resp[1]);
        Assert.assertNotNull((Object)resp[2]);
        Assert.assertNotNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
    }

    @Test
    public void testFire() throws Exception {
        final Object[] resp = new Object[]{null, null, null, null, null};
        this.eventBus.addListener(Event1.class, e -> {
            resp[0] = e;
        });
        this.eventBus.addListener(Event12.class, e -> {
            resp[1] = e;
        });
        this.eventBus.addListener(Event1.class.getPackage().getName(), Event1.class.getSimpleName(), e -> {
            resp[2] = e;
        });
        this.eventBus.addListener(Event12.class.getPackage().getName(), Event12.class.getSimpleName(), e -> {
            resp[3] = e;
        });
        this.eventBus.addHandler((AbstractHandler)new AbstractListenerHandler(this, null, null, new Object()){

            public void dispatch(Object event, Object source, boolean remotelyGeneratedEvent) {
                resp[4] = event;
            }

            public AbstractHandler.Type getRequiredEventType() {
                return AbstractHandler.Type.asIs;
            }
        });
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertTrue((boolean)(resp[0] instanceof Event1));
        Assert.assertNull((Object)resp[1]);
        Assert.assertTrue((boolean)(resp[2] instanceof Element));
        Assert.assertNull((Object)resp[3]);
        Assert.assertTrue((boolean)(resp[4] instanceof Event1));
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertTrue((boolean)(resp[0] instanceof Event12));
        Assert.assertTrue((boolean)(resp[1] instanceof Event12));
        Assert.assertTrue((boolean)(resp[2] instanceof Element));
        Assert.assertTrue((boolean)(resp[3] instanceof Element));
        Assert.assertTrue((boolean)(resp[4] instanceof Event12));
        Arrays.fill(resp, null);
        this.eventBus.fire((Object)new Element("tigase.eventbus.impl.Event1"));
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertTrue((boolean)(resp[2] instanceof Element));
        Assert.assertNull((Object)resp[3]);
        Assert.assertTrue((boolean)(resp[4] instanceof Element));
        Arrays.fill(resp, null);
        this.eventBus.fire((Object)new Element("tigase.eventbus.impl.Event12"));
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNull((Object)resp[2]);
        Assert.assertTrue((boolean)(resp[3] instanceof Element));
        Assert.assertTrue((boolean)(resp[4] instanceof Element));
    }

    @Test
    public void testFireSync() throws ExecutionException, InterruptedException {
        long threadId = Thread.currentThread().getId();
        this.eventBus.setExecutor((Executor)Executors.newWorkStealingPool());
        CompletableFuture future = new CompletableFuture();
        ObjectEventsListenerHandler handler = new ObjectEventsListenerHandler(this, Event1.class.getPackage().getName(), Event1.class.getSimpleName(), e -> future.complete(Thread.currentThread().getId())){

            public boolean isSynchronous() {
                return true;
            }
        };
        this.eventBus.addHandler((AbstractHandler)handler);
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertEquals((long)threadId, (long)((Long)future.orTimeout(1L, TimeUnit.SECONDS).get()));
    }

    @Test
    public void testFireAsync() throws ExecutionException, InterruptedException {
        long threadId = Thread.currentThread().getId();
        this.eventBus.setExecutor((Executor)Executors.newWorkStealingPool());
        CompletableFuture future = new CompletableFuture();
        ObjectEventsListenerHandler handler = new ObjectEventsListenerHandler(Event1.class.getPackage().getName(), Event1.class.getSimpleName(), e -> future.complete(Thread.currentThread().getId()));
        this.eventBus.addHandler((AbstractHandler)handler);
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertNotEquals((long)threadId, (long)((Long)future.orTimeout(1L, TimeUnit.SECONDS).get()));
    }

    @Test
    public void testFireAndHandleXmlEventNoPackageName() {
        Element event = new Element("ShortNameEvent");
        event.withElement("data", null, "9842984");
        Element[] receivedEvent = new Element[]{null};
        this.eventBus.addListener("", "ShortNameEvent", event1 -> {
            receivedEvent[0] = event1;
        });
        this.eventBus.fire((Object)event);
        Assert.assertNotNull((Object)receivedEvent[0]);
        Assert.assertEquals((Object)"ShortNameEvent", (Object)receivedEvent[0].getName());
        Assert.assertEquals((Object)"9842984", (Object)receivedEvent[0].getChild("data").getCData());
    }

    @Test
    public void testFireAndHandleXmlEventLongName() {
        Element event = new Element("package.name.ShortNameEvent");
        event.withElement("data", null, "9842981");
        Element[] receivedEvent = new Element[]{null};
        this.eventBus.addListener("package.name", "ShortNameEvent", event1 -> {
            receivedEvent[0] = event1;
        });
        this.eventBus.fire((Object)event);
        Assert.assertNotNull((Object)receivedEvent[0]);
        Assert.assertEquals((Object)"package.name.ShortNameEvent", (Object)receivedEvent[0].getName());
        Assert.assertEquals((Object)"9842981", (Object)receivedEvent[0].getChild("data").getCData());
    }

    @Test
    public void testGetListenersForEvent_Element() throws Exception {
        this.eventBus.addListener(Event1.class, (EventListener)new EventListener<Event1>(this){

            public void onEvent(Event1 e) {
            }
        });
        this.eventBus.addListener(Event12.class, (EventListener)new EventListener<Event12>(this){

            public void onEvent(Event12 e) {
            }
        });
        this.eventBus.addListener(Event1.class.getPackage().getName(), Event1.class.getSimpleName(), (EventListener)new EventListener<Element>(this){

            public void onEvent(Element e) {
            }
        });
        this.eventBus.addListener(Event1.class.getPackage().getName(), null, (EventListener)new EventListener<Element>(this){

            public void onEvent(Element e) {
            }
        });
        this.eventBus.addListener(null, null, (EventListener)new EventListener<Element>(this){

            public void onEvent(Element e) {
            }
        });
        Assert.assertEquals((long)4L, (long)this.eventBus.getListenersForEvent(Event1.class).size());
        Assert.assertEquals((long)4L, (long)this.eventBus.getListenersForEvent(Event1.class.getPackage().getName(), Event1.class.getSimpleName()).size());
        Assert.assertEquals((long)5L, (long)this.eventBus.getListenersForEvent(Event12.class).size());
    }

    @Test
    public void testGetListenersForEvent_Object() throws Exception {
        this.eventBus.addListener(Event1.class, (EventListener)new EventListener<Event1>(this){

            public void onEvent(Event1 e) {
            }
        });
        this.eventBus.addListener(Event2.class, (EventListener)new EventListener<Event2>(this){

            public void onEvent(Event2 e) {
            }
        });
        this.eventBus.addListener(Event2.class, (EventListener)new EventListener<Event2>(this){

            public void onEvent(Event2 e) {
            }
        });
        this.eventBus.addListener(Event12.class, (EventListener)new EventListener<Event12>(this){

            public void onEvent(Event12 e) {
            }
        });
        this.eventBus.addListener(Event12.class, (EventListener)new EventListener<Event12>(this){

            public void onEvent(Event12 e) {
            }
        });
        Assert.assertEquals((long)1L, (long)this.eventBus.getListenersForEvent(Event1.class).size());
        Assert.assertEquals((long)2L, (long)this.eventBus.getListenersForEvent(Event2.class).size());
        Assert.assertEquals((long)3L, (long)this.eventBus.getListenersForEvent(Event12.class).size());
        Assert.assertEquals((long)0L, (long)this.eventBus.getListenersForEvent(String.class).size());
        Assert.assertEquals((long)1L, (long)this.eventBus.getListenersForEvent(Event1.class.getPackage().getName(), Event1.class.getSimpleName()).size());
        Assert.assertEquals((long)2L, (long)this.eventBus.getListenersForEvent(Event2.class.getPackage().getName(), Event12.class.getSimpleName()).size());
        Assert.assertEquals((long)2L, (long)this.eventBus.getListenersForEvent(Event12.class.getPackage().getName(), Event12.class.getSimpleName()).size());
    }

    @Test
    public void testRegisterAll() throws Exception {
        Consumer c = new Consumer();
        this.eventBus.registerAll((Object)c);
        Assert.assertNotNull((Object)this.eventBus.getEventRoutingSelector(Event1.class));
        Assert.assertNotNull((Object)this.eventBus.getEventRoutingSelector(Event12.class));
        Assert.assertNull((Object)this.eventBus.getEventRoutingSelector(Event2.class));
        Assert.assertEquals((long)1L, (long)this.eventBus.getEventRoutedTransientFillers(Event1.class).size());
        Assert.assertEquals((long)1L, (long)this.eventBus.getEventRoutedTransientFillers(Event12.class).size());
        Assert.assertEquals((long)0L, (long)this.eventBus.getEventRoutedTransientFillers(Event2.class).size());
        this.eventBus.fire((Object)new Event12(), (Object)this);
        Assert.assertNotNull((Object)c.resp[0]);
        Assert.assertNotNull((Object)c.resp[1]);
        Assert.assertNotNull((Object)c.resp[2]);
        Arrays.fill(c.resp, null);
        this.eventBus.unregisterAll((Object)c);
        Assert.assertNull((Object)this.eventBus.getEventRoutingSelector(Event1.class));
        Assert.assertNull((Object)this.eventBus.getEventRoutingSelector(Event12.class));
        Assert.assertNull((Object)this.eventBus.getEventRoutingSelector(Event2.class));
        Assert.assertEquals((long)0L, (long)this.eventBus.getEventRoutedTransientFillers(Event1.class).size());
        Assert.assertEquals((long)0L, (long)this.eventBus.getEventRoutedTransientFillers(Event12.class).size());
        Assert.assertEquals((long)0L, (long)this.eventBus.getEventRoutedTransientFillers(Event2.class).size());
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)c.resp[0]);
        Assert.assertNull((Object)c.resp[1]);
        Assert.assertNull((Object)c.resp[2]);
    }

    @Test
    public void testRegisterAll_InheritanceTest() {
        ConsumerChild c = new ConsumerChild();
        this.eventBus.registerAll((Object)c);
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertNotNull((Object)c.respChild[0]);
        Assert.assertNotNull((Object)c.respChild[1]);
        Assert.assertNotNull((Object)c.respChild[2]);
        Assert.assertNull((Object)c.respChild[3]);
        Assert.assertNull((Object)c.respChild[4]);
        Assert.assertNotNull((Object)c.respChild[5]);
        Assert.assertNotNull((Object)c.respChild[6]);
        Assert.assertNull((Object)c.respChild[7]);
        Assert.assertNull((Object)c.respParent[0]);
        Assert.assertNull((Object)c.respParent[1]);
        Assert.assertNotNull((Object)c.respParent[2]);
        Assert.assertNotNull((Object)c.respParent[3]);
        Assert.assertNotNull((Object)c.respParent[4]);
        Assert.assertNull((Object)c.respParent[5]);
        Assert.assertNotNull((Object)c.respParent[6]);
        Assert.assertNotNull((Object)c.respParent[7]);
    }

    @Test
    public void testRegisterAll_MethodVisibilityTest() {
        ConsumerMethodVisibility cmv = new ConsumerMethodVisibility();
        this.eventBus.registerAll((Object)cmv);
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertNotNull((Object)cmv.resp[0]);
        Assert.assertNotNull((Object)cmv.resp[1]);
        Assert.assertNotNull((Object)cmv.resp[2]);
        Arrays.fill(cmv.resp, null);
        this.eventBus.unregisterAll((Object)cmv);
        this.eventBus.fire((EventBusEvent)new Event1());
        Assert.assertNull((Object)cmv.resp[0]);
        Assert.assertNull((Object)cmv.resp[1]);
        Assert.assertNull((Object)cmv.resp[2]);
    }

    @Test
    public void testRemoveListener() {
        final Object[] resp = new Object[]{null, null, null, null, null};
        EventListener l0 = e -> {
            resp[0] = e;
        };
        this.eventBus.addListener(Event1.class, l0);
        EventListener l1 = e -> {
            resp[1] = e;
        };
        this.eventBus.addListener(Event12.class, l1);
        EventListener l2 = e -> {
            resp[2] = e;
        };
        this.eventBus.addListener(Event1.class.getPackage().getName(), Event1.class.getSimpleName(), l2);
        EventListener l3 = e -> {
            resp[3] = e;
        };
        this.eventBus.addListener(Event12.class.getPackage().getName(), Event12.class.getSimpleName(), l3);
        AbstractListenerHandler l4 = new AbstractListenerHandler(this, null, null, new Object()){

            public void dispatch(Object event, Object source, boolean remotelyGeneratedEvent) {
                resp[4] = event;
            }

            public AbstractHandler.Type getRequiredEventType() {
                return AbstractHandler.Type.asIs;
            }
        };
        this.eventBus.addHandler((AbstractHandler)l4);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNotNull((Object)resp[0]);
        Assert.assertNotNull((Object)resp[1]);
        Assert.assertNotNull((Object)resp[2]);
        Assert.assertNotNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
        this.eventBus.removeListener(l0);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNotNull((Object)resp[1]);
        Assert.assertNotNull((Object)resp[2]);
        Assert.assertNotNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
        this.eventBus.removeListener(l1);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNotNull((Object)resp[2]);
        Assert.assertNotNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
        this.eventBus.removeListener(l2);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNull((Object)resp[2]);
        Assert.assertNotNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
        this.eventBus.removeListener(l3);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNull((Object)resp[2]);
        Assert.assertNull((Object)resp[3]);
        Assert.assertNotNull((Object)resp[4]);
        this.eventBus.removeHandler((AbstractHandler)l4);
        Arrays.fill(resp, null);
        this.eventBus.fire((EventBusEvent)new Event12());
        Assert.assertNull((Object)resp[0]);
        Assert.assertNull((Object)resp[1]);
        Assert.assertNull((Object)resp[2]);
        Assert.assertNull((Object)resp[3]);
        Assert.assertNull((Object)resp[4]);
    }

    public static class Consumer {
        private final Object[] resp = new Object[]{null, null, null};

        @HandleEvent
        public void event0(Event1 e) {
            this.resp[0] = e;
        }

        @HandleEvent
        public void event1(Event12 e) {
            this.resp[1] = e;
        }

        @HandleEvent
        public void event2(Event12 e, Object source) {
            this.resp[2] = e;
            Assert.assertTrue((boolean)(source instanceof EventBusImplementationTest));
        }

        @FillRoutedEvent
        public void fillRoutedEvent1(Event1 e) {
        }

        @RouteEvent
        public Collection<Subscription> routeEvent1(Event1 e, Collection<Subscription> subscriptions) {
            return null;
        }
    }

    public static class ConsumerChild
    extends ConsumerParent {
        private final Object[] respChild = new Object[]{null, null, null, null, null, null, null, null};

        @Override
        @HandleEvent
        public void event0(Event1 e) {
            this.respChild[0] = e;
        }

        @Override
        public void event1(Event1 e) {
            this.respChild[1] = e;
        }

        @Override
        @HandleEvent
        public void event2(Event1 e) {
            this.respChild[2] = e;
            super.event2(e);
        }

        public void event3(Event1 e, String x) {
            this.respChild[3] = e;
        }

        @Override
        protected void event5(Event1 e) {
            this.respChild[5] = e;
        }

        @Override
        protected void event6(Event1 e) {
            this.respChild[6] = e;
            super.event6(e);
        }

        private void event4(Event1 e) {
            this.respChild[4] = e;
        }
    }

    public static class ConsumerMethodVisibility {
        private final Object[] resp = new Object[]{null, null, null};

        @HandleEvent
        public void event0public(Event1 e) {
            this.resp[0] = e;
        }

        @HandleEvent
        protected void event1protected(Event1 e) {
            this.resp[1] = e;
        }

        @HandleEvent
        private void event2private(Event1 e) {
            this.resp[2] = e;
        }
    }

    public static class ConsumerParent {
        protected final Object[] respParent = new Object[]{null, null, null, null, null, null, null, null};

        @HandleEvent
        public void event0(Event1 e) {
            this.respParent[0] = e;
        }

        @HandleEvent
        public void event1(Event1 e) {
            this.respParent[1] = e;
        }

        @HandleEvent
        public void event2(Event1 e) {
            this.respParent[2] = e;
        }

        @HandleEvent
        public void event3(Event1 e) {
            this.respParent[3] = e;
        }

        @HandleEvent
        protected void event5(Event1 e) {
            this.respParent[5] = e;
        }

        @HandleEvent
        protected void event6(Event1 e) {
            this.respParent[6] = e;
        }

        @HandleEvent
        protected void event7(Event1 e) {
            this.respParent[7] = e;
        }

        @HandleEvent
        private void event4(Event1 e) {
            this.respParent[4] = e;
        }
    }
}

