/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import org.junit.Assert;
import org.junit.Test;
import tigase.db.util.JDBCPasswordObfuscator;

public class JDBCPasswordObfuscatorTest {
    @Test
    public void obfuscateMysqlPassword() {
        String password = "tigase_password";
        String input = "jdbc:mysql://localhost/tigasedb?user=tigasedb&password=" + password + "&useSSL=false";
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost/tigasedb?user=tigasedb&password=***************&useSSL=false", (Object)obfuscated);
    }

    @Test
    public void obfuscateMysqlPasswordSimple() {
        String password = "tigase_password";
        String input = "jdbc:mysql://localhost/tigasedb?user=tigasedb&password=" + password;
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost/tigasedb?user=tigasedb&password=***************", (Object)obfuscated);
    }

    @Test
    public void obfuscatePostgresqlPassword() {
        String password = "tigase_password";
        String input = "jdbc:postgresql://localhost/tigasedb?user=tigasedb&password=" + password + "&useSSL=false";
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)("jdbc:postgresql://localhost/tigasedb?user=tigasedb&password=" + "*".repeat(password.length()) + "&useSSL=false"), (Object)obfuscated);
    }

    @Test
    public void obfuscateSqlserverSecurePassword() {
        String password = "1Secure*Password1";
        String input = "jdbc:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=" + password + ";schema=dbo;lastUpdateCount=false";
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)"jdbc:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=*****************;schema=dbo;lastUpdateCount=false", (Object)obfuscated);
    }

    @Test
    public void obfuscateSqlserverPassword() {
        String password = "tigase12";
        String input = "jdbc:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=" + password + ";schema=dbo;lastUpdateCount=false";
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)"jdbc:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=********;schema=dbo;lastUpdateCount=false", (Object)obfuscated);
    }

    @Test
    public void obfuscateJtdsSqlserverPassword() {
        String password = "tigase12";
        String input = "jdbc:jtds:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=" + password + ";schema=dbo;lastUpdateCount=false";
        String obfuscated = JDBCPasswordObfuscator.obfuscatePassword((String)input);
        Assert.assertEquals((Object)"jdbc:jtds:sqlserver://hostname:1433;databaseName=tigasedb;user=tigase;password=********;schema=dbo;lastUpdateCount=false", (Object)obfuscated);
    }
}

