/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import org.junit.After;
import org.junit.Before;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceTestCase;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;

public abstract class AbstractDataSourceAwareTestCase<DS extends DataSource, R extends DataSourceAware>
extends AbstractDataSourceTestCase<DS> {
    protected R repo;

    protected abstract Class<? extends DataSourceAware> getDataSourceAwareIfc();

    @Before
    public void setupDataSourceAware() throws Exception {
        this.repo = this.prepareDataSourceAware();
    }

    @After
    public void tearDown() throws Exception {
        this.repo = null;
    }

    protected R getDataSourceAware() {
        return this.repo;
    }

    protected R prepareDataSourceAware() throws Exception {
        Class dataSourceAwareClassForUri = DataSourceHelper.getDefaultClass(this.getDataSourceAwareIfc(), (String)uri);
        this.getKernel().registerBean("repository").asClass(dataSourceAwareClassForUri).setPinned(false).setActive(true).exec();
        DataSourceAware repo = this.getInstance(this.getDataSourceAwareIfc());
        try {
            repo.setDataSource(this.getDataSource());
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new RepositoryException((Throwable)ex);
        }
        return (R)repo;
    }
}

