/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.HandleEvent;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.OfflineMessages;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.push.AbstractPushNotifications;
import tigase.xmpp.impl.push.PushNotificationCause;
import tigase.xmpp.impl.push.PushNotificationsAware;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:push:0", parent=SessionManager.class, active=true, exportable=true)
@Id(value="urn:xmpp:push:0")
@DiscoFeatures(value={"urn:xmpp:push:0"})
@Handles(value={@Handle(path={"iq", "enable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"iq", "disable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"message"}, xmlns="jabber:client")})
public class PushNotifications
extends AbstractPushNotifications
implements XMPPProcessorIfc,
OfflineMessages.Notifier,
RegistrarBean {
    private static final Logger log = Logger.getLogger(PushNotifications.class.getCanonicalName());
    private Element[] discoFeatures = new Element[0];
    @Inject
    private ArrayList<PushNotificationsAware> awares = new ArrayList();
    @Inject
    private ArrayList<PushNotificationsExtension> triggers = new ArrayList();
    @Inject(nullAllowed=true)
    private ArrayList<PushNotificationsFilter> filters = new ArrayList();
    @ConfigField(desc="Send offline messages retrieved notification", alias="send-offline-messages-retrieved-notification")
    private boolean sendOfflineMessagesRetrievedNotification = true;
    @ConfigField(desc="Send account removal notification", alias="send-account-removal-notification")
    private boolean sendAccountRemovalNotification = false;

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return this.discoFeatures;
    }

    public void setAwares(ArrayList<PushNotificationsAware> awares) {
        this.awares = awares;
    }

    public void setFilter(ArrayList<PushNotificationsFilter> filters) {
        this.filters = Optional.ofNullable(filters).orElseGet(ArrayList::new);
        this.refreshDiscoFeatures();
    }

    public void setTriggers(ArrayList<PushNotificationsExtension> triggers) {
        this.triggers = triggers;
        this.refreshDiscoFeatures();
    }

    protected void refreshDiscoFeatures() {
        this.discoFeatures = (Element[])Stream.concat(Arrays.stream(super.supDiscoFeatures(null)), this.awares.stream().map(PushNotificationsAware::getDiscoFeatures).flatMap(Arrays::stream)).toArray(Element[]::new);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        try {
            if (packet.getElemName() == "message") {
                this.processMessage(packet, session, results::offer);
                return;
            }
            super.process(packet, session, nonAuthUserRepository, results, map);
        }
        catch (NotAuthorizedException ex) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not authorized", true));
        }
        catch (TigaseDBException ex) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true));
        }
    }

    @Override
    protected void processMessage(Packet packet, XMPPResourceConnection session, Consumer<Packet> consumer) throws NotAuthorizedException, TigaseDBException {
        super.processMessage(packet, session, consumer);
        if (session == null || !session.isAuthorized() || !this.shouldSendNotification(packet, session.getBareJID(), session)) {
            return;
        }
        this.sendPushNotification(session, PushNotificationCause.STANZA, packet, consumer);
    }

    @Override
    public void notifyNewOfflineMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> map) {
        if (packet.getElemName() != "message") {
            return;
        }
        if (!this.shouldSendNotification(packet, packet.getStanzaTo().getBareJID(), session)) {
            return;
        }
        try {
            this.sendPushNotification(session, PushNotificationCause.MESSAGES_FETCHED, packet, results::offer);
        }
        catch (UserNotFoundException ex) {
            log.log(Level.FINEST, "Could not send push notification for message " + String.valueOf(packet), ex);
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Could not send push notification for message " + String.valueOf(packet), ex);
        }
    }

    @Override
    public void notifyOfflineMessagesRetrieved(XMPPResourceConnection session, Queue<Packet> results) {
        try {
            BareJID userJid = session.getBareJID();
            Map<String, Element> pushServices = this.getPushServices(userJid);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Offline messages retrieved push notifications for JID: {0}, pushServices: {1}", new Object[]{userJid, pushServices});
            }
            if (pushServices.isEmpty()) {
                return;
            }
            this.notifyOfflineMessagesRetrieved(userJid, pushServices.values(), results::offer);
        }
        catch (UserNotFoundException | NotAuthorizedException ex) {
            log.log(Level.FINEST, "Could not send push notification about offline message retrieval by " + String.valueOf(session), ex);
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Could not send push notification about offline message retrieval by " + String.valueOf(session), ex);
        }
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @HandleEvent(filter=HandleEvent.Type.local, sync=true)
    public void onUserRemoved(UserRepository.UserBeforeRemovedEvent event) {
        try {
            if (!this.sendAccountRemovalNotification) {
                return;
            }
            Map<String, Element> pushServices = this.getPushServices(event.getJid());
            if (pushServices.isEmpty()) {
                return;
            }
            this.sendPushNotification(event.getJid(), pushServices.values(), null, PushNotificationCause.ACCOUNT_REMOVED, null, Map.of(), consumer -> {});
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Could not get push services for " + String.valueOf(event.getJid()), ex);
        }
    }

    @Override
    protected Element createSettingsElement(JID jid, String node, Element enableElem, Element optionsForm) {
        Element settingsEl = super.createSettingsElement(jid, node, enableElem, optionsForm);
        String name = enableElem.getAttributeStaticStr("name");
        if (name != null && !name.isBlank()) {
            settingsEl.setAttribute("name", name);
        }
        for (PushNotificationsAware trigger : this.awares) {
            trigger.processEnableElement(enableElem, settingsEl);
        }
        return settingsEl;
    }

    protected void notifyOfflineMessagesRetrieved(BareJID userJid, Collection<Element> pushServices, Consumer<Packet> packetConsumer) {
        if (!this.sendOfflineMessagesRetrievedNotification) {
            return;
        }
        HashMap<Enum, Long> map = new HashMap<Enum, Long>();
        map.put(MsgRepository.MSG_TYPES.message, 0L);
        this.sendPushNotification(userJid, pushServices, null, PushNotificationCause.MESSAGES_FETCHED, null, map, packetConsumer);
    }

    @Override
    protected Element prepareNotificationPayload(Element pushServiceSettings, PushNotificationCause cause, Packet packet, long msgCount) {
        Element notification = super.prepareNotificationPayload(pushServiceSettings, cause, packet, msgCount);
        for (PushNotificationsExtension trigger : this.triggers) {
            trigger.prepareNotificationPayload(pushServiceSettings, cause, packet, msgCount, notification);
        }
        return notification;
    }

    @Override
    protected boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        if (!super.isSendingNotificationAllowed(userJid, session, pushServiceSettings, packet)) {
            return false;
        }
        for (PushNotificationsFilter filter : this.filters) {
            if (filter.isSendingNotificationAllowed(userJid, session, pushServiceSettings, packet)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) {
        if (session == null && packet.getElemName() == "message" && packet.getElemChild("body") != null) {
            return true;
        }
        for (PushNotificationsExtension trigger : this.triggers) {
            try {
                if (!trigger.shouldSendNotification(packet, userJid, session)) continue;
                return true;
            }
            catch (XMPPException ex) {
                log.log(Level.FINER, "exception while checking if trigger " + trigger.getClass().getCanonicalName() + " should be fired", ex);
            }
        }
        return false;
    }

    @Bean(name="push-unregister-device", parent=SessionManager.class, active=true)
    public static class DisableDeviceAdHocCommand
    extends AbstractAdhocCommand {
        public DisableDeviceAdHocCommand() {
            super("push-disable-device", "Disable push notifications");
        }

        @Override
        protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
            try {
                return this.prepareForm(null);
            }
            catch (TigaseDBException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
            try {
                BareJID accountJid = BareJID.bareJIDInstance((String)this.assertNotEmpty(form.getAsString("userJid"), "Account JID is required!"));
                String key = form.getAsString("deviceId");
                if (this.isEmpty(key)) {
                    return this.prepareForm(accountJid);
                }
                int idx = key.indexOf(47);
                if (idx < 0) {
                    throw new RuntimeException("Invalid device ID: " + key);
                }
                JID jid = JID.jidInstance((String)key.substring(0, idx));
                String node = key.substring(idx + 1);
                this.getPushNotifications().disableNotifications(null, accountJid, jid, node, this.getComponent()::addOutPacket);
                return null;
            }
            catch (TigaseDBException | TigaseStringprepException | NotAuthorizedException e) {
                throw new RuntimeException(e);
            }
        }

        protected Form prepareForm(BareJID accountJid) throws TigaseDBException {
            Form form = new Form("form", "Unregister device", "Fill out and submit this form to disable sending push notifications to selected device");
            form.addField(Field.fieldJidSingle((String)"userJid", (String)(accountJid == null ? "" : accountJid.toString()), (String)"Account JID"));
            if (accountJid != null) {
                Map<String, Element> pushServices = this.getPushNotifications().getPushServices(accountJid);
                List entries = pushServices.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
                form.addField(Field.fieldListSingle((String)"deviceId", (String)"", (String)"Device", (String[])((String[])entries.stream().map(Map.Entry::getValue).map(settings -> Optional.ofNullable(settings.getAttributeStaticStr("name")).orElseGet(() -> settings.getAttributeStaticStr("jid") + " / " + settings.getAttributeStaticStr("node"))).toArray(String[]::new)), (String[])((String[])entries.stream().map(Map.Entry::getKey).toArray(String[]::new))));
            }
            return form;
        }
    }

    @Bean(name="push-list-devices", parent=SessionManager.class, active=true)
    public static class ListDevicesAdhocCommand
    extends AbstractAdhocCommand {
        public ListDevicesAdhocCommand() {
            super("push-list-devices", "List push devices");
        }

        @Override
        protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
            Form form = new Form("form", "Unregister device", "Fill out and submit this form to list enabled devices with push notifications");
            form.addField(Field.fieldJidSingle((String)"userJid", (String)"", (String)"Account JID"));
            return form;
        }

        @Override
        protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
            Form result = new Form("result", "List of push devices", null);
            try {
                BareJID accountJid = BareJID.bareJIDInstance((String)this.assertNotEmpty(form.getAsString("userJid"), "Account JID is required!"));
                Map<String, Element> pushServices = this.getPushNotifications().getPushServices(accountJid);
                String[] deviceIds = (String[])pushServices.keySet().stream().sorted().toArray(String[]::new);
                result.addField(Field.fieldTextMulti((String)"deviceIds", (String[])deviceIds, (String)"List of devices"));
                return result;
            }
            catch (TigaseDBException | TigaseStringprepException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static abstract class AbstractAdhocCommand
    implements AdHocCommand {
        private final String node;
        private final String name;
        @Inject
        private SessionManager component;
        @Inject
        private AbstractPushNotifications pushNotifications;

        protected AbstractAdhocCommand(String node, String name) {
            this.node = node;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNode() {
            return this.node;
        }

        @Override
        public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
            try {
                Element data = request.getCommand().getChild("x", "jabber:x:data");
                if (request.isAction("cancel")) {
                    response.cancelSession();
                } else if (data == null) {
                    response.getElements().add(this.prepareForm(request, response).getElement());
                    response.startSession();
                } else {
                    Form responseForm;
                    Form form = new Form(data);
                    if (form.isType("submit") && (responseForm = this.submitForm(request, response, form)) != null) {
                        response.getElements().add(responseForm.getElement());
                    }
                }
            }
            catch (AdHocCommandException ex) {
                throw ex;
            }
            catch (Exception e) {
                log.log(Level.FINE, "Exception during execution of adhoc command " + this.getNode(), e);
                throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        }

        protected abstract Form prepareForm(AdhHocRequest var1, AdHocResponse var2) throws AdHocCommandException;

        protected abstract Form submitForm(AdhHocRequest var1, AdHocResponse var2, Form var3) throws AdHocCommandException;

        protected boolean isEmpty(String input) {
            return input == null || input.isBlank();
        }

        protected String assertNotEmpty(String input, String message) throws AdHocCommandException {
            if (this.isEmpty(input)) {
                throw new AdHocCommandException(Authorization.BAD_REQUEST, message);
            }
            return input.trim();
        }

        @Override
        public boolean isAllowedFor(JID jid) {
            return this.component.isAdmin(jid);
        }

        public SessionManager getComponent() {
            return this.component;
        }

        public AbstractPushNotifications getPushNotifications() {
            return this.pushNotifications;
        }
    }
}

