/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.PushNotificationCause;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.jid.BareJID;

@Bean(name="encrypted", parent=PushNotifications.class, active=true)
public class EncryptedPushNotificationExtension
implements PushNotificationsExtension {
    private static final Logger log = Logger.getLogger(EncryptedPushNotificationExtension.class.getCanonicalName());
    public static final String XMLNS = "tigase:push:encrypt:0";
    private static final String AES128GCM_FEATURE = "tigase:push:encrypt:aes-128-gcm";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:push:encrypt:0"}), new Element("feature", new String[]{"var"}, new String[]{"tigase:push:encrypt:aes-128-gcm"})};
    private final SecureRandom random = new SecureRandom();
    @ConfigField(desc="Notification to display for encrypted messages", alias="encrypted-message-body")
    private String encryptedMessageBody = "New secure message. Open to see the message.";

    @Override
    public Element[] getDiscoFeatures() {
        return DISCO_FEATURES;
    }

    @Override
    public boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) throws XMPPException {
        return false;
    }

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        Element encryptEl = enableEl.getChild("encrypt", XMLNS);
        if (encryptEl == null) {
            return;
        }
        settingsEl.addChild((XMLNodeIfc)encryptEl);
    }

    @Override
    public void prepareNotificationPayload(Element pushServiceSettings, PushNotificationCause cause, Packet packet, long msgCount, Element notification) {
        Element encryptEl = pushServiceSettings.getChild("encrypt", XMLNS);
        if (encryptEl == null) {
            return;
        }
        String alg = encryptEl.getAttributeStaticStr("alg");
        long maxSizeBytes = Optional.ofNullable(encryptEl.getAttributeStaticStr("max-size")).map(Integer::parseInt).orElse(3000).intValue();
        String keyStr = encryptEl.getCData();
        if (alg == null || keyStr == null) {
            return;
        }
        if (!alg.equalsIgnoreCase("aes-128-gcm")) {
            return;
        }
        Element actionEl = null;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("unread", msgCount);
        if (packet != null) {
            String body;
            payload.put("sender", packet.getStanzaFrom().getBareJID());
            actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "urn:xmpp:jingle-message:0");
            if (packet.getElemName() == "message") {
                if (packet.getType() == StanzaType.groupchat) {
                    payload.put("type", "groupchat");
                    Element mix = packet.getElement().getChild("mix", "urn:xmpp:mix:core:1");
                    if (mix != null) {
                        String nickname;
                        Element nickEl = mix.getChild("nick");
                        if (nickEl != null && (nickname = nickEl.getCData()) != null) {
                            payload.put("nickname", nickname);
                        }
                    } else {
                        String nickname = packet.getStanzaFrom().getResource();
                        if (nickname != null) {
                            payload.put("nickname", nickname);
                        }
                    }
                } else if (actionEl != null) {
                    payload.put("type", "call");
                    payload.put("sender", packet.getStanzaFrom());
                    payload.put("sid", actionEl.getAttributeStaticStr("id"));
                    payload.put("media", actionEl.mapChildren(el -> el.getName() == "description" && el.getXMLNS() == "urn:xmpp:jingle:apps:rtp:1", el -> el.getAttributeStaticStr("media")));
                } else {
                    payload.put("type", "chat");
                }
            }
            boolean isEncrypted = packet.getElemChild("encrypted", "eu.siacs.conversations.axolotl") != null || packet.getElemChild("encrypted", "urn:xmpp:omemo:1") != null;
            String string = body = isEncrypted ? this.encryptedMessageBody : packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
            if (body != null) {
                int maxSize = (int)((maxSizeBytes - 64L) * 6L / 8L);
                body = EncryptedPushNotificationExtension.trimBodyToSize(maxSize, body);
                payload.put("message", body);
            }
        } else {
            switch (cause) {
                case ACCOUNT_REMOVED: {
                    payload.put("type", "account-removed");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        Element x = notification.getChild("x", "jabber:x:data");
        if (x != null) {
            notification.removeChild(x);
        }
        StringBuilder sb = new StringBuilder();
        EncryptedPushNotificationExtension.valueToString(payload, sb);
        String content = sb.toString();
        try {
            SecretKeySpec key = new SecretKeySpec(Base64.decode((String)keyStr), "AES");
            byte[] iv = new byte[12];
            this.random.nextBytes(iv);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, gcmParameterSpec);
            byte[] data = cipher.doFinal(content.getBytes(UTF8));
            Element encryped = new Element("encrypted", Base64.encode((byte[])data));
            if (actionEl != null) {
                encryped.setAttribute("type", "voip");
            }
            encryped.addAttribute("iv", Base64.encode((byte[])iv));
            encryped.setXMLNS(XMLNS);
            notification.addChild((XMLNodeIfc)encryped);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Could not encode payload", ex);
        }
    }

    public static String trimBodyToSize(int limit, String body) {
        CharsetEncoder enc = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer bb = ByteBuffer.allocate(limit);
        CharBuffer cb = CharBuffer.wrap(body);
        CoderResult r = enc.encode(cb, bb, true);
        return r.isOverflow() ? cb.flip().toString() : body;
    }

    protected static void valueToString(Object value, StringBuilder sb) {
        if (value instanceof Integer) {
            sb.append((Integer)value);
        } else if (value instanceof Double) {
            sb.append((Double)value);
        } else if (value instanceof String) {
            EncryptedPushNotificationExtension.escapeValue((String)value, sb);
        } else if (value instanceof List) {
            sb.append("[");
            boolean first = true;
            for (Object item : (List)value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                EncryptedPushNotificationExtension.valueToString(item, sb);
            }
            sb.append("]");
        } else if (value instanceof Map) {
            sb.append("{");
            boolean first = true;
            for (Map.Entry e : ((Map)value).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(e.getKey()).append("\" : ");
                EncryptedPushNotificationExtension.valueToString(e.getValue(), sb);
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
    }

    private static void escapeValue(String in, StringBuilder sb) {
        sb.append('\"');
        block8: for (char c : in.toCharArray()) {
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }
}

