/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.PacketWriterWithTimeout;
import tigase.server.amp.db.MsgRepository;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.push.PushNotificationCause;
import tigase.xmpp.impl.push.PushPresence;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@DiscoFeatures(value={"urn:xmpp:push:0"})
@Handles(value={@Handle(path={"iq", "enable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"iq", "disable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"message", "pubsub"}, xmlns="http://jabber.org/protocol/pubsub")})
public class AbstractPushNotifications
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    public static final String XMLNS = "urn:xmpp:push:0";
    public static final String ID = "urn:xmpp:push:0";
    private static final Logger log = Logger.getLogger(AbstractPushNotifications.class.getCanonicalName());
    private static final String JABBER_X_DATA_XMLNS = "jabber:x:data";
    private static final String SUMMARY_XMLNS = "urn:xmpp:push:0:summary";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    @ConfigField(desc="Send notifications with body", alias="with-body")
    protected boolean withBody = true;
    @ConfigField(desc="Send notifications with sender", alias="with-sender")
    protected boolean withSender = true;
    @ConfigField(desc="Max notification timeout", alias="max-timeout")
    protected Duration maxTimeout = Duration.ofMinutes(6L);
    @ConfigField(desc="Device registration TTL")
    private Duration deviceRegistrationTTL = null;
    @Inject
    private MsgRepositoryIfc msgRepository;
    @Inject
    private UserRepository userRepository;
    @Inject(bean="sess-man")
    private PacketWriterWithTimeout writer;
    @Inject(nullAllowed=true)
    private PushPresence pushDevicesPresence;
    @ConfigField(desc="Notification to display for encrypted messages", alias="encrypted-message-body")
    private String encryptedMessageBody = "New secure message. Open to see the message.";
    private static final TimestampHelper timestampHelper = new TimestampHelper();

    public PushPresence getPushDevicesPresence() {
        return this.pushDevicesPresence;
    }

    public void setPushDevicesPresence(PushPresence pushDevicesPresence) {
        this.pushDevicesPresence = pushDevicesPresence;
    }

    protected boolean shouldDisablePush(Authorization error) {
        if (error == null) {
            return false;
        }
        switch (error) {
            case REMOTE_SERVER_TIMEOUT: 
            case SERVICE_UNAVAILABLE: 
            case INTERNAL_SERVER_ERROR: 
            case BAD_REQUEST: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        try {
            if (packet.getElemName() == "message") {
                this.processMessage(packet, session, results::offer);
                return;
            }
            if (session == null || !session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, null, true));
                return;
            }
            Element actionEl = packet.getElement().findChild(element -> element.getXMLNS() == "urn:xmpp:push:0");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing PUSH registration, jid: {0}, actionEl: {1}", new Object[]{session.getjid(), actionEl});
            }
            if (actionEl != null) {
                String jidStr = actionEl.getAttributeStaticStr("jid");
                if (jidStr == null) {
                    throw new TigaseStringprepException("JID is NULL!");
                }
                JID jid = JID.jidInstance((String)actionEl.getAttributeStaticStr("jid"));
                String node = actionEl.getAttributeStaticStr("node");
                switch (actionEl.getName()) {
                    case "enable": {
                        this.enableNotifications(session, jid, node, actionEl, actionEl.findChild(element -> element.getXMLNS() == JABBER_X_DATA_XMLNS && element.getName() == "x"), results::offer);
                        break;
                    }
                    case "disable": {
                        this.disableNotifications(session, session.getBareJID(), jid, node, results::offer);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                        return;
                    }
                }
                results.offer(packet.okResult((Element)null, 0));
            }
        }
        catch (NotAuthorizedException ex) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not authorized", true));
        }
        catch (TigaseDBException ex) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true));
        }
        catch (TigaseStringprepException ex) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Attribute 'jid' is not valid JID of Push Notifications service", true));
        }
    }

    protected void processMessage(Packet packet, XMPPResourceConnection session, Consumer<Packet> results) throws NotAuthorizedException, TigaseDBException {
        Element affiliationEl;
        String node;
        Element pubsubEl = packet.getElemChild("pubsub", "http://jabber.org/protocol/pubsub");
        if (pubsubEl != null && (node = pubsubEl.getAttributeStaticStr("node")) != null && (affiliationEl = pubsubEl.getChild("affiliation")) != null) {
            String userJid = affiliationEl.getAttributeStaticStr("jid");
            if ("none".equals(affiliationEl.getAttributeStaticStr("affiliation")) && userJid != null) {
                BareJID bareJid = BareJID.bareJIDInstanceNS((String)userJid);
                this.userRepository.removeData(bareJid, "urn:xmpp:push:0", packet.getStanzaFrom().toString() + "/" + node);
                if (this.getPushServices(bareJid).isEmpty() && this.pushDevicesPresence != null) {
                    this.pushDevicesPresence.pushAvailabilityChanged(bareJid, false, results);
                }
            }
        }
    }

    protected void enableNotifications(XMPPResourceConnection session, JID jid, String node, Element enableElem, Element optionsForm, Consumer<Packet> packetConsumer) throws NotAuthorizedException, TigaseDBException {
        Element settings = this.createSettingsElement(jid, node, enableElem, optionsForm);
        this.enableNotifications(session, jid, node, settings, packetConsumer);
    }

    protected Element createSettingsElement(JID jid, String node, Element enableElem, Element optionsForm) {
        Element settings = new Element("settings", new String[]{"jid", "node", "createdAt"}, new String[]{jid.toString(), node.toString(), timestampHelper.format(new Date())});
        if (optionsForm != null) {
            settings.addChild((XMLNodeIfc)optionsForm);
        }
        return settings;
    }

    protected void enableNotifications(XMPPResourceConnection session, JID jid, String node, Element settings, Consumer<Packet> packetConsumer) throws NotAuthorizedException, TigaseDBException {
        String key = jid.toString() + "/" + node;
        Map<String, Element> pushServices = this.getPushServices(session);
        session.setData("urn:xmpp:push:0", key, settings.toString());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Enabled push notifications for JID: {0}, node: {1}, settings: {2}", new Object[]{jid, node, settings.toString()});
        }
        boolean hadPushServices = !pushServices.isEmpty();
        pushServices.put(key, settings);
        if (!hadPushServices && this.pushDevicesPresence != null) {
            this.pushDevicesPresence.pushAvailabilityChanged(session.getBareJID(), true, packetConsumer);
        }
    }

    protected void disableNotifications(XMPPResourceConnection session, BareJID userJid, JID jid, String node, Consumer<Packet> packetConsumer) throws NotAuthorizedException, TigaseDBException {
        Map<String, Element> pushServices;
        Map<String, Element> map = pushServices = session != null ? this.getPushServices(session) : this.getPushServices(userJid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Disabled push notifications for JID: {0}, node: {1}, pushServices: {2}", new Object[]{jid, node, pushServices});
        }
        if (pushServices != null) {
            boolean hadPushServices;
            boolean bl = hadPushServices = !pushServices.isEmpty();
            if (node != null) {
                String key2 = jid.toString() + "/" + node;
                pushServices.remove(key2);
                if (session != null) {
                    session.removeData("urn:xmpp:push:0", key2);
                } else {
                    this.userRepository.removeData(userJid, "urn:xmpp:push:0", key2);
                }
            } else {
                String prefix = jid.toString() + "/";
                ArrayList removed = new ArrayList();
                pushServices.keySet().removeIf(key -> {
                    if (key.startsWith(prefix)) {
                        removed.add(key);
                        return true;
                    }
                    return false;
                });
                for (String key3 : removed) {
                    if (session != null) {
                        session.removeData("urn:xmpp:push:0", key3);
                        continue;
                    }
                    this.userRepository.removeData(userJid, "urn:xmpp:push:0", key3);
                }
            }
            if (hadPushServices && pushServices.isEmpty() && this.pushDevicesPresence != null) {
                this.pushDevicesPresence.pushAvailabilityChanged(session != null ? session.getBareJID() : userJid, false, packetConsumer);
            }
        }
    }

    protected Map<String, Element> getPushServices(XMPPResourceConnection session) {
        return (Map)session.computeCommonSessionDataIfAbsent("urn:xmpp:push:0", key -> {
            ConcurrentHashMap<String, Element> pushServices = new ConcurrentHashMap<String, Element>();
            try {
                pushServices.putAll(this.getPushServices(session.getBareJID()));
            }
            catch (UserNotFoundException | NotAuthorizedException ex) {
                log.log(Level.FINEST, "Could not load push services for session " + String.valueOf(session), ex);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Could not load push services for session " + String.valueOf(session), ex);
            }
            return pushServices;
        });
    }

    protected Element prepareNotificationPayload(Element pushServiceSettings, PushNotificationCause cause, Packet packet, long msgCount) {
        Element notification = new Element("notification", new String[]{"xmlns"}, new String[]{"urn:xmpp:push:0"});
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{JABBER_X_DATA_XMLNS});
        notification.addChild((XMLNodeIfc)x);
        DataForm.addFieldValue(notification, "FORM_TYPE", SUMMARY_XMLNS);
        DataForm.addFieldValue(notification, "message-count", String.valueOf(msgCount));
        if (packet != null) {
            if (this.withSender) {
                DataForm.addFieldValue(notification, "last-message-sender", packet.getStanzaFrom().toString());
            }
            if (this.withBody) {
                boolean isEncrypted = packet.getElemChild("encrypted", "eu.siacs.conversations.axolotl") != null || packet.getElemChild("encrypted", "urn:xmpp:omemo:1") != null;
                DataForm.addFieldValue(notification, "last-message-body", isEncrypted ? this.encryptedMessageBody : packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH));
            }
            if (this.withSender && packet.getElemName() == "message" && packet.getType() == StanzaType.groupchat) {
                Element mix = packet.getElement().getChild("mix", "urn:xmpp:mix:core:1");
                if (mix != null) {
                    String nick;
                    Element nickEl = mix.getChild("nick");
                    if (nickEl != null && (nick = nickEl.getCData()) != null) {
                        Element groupchat = new Element("groupchat");
                        groupchat.setXMLNS("http://tigase.org/protocol/muc#offline");
                        groupchat.addChild((XMLNodeIfc)new Element("nickname", nick));
                        notification.addChild((XMLNodeIfc)groupchat);
                    }
                } else {
                    Element groupchat = new Element("groupchat");
                    groupchat.setXMLNS("http://tigase.org/protocol/muc#offline");
                    groupchat.addChild((XMLNodeIfc)new Element("nickname", packet.getStanzaFrom().getResource()));
                    notification.addChild((XMLNodeIfc)groupchat);
                }
            }
        } else if (cause == PushNotificationCause.ACCOUNT_REMOVED) {
            Element eventEl = new Element("event");
            eventEl.setXMLNS("http://tigase.org/protocol/account#event");
            eventEl.setAttribute("name", "account-removed");
            notification.addChild((XMLNodeIfc)eventEl);
        }
        return notification;
    }

    protected void sendPushNotification(BareJID userJid, Collection<Element> pushServices, XMPPResourceConnection session, PushNotificationCause cause, Packet packet, Map<Enum, Long> notificationData, Consumer<Packet> packetConsumer) {
        for (Element settings : pushServices) {
            try {
                Date createdAt;
                if (packet != null && !this.isSendingNotificationAllowed(userJid, session, settings, packet)) continue;
                JID pushService = JID.jidInstance((String)settings.getAttributeStaticStr("jid"));
                String pushNode = settings.getAttributeStaticStr("node");
                if (this.deviceRegistrationTTL != null && (createdAt = timestampHelper.parseTimestamp(settings.getAttributeStaticStr("createdAt"))) != null && Duration.between(createdAt.toInstant(), Instant.now()).compareTo(this.deviceRegistrationTTL) > 0) {
                    log.log(Level.WARNING, "disabling push service " + String.valueOf(pushService) + "/" + pushNode + " for user " + String.valueOf(userJid) + ", expired due to TTL");
                    this.disableNotifications(session, userJid, pushService, pushNode, packetConsumer);
                    continue;
                }
                Element notification = this.prepareNotificationPayload(settings, cause, packet, notificationData.getOrDefault((Object)MsgRepository.MSG_TYPES.message, 0L));
                Element publishOptionsForm = settings.findChild(element -> element.getXMLNS() == JABBER_X_DATA_XMLNS && element.getName() == "x");
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Push notifications for JID: {0}, notification: {1}, pushServices: {2}", new Object[]{userJid, notification, pushService});
                }
                this.sendPushNotification(userJid, notification, pushService, pushNode, publishOptionsForm);
            }
            catch (Exception ex) {
                log.log(Level.FINE, "Could not publish notification for " + String.valueOf(userJid) + " to " + settings.getAttributeStaticStr("jid") + " at " + settings.getAttributeStaticStr("node"));
            }
        }
    }

    protected Map<String, Element> getPushServices(BareJID userJid) throws TigaseDBException {
        return this.userRepository.getDataMap(userJid, "urn:xmpp:push:0", this::parseElement);
    }

    protected void sendPushNotification(XMPPResourceConnection session, PushNotificationCause cause, Packet packet, Consumer<Packet> packetConsumer) throws TigaseDBException {
        Map<String, Element> pushServices;
        BareJID userJid = packet.getStanzaTo().getBareJID();
        Map<String, Element> map = pushServices = session != null && session.isAuthorized() ? this.getPushServices(session) : this.getPushServices(userJid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending push notifications for JID: {0}, packet: {1}, pushServices: {2}", new Object[]{userJid, packet, pushServices});
        }
        if (pushServices.isEmpty()) {
            return;
        }
        Map<Enum, Long> typesCount = this.msgRepository.getMessagesCount(packet.getStanzaTo());
        this.sendPushNotification(userJid, pushServices.values(), session, cause, packet, typesCount, packetConsumer);
    }

    protected boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        return true;
    }

    private void sendPushNotification(BareJID userJid, Element notification, JID pushService, String pushNode, Element publishOptionsForm) {
        Element iq = new Element("iq", new String[]{"xmlns", "type"}, new String[]{"jabber:client", StanzaType.set.name()});
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish", new String[]{"node"}, new String[]{pushNode});
        pubsub.addChild((XMLNodeIfc)publish);
        Element item = new Element("item");
        publish.addChild((XMLNodeIfc)item);
        item.addChild((XMLNodeIfc)notification);
        if (publishOptionsForm != null) {
            Element publishOptions = new Element("publish-options");
            publishOptions.addChild((XMLNodeIfc)publishOptionsForm);
            pubsub.addChild((XMLNodeIfc)publishOptions);
        }
        this.writer.addOutPacketWithTimeout(new Iq(iq, JID.jidInstanceNS(null, (String)userJid.getDomain(), null), pushService), this.maxTimeout, result -> {
            if (result == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "push notification delivery to " + String.valueOf(pushService) + " from " + String.valueOf(userJid) + " timed out!");
                }
                return;
            }
            if (!this.shouldDisablePush(Authorization.getByCondition(result.getErrorCondition()))) {
                return;
            }
            try {
                this.userRepository.removeData(userJid, "urn:xmpp:push:0", String.valueOf(pushService) + "/" + pushNode);
            }
            catch (TigaseDBException ex) {
                log.log(Level.FINEST, "could not disable push for " + String.valueOf(userJid) + " on " + String.valueOf(pushService) + "/" + pushNode, ex);
            }
        });
    }

    private Element parseElement(String data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        return elems == null ? null : (Element)elems.poll();
    }
}

