/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public abstract class SimpleForwarder
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static Logger log = Logger.getLogger(SimpleForwarder.class.getName());

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            BareJID id = packet.getStanzaTo().getBareJID();
            if (session.isUserId(id)) {
                Packet result = packet.copyElementOnly();
                result.setStableId(packet.getStableId());
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else {
                Packet result = packet.copyElementOnly();
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + String.valueOf(packet));
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

