/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.XmppSaslException;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SaslAuthAbstract;
import tigase.xmpp.jid.BareJID;

@Bean(name="urn:ietf:params:xml:ns:xmpp-sasl", parent=SessionManager.class, active=true)
public class SaslAuth
extends SaslAuthAbstract
implements XMPPProcessorIfc {
    public static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String _XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    private static final String[][] ELEMENTS = new String[][]{{"auth"}, {"response"}, {"challenge"}, {"failure"}, {"success"}, {"abort"}};
    private static final Logger log = Logger.getLogger(SaslAuth.class.getName());
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block31: {
                if (session.getSessionData("authentication-timeout") != null) {
                    return;
                }
                String clientIp = BruteForceLockerBean.getClientIp(session);
                if (session.isAuthorized()) {
                    this.processSessionAlreadyAuthorized(packet, session, results);
                    return;
                }
                Element request = packet.getElement();
                try {
                    SaslServer ss;
                    if ("auth" == request.getName()) {
                        String mechanismName = packet.getElement().getAttributeStaticStr("mechanism");
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Start SASL auth. mechanism=" + mechanismName);
                        }
                        Collection<String> allowedMechanisms = (Collection<String>)session.getSessionData("allowed-sasl-mechanisms");
                        session.removeSessionData("allowed-sasl-mechanisms");
                        if (allowedMechanisms == null) {
                            allowedMechanisms = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
                        }
                        if (mechanismName == null || allowedMechanisms == null || !allowedMechanisms.contains(mechanismName)) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        CallbackHandler cbh = this.saslProvider.create(mechanismName, session, repo, settings);
                        ss = Sasl.createSaslServer(mechanismName, "xmpp", session.getDomain().getVhost().getDomain(), this.props, cbh);
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        session.putSessionData("SASL_SERVER_KEY", ss);
                    } else if ("response" == request.getName()) {
                        ss = (SaslServer)session.getSessionData("SASL_SERVER_KEY");
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                        }
                    } else {
                        throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Unrecognized element " + request.getName());
                    }
                    String cdata = request.getCData();
                    byte[] data = cdata != null && cdata.length() == 1 && cdata.equals("=") ? new byte[]{} : (cdata != null && cdata.length() > 0 ? Base64.decode((String)cdata) : new byte[]{});
                    byte[] challenge = ss.evaluateResponse(data);
                    String challengeData = challenge != null ? Base64.encode((byte[])challenge) : null;
                    if (ss.isComplete() && ss.getAuthorizationID() != null) {
                        boolean anonymous;
                        BareJID jid = ss.getAuthorizationID().contains("@") ? BareJID.bareJIDInstance((String)ss.getAuthorizationID()) : BareJID.bareJIDInstance((String)ss.getAuthorizationID(), (String)session.getDomain().getVhost().getDomain());
                        if (this.isLoginAllowedByBruteForceLocker(session, clientIp, jid)) {
                            throw new BruteForceLockerBean.LoginLockedException();
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.finest("Authorized as " + String.valueOf(jid));
                        }
                        try {
                            Boolean x = (Boolean)ss.getNegotiatedProperty("IS_ANONYMOUS");
                            anonymous = x != null && x != false;
                        }
                        catch (Exception e) {
                            anonymous = false;
                        }
                        session.removeSessionData("SASL_SERVER_KEY");
                        session.authorizeJID(jid, anonymous);
                        if (session.getAuthRepository() != null) {
                            session.getAuthRepository().loggedIn(jid);
                        }
                        this.processSuccess(packet, session, challengeData, results);
                        break block31;
                    }
                    if (!ss.isComplete()) {
                        results.offer(packet.swapFromTo(this.createReply(ElementType.CHALLENGE, challengeData), null, null));
                        break block31;
                    }
                    throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                }
                catch (BruteForceLockerBean.LoginLockedException e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Account locked by BruteForceLocker.");
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.not_authorized, AbstractSasl.PASSWORD_NOT_VERIFIED_MSG, packet));
                }
                catch (XmppSaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    results.offer(this.createSaslErrorResponse(e.getSaslError(), e.getMessage(), packet));
                }
                catch (SaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.not_authorized, null, packet));
                }
                catch (Exception e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Problem with SASL", e);
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.temporary_auth_failure, null, packet));
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        Collection<String> auth_mechs = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
        if (auth_mechs.isEmpty()) {
            return null;
        }
        Element[] mechs = new Element[auth_mechs.size()];
        int idx = 0;
        session.putSessionData("allowed-sasl-mechanisms", auth_mechs);
        for (String mech : auth_mechs) {
            mechs[idx++] = new Element("mechanism", mech);
        }
        return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    }

    @Override
    protected String getXmlns() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    @Override
    protected void processSuccess(Packet packet, XMPPResourceConnection session, String challengeData, Queue<Packet> results) {
        results.offer(packet.swapFromTo(this.createReply(ElementType.SUCCESS, challengeData), null, null));
    }

    protected Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.getElementName());
        reply.setXMLNS(this.getXmlns());
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    public static enum ElementType {
        ABORT,
        AUTH,
        CHALLENGE,
        FAILURE,
        RESPONSE,
        SUCCESS;

        private static final Map<String, ElementType> ALL_TYPES;
        private final String elementName = this.name().toLowerCase();

        public static ElementType parse(String name) {
            return ALL_TYPES.get(name);
        }

        public String getElementName() {
            return this.elementName;
        }

        static {
            ALL_TYPES = Arrays.stream(ElementType.values()).collect(Collectors.toMap(ElementType::getElementName, Function.identity()));
        }
    }
}

