/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.roster.DynamicRoster;
import tigase.xmpp.impl.roster.RepositoryAccessException;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterRetrievingException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class PresenceAbstract
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    public static final String PRESENCE_ELEMENT_NAME = "presence";
    public static final String SKIP_OFFLINE_PROP_KEY = "skip-offline";
    public static final String PRESENCE_PROBE_FULL_JID_KEY = "probe-full-jid";
    public static final String SKIP_OFFLINE_SYS_PROP_KEY = "skip-offline-sys";
    public static final String USERS_STATUS_CHANGES = "Users status changes";
    protected static final String XMLNS = "jabber:client";
    private static final Logger log = Logger.getLogger(PresenceAbstract.class.getName());
    @ConfigField(desc="Probe full JID", alias="probe-full-jid")
    protected static boolean probeFullJID = false;
    @ConfigField(desc="Skip offline", alias="skip-offline")
    protected static boolean skipOffline = false;
    @ConfigField(desc="Skip offline sys", alias="skip-offline-sys")
    private static boolean skipOfflineSys = false;
    protected RosterAbstract roster_util = PresenceAbstract.getRosterUtil();
    @Inject(nullAllowed=true)
    private DynamicRoster dynamicRoster;

    protected static void forwardPresence(Queue<Packet> results, Packet packet, JID from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from.toString());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "\n\nFORWARD presence: {0}", result.toString());
        }
        results.offer(Packet.packetInstance(result, from, packet.getStanzaTo()));
    }

    protected static RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    protected static Element prepareProbe(XMPPResourceConnection session) throws NotAuthorizedException {
        Element presProbe = new Element(PRESENCE_ELEMENT_NAME);
        presProbe.setXMLNS(XMLNS);
        presProbe.setAttribute("type", StanzaType.probe.toString());
        if (probeFullJID) {
            presProbe.setAttribute("from", session.getJID().toString());
        } else {
            presProbe.setAttribute("from", session.getBareJID().toString());
        }
        return presProbe;
    }

    protected static boolean requiresPresenceSending(RosterAbstract roster, JID buddy, XMPPResourceConnection session, boolean systemCheck) throws NotAuthorizedException, TigaseDBException {
        boolean result = true;
        if (!systemCheck) {
            boolean isOnline = roster.isOnline(session, buddy);
            if (skipOffline && !isOnline) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | buddy: {1} is online: {2}", new Object[]{session.getJID(), buddy, isOnline});
                }
                if (result) {
                    // empty if block
                }
                result = false;
            }
        }
        if (skipOfflineSys) {
            TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
            boolean isJidOnline = runtime.isJidOnline(buddy);
            if (runtime.hasCompleteJidsInfo() && session.isLocalDomain(buddy.getDomain(), false) && !isJidOnline) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | buddy: {1} is online (sys): {2}", new Object[]{session.getJID(), buddy, isJidOnline});
                }
                if (result) {
                    // empty if block
                }
                result = false;
            }
        }
        return result;
    }

    public static Packet sendPresence(StanzaType t, JID from, JID to, Queue<Packet> results, Element pres) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Element presence = null;
        Packet result = null;
        if (pres == null) {
            presence = new Element(PRESENCE_ELEMENT_NAME);
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
            if (null != from) {
                presence.setAttribute("from", from.toString());
            }
            presence.setXMLNS(XMLNS);
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to.toString());
        try {
            result = Packet.packetInstance(presence);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending presence info: {0}", result);
            }
            results.offer(result);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.FINE, "Packet stringprep addressing problem, skipping presence send: {0}", presence);
        }
        return result;
    }

    public static void sendPresence(StanzaType t, BareJID from, BareJID to, Queue<Packet> results, Element pres) {
        PresenceAbstract.sendPresence(t, JID.jidInstance((BareJID)from), JID.jidInstance((BareJID)to), results, pres);
    }

    public static void updatePresenceChange(Packet presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean initial_p = presence.getAttributeStaticStr("type") == null || "available".equals(presence.getAttributeStaticStr("type")) || "unavailable".equals(presence.getAttributeStaticStr("type"));
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (conn.getPresence() == null && initial_p) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Skipping update presence change for a resource which hasn't sent initial presence yet, or is remote connection: " + String.valueOf(conn));
                continue;
            }
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + String.valueOf(conn));
                }
                Packet pres_update = presence.copyElementOnly();
                pres_update.initVars(presence.getStanzaFrom(), conn.getJID().copyWithoutResource());
                pres_update.setPacketTo(conn.getConnectionId());
                results.offer(pres_update);
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    public static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results, boolean initial) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn.isResourceSet()) {
                    Element pres_update = presence.clone();
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    Element presence_el = conn.getPresence();
                    if (presence_el == null || !initial || conn == session) continue;
                    pres_update = presence_el.clone();
                    pack_update = Packet.packetInstance(pres_update, conn.getJID(), session.getJID().copyWithoutResource());
                    pack_update.setPacketTo(session.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + String.valueOf(conn.getJID()));
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    public boolean isSkipOfflineSys() {
        return skipOfflineSys;
    }

    public void setSkipOfflineSys(boolean skipOfflineSys) {
        PresenceAbstract.skipOfflineSys = skipOfflineSys;
    }

    public boolean isSkipOffline() {
        return skipOffline;
    }

    public void setSkipOffline(boolean skipOffline) {
        PresenceAbstract.skipOffline = skipOffline;
    }

    public boolean getProbeFullJID() {
        return probeFullJID;
    }

    public void setProbeFullJID(boolean probeFullJID) {
        PresenceAbstract.probeFullJID = probeFullJID;
    }

    protected boolean forceSendingProbe() {
        return true;
    }

    public void broadcastProbe(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Broadcasting probes for: {0}", session);
        }
        Element presInit = session.getPresence();
        Element presProbe = PresenceAbstract.prepareProbe(session);
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.SUB_BOTH);
        try {
            buddies = DynamicRoster.addBuddies(session, settings, buddies, RosterAbstract.SUB_BOTH);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies != null) {
            for (JID buddy : buddies) {
                if (this.forceSendingProbe() || PresenceAbstract.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Sending presence probe to: " + String.valueOf(buddy));
                    }
                    PresenceAbstract.sendPresence(null, session.getBareJID(), buddy.getBareJID(), results, presProbe);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Sending initial presence to: " + String.valueOf(buddy));
                    }
                    PresenceAbstract.sendPresence(null, session.getBareJID(), buddy.getBareJID(), results, presInit);
                    this.roster_util.setPresenceSent(session, buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Skipping sending initial presence and probe to: " + String.valueOf(buddy));
            }
        }
        JID[] buddies_to = this.roster_util.getBuddies(session, RosterAbstract.SUB_TO);
        try {
            buddies_to = DynamicRoster.addBuddies(session, settings, buddies_to, RosterAbstract.SUB_TO);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies_to != null) {
            for (JID buddy : buddies_to) {
                if (this.forceSendingProbe() || PresenceAbstract.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Sending probe to: " + String.valueOf(buddy));
                    }
                    PresenceAbstract.sendPresence(null, session.getBareJID(), buddy.getBareJID(), results, presProbe);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Skipping sending presence probe to: " + String.valueOf(buddy));
            }
        }
        JID[] buddies_from = this.roster_util.getBuddies(session, RosterAbstract.SUB_FROM);
        try {
            buddies_from = DynamicRoster.addBuddies(session, settings, buddies_from, RosterAbstract.SUB_FROM);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies_from != null) {
            for (JID buddy : buddies_from) {
                if (PresenceAbstract.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Sending initial presence to: " + String.valueOf(buddy));
                    }
                    PresenceAbstract.sendPresence(null, session.getBareJID(), buddy.getBareJID(), results, presInit);
                    this.roster_util.setPresenceSent(session, buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, String.valueOf(session.getBareJID()) + " | Skipping sending initial presence and probe to: " + String.valueOf(buddy));
            }
        }
    }

    @Override
    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 4;
    }
}

