/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.AbstractAuthPreprocessor;
import tigase.xmpp.jid.BareJID;

@Bean(name="jabber:iq:auth", parent=SessionManager.class, active=true)
public class JabberIqAuth
extends AbstractAuthPreprocessor
implements XMPPProcessorIfc {
    private static final String[][] ELEMENT_PATHS = new String[][]{Iq.IQ_QUERY_PATH};
    private static final Logger log = Logger.getLogger(JabberIqAuth.class.getName());
    private static final String XMLNS = "jabber:iq:auth";
    protected static final String ID = "jabber:iq:auth";
    private static final String[] XMLNSS = new String[]{"jabber:iq:auth"};
    private static final String[] IQ_QUERY_USERNAME_PATH = new String[]{"iq", "query", "username"};
    private static final String[] IQ_QUERY_RESOURCE_PATH = new String[]{"iq", "query", "resource"};
    private static final String[] IQ_QUERY_PASSWORD_PATH = new String[]{"iq", "query", "password"};
    private static final String[] IQ_QUERY_DIGEST_PATH = new String[]{"iq", "query", "digest"};
    private static final Element[] FEATURES = new Element[]{new Element("auth", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-auth"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:auth"})};
    @Inject
    private TigaseSaslProvider saslProvider;

    @Override
    public String id() {
        return "jabber:iq:auth";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            if (session.getSessionData("authentication-timeout") != null) {
                return;
            }
            if (session.isAuthorized()) {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Cannot authenticate twice on the same stream.", false);
                res.setPriority(Priority.SYSTEM);
                results.offer(res);
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
                }
                try {
                    session.logout();
                }
                catch (NotAuthorizedException ex) {
                    log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session after logout: {0}", session.toString());
                }
                return;
            }
            Element request = packet.getElement();
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    try {
                        StringBuilder response = new StringBuilder("<username/>");
                        Collection<String> auth_mechs = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
                        if (auth_mechs.contains("PLAIN")) {
                            response.append("<password/>");
                        }
                        response.append("<resource/>");
                        results.offer(packet.okResult(response.toString(), 1));
                    }
                    catch (NullPointerException ex) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Database problem, most likely misconfiguration error: " + String.valueOf(ex));
                        }
                        results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
                    }
                    break;
                }
                case set: {
                    String user_name = request.getChildCDataStaticStr(IQ_QUERY_USERNAME_PATH);
                    String resource = request.getChildCDataStaticStr(IQ_QUERY_RESOURCE_PATH);
                    String password = request.getChildCDataStaticStr(IQ_QUERY_PASSWORD_PATH);
                    String digest = request.getChildCDataStaticStr(IQ_QUERY_DIGEST_PATH);
                    if (user_name == null || resource == null || password == null && digest == null) {
                        results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Authentication failed: Required Information Not Provided", false));
                        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                        return;
                    }
                    try {
                        BareJID user_id = BareJID.bareJIDInstance((String)user_name, (String)session.getDomain().getVhost().getDomain());
                        AuthRepository.AccountStatus status = session.getAuthRepository().getAccountStatus(user_id);
                        switch (status) {
                            case pending: {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Account is pending verification, please confirm the email address by clicking on the link sent to you", false));
                                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                                return;
                            }
                            case disabled: 
                            case banned: 
                            case spam: 
                            case undefined_inactive: {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Account was disabled, please contact the support", false));
                                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                                return;
                            }
                        }
                        Authorization result = this.doAuth(repo, settings, session, user_id, password, digest);
                        if (result == Authorization.AUTHORIZED) {
                            if (resource != null && !resource.isEmpty()) {
                                session.setResource(resource);
                            }
                            results.offer(session.getAuthState().getResponseMessage(packet, "Authentication successful.", false));
                            break;
                        }
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Authentication failed", false));
                        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    }
                    catch (Exception e) {
                        log.log(Level.CONFIG, "Authentication failed: " + user_name);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Authorization exception: ", e);
                        }
                        Packet response = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, e.getMessage(), false);
                        response.setPriority(Priority.SYSTEM);
                        results.offer(response);
                        Integer retries = (Integer)session.getSessionData("auth-retries");
                        if (retries == null) {
                            retries = new Integer(0);
                        }
                        if (retries < 3) {
                            session.putSessionData("auth-retries", new Integer(retries + 1));
                            break;
                        }
                        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    }
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false));
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        if (session.isTlsRequired() && !session.isEncrypted()) {
            return null;
        }
        return FEATURES;
    }

    protected Authorization doAuth(NonAuthUserRepository repo, Map<String, Object> settings, XMPPResourceConnection session, BareJID user_id, String password, String digest) {
        try {
            String clientIp;
            block8: {
                CallbackHandler cbh = this.saslProvider.create("PLAIN", session, repo, settings);
                NameCallback nc = new NameCallback("Authentication identity", user_id.getLocalpart());
                VerifyPasswordCallback vpc = new VerifyPasswordCallback(password);
                clientIp = BruteForceLockerBean.getClientIp(session);
                cbh.handle(new Callback[]{nc});
                try {
                    cbh.handle(new Callback[]{vpc});
                    if (vpc.isVerified()) {
                        if (this.isLoginAllowedByBruteForceLocker(session, clientIp, user_id)) {
                            this.addInvalidLogin(session, clientIp, user_id);
                            return Authorization.NOT_AUTHORIZED;
                        }
                        session.authorizeJID(user_id, false);
                        return Authorization.AUTHORIZED;
                    }
                }
                catch (UnsupportedCallbackException e) {
                    PasswordCallback pc = new PasswordCallback("Password", false);
                    cbh.handle(new Callback[]{pc});
                    char[] p = pc.getPassword();
                    if (p == null || !password.equals(new String(p))) break block8;
                    if (this.isLoginAllowedByBruteForceLocker(session, clientIp, user_id)) {
                        this.addInvalidLogin(session, clientIp, user_id);
                        return Authorization.NOT_AUTHORIZED;
                    }
                    session.authorizeJID(user_id, false);
                    return Authorization.AUTHORIZED;
                }
            }
            if (this.isBruteForceLockerEnabled(session)) {
                this.addInvalidLogin(session, clientIp, user_id);
            }
            return Authorization.NOT_AUTHORIZED;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can''t authenticate with given CallbackHandler", e);
            return Authorization.INTERNAL_SERVER_ERROR;
        }
    }
}

