/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPProcessorConcurrencyAwareIfc;
import tigase.xmpp.XMPPResourceConnection;

public abstract class XMPPProcessor
implements XMPPImplIfc,
XMPPProcessorConcurrencyAwareIfc {
    protected static final String ALL_NAMES = "*";
    protected static final String[][] ALL_PATHS = new String[][]{{"*"}};
    private static final Logger log = Logger.getLogger(XMPPProcessor.class.getName());
    protected static ComponentInfo cmpInfo = null;
    @ConfigField(desc="Queue size which should be used by processor")
    private Integer queueSize = null;
    @ConfigField(desc="Numbers of threads which should be used by processor")
    private int threadsNo = this.concurrentQueuesNo();

    protected XMPPProcessor() {
        cmpInfo = new ComponentInfo(this.id(), this.getClass());
    }

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        Authorization result = null;
        String[][] elemPaths = this.supElementNamePaths();
        if (elemPaths != null) {
            String[] elemXMLNS = this.supNamespaces();
            Set<StanzaType> types = this.supTypes();
            result = this.checkPacket(packet, elemPaths, elemXMLNS, types);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} ({1}), authorization/canHandle: {4}, Request: {2}, conn: {3}", new Object[]{this.getClass().getSimpleName(), this.id(), packet, conn, result});
        }
        return result;
    }

    @Override
    public final int compareTo(XMPPImplIfc proc) {
        return this.getClass().getName().compareTo(proc.getClass().getName());
    }

    @Override
    public int concurrentQueuesNo() {
        return 1;
    }

    @Override
    @Deprecated
    public void init(Map<String, Object> settings) throws TigaseDBException {
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return null;
    }

    @Override
    public String[][] supElementNamePaths() {
        return null;
    }

    @Override
    public String[] supNamespaces() {
        return null;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return null;
    }

    @Override
    public Set<StanzaType> supTypes() {
        return null;
    }

    public XMPPProcessor getInstance() {
        return this;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    public ComponentInfo getComponentInfo() {
        if (cmpInfo == null) {
            cmpInfo = new ComponentInfo(this.id(), this.getClass());
        }
        return cmpInfo;
    }

    public String toString() {
        return String.valueOf(this.getComponentInfo());
    }

    @Override
    public int getThreadsNo() {
        return this.threadsNo;
    }

    @Override
    public Integer getQueueSize() {
        return this.queueSize;
    }

    private Authorization checkPacket(Packet packet, String[][] elemPaths, String[] elemXMLNS, Set<StanzaType> types) {
        boolean names_ok;
        Authorization result = null;
        boolean bl = names_ok = elemPaths == ALL_PATHS;
        if (!names_ok) {
            for (int i = 0; i < elemPaths.length; ++i) {
                if (!packet.isXMLNSStaticStr(elemPaths[i], elemXMLNS[i])) continue;
                names_ok = true;
                break;
            }
        }
        if (names_ok && (types == null || types.contains((Object)packet.getType()))) {
            result = Authorization.AUTHORIZED;
        }
        return result;
    }
}

