/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.annotations.TigaseDeprecated;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.StringUtilities;
import tigase.util.repository.DataTypes;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.VHostItemExtension;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionIfc;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.JID;

public class VHostItemImpl
extends RepositoryItemAbstract
implements VHostItem {
    public static final String ANONYMOUS_ENABLED_ATT = "anon";
    public static final String ANONYMOUS_ENABLED_LABEL = "Anonymous enabled";
    public static final String SASL_MECHANISM_ATT = "sasl-mechanisms";
    public static final String SASL_MECHANISM_LABEL = "Allowed SASL mechanisms";
    public static final String COMPONENTS_ATT = "comps";
    public static final String COMPONENTS_ELEM = "comps";
    public static final String C2S_PORTS_ALLOWED_ATT = "c2s-ports-allowed";
    public static final String C2S_PORTS_ALLOWED_LABEL = "Allowed C2S,BOSH,WebSocket ports";
    public static final String DOMAIN_FILTER_POLICY_ATT = "domain-filter";
    public static final String DOMAIN_FILTER_POLICY_DOMAINS_ATT = "domain-filter-domains";
    public static final String DOMAIN_FILTER_POLICY_LABEL = "Domain filter policy";
    public static final String DOMAIN_FILTER_POLICY_DOMAINS_LABEL = "Domain filter domains (only LIST and BLACKLIST)";
    public static final String ENABLED_ATT = "enabled";
    public static final String ENABLED_LABEL = "Enabled";
    public static final String HOSTNAME_ATT = "hostname";
    public static final String HOSTNAME_LABEL = "Domain name";
    public static final String MAX_USERS_NUMBER_ATT = "max-users";
    public static final String MAX_USERS_NUMBER_LABEL = "Max users";
    public static final String MESSAGE_FORWARD_ADDRESS_ATT = "mess-forw";
    public static final String MESSAGE_FORWARD_ADDRESS_LABEL = "Message forward address";
    public static final String OTHER_PARAMS_ELEM = "other";
    public static final String OTHER_PARAMS_LABEL = "Other parameters";
    public static final String PRESENCE_FORWARD_ADDRESS_ATT = "pres-forw";
    public static final String PRESENCE_FORWARD_ADDRESS_LABEL = "Presence forward address";
    public static final String REGISTER_ENABLED_ATT = "register";
    public static final String REGISTER_ENABLED_LABEL = "In-band registration";
    public static final String S2S_SECRET_ATT = "s2s-secret";
    public static final String S2S_SECRET_LABEL = "S2S secret";
    public static final String TLS_REQUIRED_ATT = "tls-required";
    public static final String TLS_REQUIRED_LABEL = "TLS required";
    private static final String TRUSTED_JIDS_ATT = "trusted-jids";
    public static final String TRUSTED_JIDS_LABEL = "Trusted JIDs";
    public static final String VHOST_ELEM = "vhost";
    protected static final String DOMAIN_FILTER_POLICY_PROP_KEY = "domain-filter-policy";
    protected static final String S2S_SECRET_PROP_DEF = null;
    protected static final String S2S_SECRET_PROP_KEY = "s2s-secret";
    protected static final String VHOST_ANONYMOUS_ENABLED_PROP_KEY = "vhost-anonymous-enabled";
    protected static final Boolean VHOST_ANONYMOUS_ENABLED_PROP_DEF = Boolean.FALSE;
    protected static final String VHOST_MAX_USERS_PROP_KEY = "vhost-max-users";
    protected static final Long VHOST_MAX_USERS_PROP_DEF = 0L;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_KEY = "vhost-message-forward-jid";
    protected static final String VHOST_PRESENCE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_PRESENCE_FORWARD_PROP_KEY = "vhost-presence-forward-jid";
    protected static final String VHOST_REGISTER_ENABLED_PROP_KEY = "vhost-register-enabled";
    protected static final Boolean VHOST_REGISTER_ENABLED_PROP_DEF = Boolean.TRUE;
    protected static final String VHOST_TLS_REQUIRED_PROP_KEY = "vhost-tls-required";
    protected static final Boolean VHOST_TLS_REQUIRED_PROP_DEF = Boolean.TRUE;
    protected static final DomainFilterPolicy DOMAIN_FILTER_POLICY_PROP_DEF = DomainFilterPolicy.ALL;
    protected static final String[] VHOST_OTHER_PARAMS_PATH = new String[]{"vhost", "other"};
    protected static final String[] VHOST_COMPONENTS_PATH = new String[]{"vhost", "comps"};
    protected static final Map<String, DataType> dataTypes = Collections.synchronizedMap(new LinkedHashMap());
    private static final Logger log = Logger.getLogger(VHostItemImpl.class.getName());
    private boolean anonymousEnabled = VHOST_ANONYMOUS_ENABLED_PROP_DEF;
    private int[] c2sPortsAllowed = null;
    private String[] comps = new String[0];
    private Map<String, Element> unknownExtensions = new ConcurrentHashMap<String, Element>();
    private Map<Class<? extends VHostItemExtension>, VHostItemExtension> extensions = new ConcurrentHashMap<Class<? extends VHostItemExtension>, VHostItemExtension>();
    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    private Map<String, Object> oldData = new ConcurrentHashMap<String, Object>();
    private DomainFilterPolicy domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
    private String[] domainFilterDomains = null;
    private boolean enabled = true;
    private Long maxUsersNumber = VHOST_MAX_USERS_PROP_DEF;
    private JID messageForward = JID.jidInstanceNS((String)VHOST_MESSAGE_FORWARD_PROP_DEF);
    private String otherDomainParams = null;
    private JID presenceForward = JID.jidInstanceNS((String)VHOST_PRESENCE_FORWARD_PROP_DEF);
    private boolean registerEnabled = VHOST_REGISTER_ENABLED_PROP_DEF;
    private String s2sSecret = S2S_SECRET_PROP_DEF;
    private String[] saslAllowedMechanisms = null;
    private boolean tlsRequired = VHOST_TLS_REQUIRED_PROP_DEF;
    private Set<String> trustedJids = Collections.emptySet();
    private JID vhost = null;
    private VHostItemExtensionManager extensionManager;
    private static final Set<String> bannedExtensionIds = new HashSet<String>(Arrays.asList("comps", "other", "trusted-jids", "data"));

    static DomainFilterPolicy getPolicyFromConfString(String configuration) {
        String[] df = configuration.split("=");
        try {
            if (df.length >= 2) {
                return DomainFilterPolicy.valueof(df[1]);
            }
            return DomainFilterPolicy.ALL;
        }
        catch (Exception e) {
            return DomainFilterPolicy.ALL;
        }
    }

    static String[] getDomainsFromConfString(String configuration) {
        String[] df = configuration.split("=");
        try {
            if (df.length >= 3 && df[2] != null && !df[2].trim().isEmpty()) {
                return StringUtilities.stringToArrayOfString((String)df[2], (String)";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    public static void registerData(List<DataType> types) {
        for (DataType type : types) {
            dataTypes.put(type.getKey(), type);
        }
    }

    public VHostItemImpl() {
        if (this.s2sSecret == null) {
            this.s2sSecret = UUID.randomUUID().toString();
        }
    }

    public VHostItemImpl(Element elem) {
        this();
        this.initFromElement(elem);
    }

    public VHostItemImpl(JID vhost) {
        this();
        this.setVHost(vhost);
    }

    public VHostItemImpl(String vhost) throws TigaseStringprepException {
        this();
        this.setVHost(vhost);
    }

    protected void setExtensionManager(VHostItemExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void addCommandFields(Packet packet) {
        if (!this.isDefault()) {
            Command.addInstructions(packet, "\u2757NOTE: Options without value set will use configuration defined in 'DEFAULT' VHost\u2757");
        } else {
            Command.addInstructions(packet, "\u2757This VHost is intended to configure certain default values for all VHosts in the system and it's not actual, available domain to which you can connect\u2757");
        }
        Command.addFieldValue(packet, HOSTNAME_LABEL, this.vhost != null ? this.vhost.getDomain() : "");
        if (!this.isDefault()) {
            Command.addCheckBoxField(packet, ENABLED_LABEL, this.enabled);
        }
        Command.addCheckBoxField(packet, ANONYMOUS_ENABLED_LABEL, this.anonymousEnabled);
        Command.addCheckBoxField(packet, REGISTER_ENABLED_LABEL, this.registerEnabled);
        Command.addCheckBoxField(packet, TLS_REQUIRED_LABEL, this.tlsRequired);
        if (!this.isDefault()) {
            Command.addFieldValue(packet, S2S_SECRET_LABEL, this.s2sSecret != null ? this.s2sSecret : "");
        }
        if (this.isDefault()) {
            Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL, this.domainFilter.toString(), DOMAIN_FILTER_POLICY_LABEL, DomainFilterPolicy.valuesStr(), DomainFilterPolicy.valuesStr());
        } else {
            String[] values = (String[])Stream.concat(Stream.of("DEFAULT"), Arrays.stream(DomainFilterPolicy.valuesStr())).toArray(String[]::new);
            Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL, this.domainFilter != null ? this.domainFilter.toString() : "", DOMAIN_FILTER_POLICY_LABEL, values, values);
        }
        Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_DOMAINS_LABEL, this.domainFilterDomains != null ? StringUtilities.stringArrayToString((String[])this.domainFilterDomains, (String)";") : "");
        Command.addFieldValue(packet, MAX_USERS_NUMBER_LABEL, Optional.ofNullable(this.maxUsersNumber).map(String::valueOf).orElse(""));
        String c2sPortsAllowedStr = this.intArrayToString(this.c2sPortsAllowed, ",");
        Command.addFieldValue(packet, C2S_PORTS_ALLOWED_LABEL, c2sPortsAllowedStr != null ? c2sPortsAllowedStr : "");
        Command.addFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL, this.presenceForward != null ? this.presenceForward.toString() : "");
        Command.addFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL, this.messageForward != null ? this.messageForward.toString() : "");
        Command.addFieldValue(packet, OTHER_PARAMS_LABEL, this.otherDomainParams != null ? this.otherDomainParams : "");
        Command.addFieldValue(packet, SASL_MECHANISM_LABEL, this.saslAllowedMechanisms != null ? StringUtilities.stringArrayToString((String[])this.saslAllowedMechanisms, (String)",") : "");
        Command.addFieldMultiValue(packet, TRUSTED_JIDS_LABEL, this.trustedJids != null ? new ArrayList<String>(this.trustedJids) : Collections.EMPTY_LIST);
        super.addCommandFields(packet);
        this.extensionManager.addMissingExtensions(this.extensions.values().stream().map(v -> v).collect(Collectors.toSet())).sorted(Comparator.comparing(VHostItemExtensionIfc::getId)).forEach(ext -> ext.addCommandFields(ext.getId(), packet, this.isDefault()));
        for (DataType type : dataTypes.values()) {
            if (type.cls != Boolean.class) {
                String valueStr;
                T[] options = type.getOptions();
                Object val = this.getData(type.getKey());
                if (val instanceof Collection) {
                    Collection collection = (Collection)val;
                    val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                    int i = 0;
                    for (Object v2 : collection) {
                        Array.set(val, i, v2);
                        ++i;
                    }
                }
                String string = valueStr = val != null ? DataTypes.valueToString(val) : "";
                if (options == null || options.length == 0) {
                    Command.addFieldValue(packet, type.getName(), valueStr);
                    continue;
                }
                String[] optionsStr = new String[options.length];
                for (int i = 0; i < options.length; ++i) {
                    optionsStr[i] = options[i] != null ? DataTypes.valueToString(options[i]) : "";
                }
                String[] optionsNames = type.getOptionsNames();
                if (optionsNames == null) {
                    optionsNames = optionsStr;
                }
                Command.addFieldValue(packet, type.getName(), valueStr, type.getName(), optionsNames, optionsStr);
                continue;
            }
            boolean val = this.isData(type.getKey());
            Command.addCheckBoxField(packet, type.getName(), val);
        }
    }

    public boolean equals(Object v) {
        return v instanceof VHostItem ? this.getKey().equals(((VHostItem)v).getKey()) : false;
    }

    public int hashCode() {
        return this.vhost.hashCode();
    }

    @Override
    public void initFromCommand(Packet packet) {
        String[] tmps;
        super.initFromCommand(packet);
        String tmp = Command.getFieldValue(packet, HOSTNAME_LABEL);
        try {
            this.setVHost(tmp);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Incorrect domain, unable to parse it: " + tmp, ex);
        }
        this.enabled = Command.getCheckBoxFieldValue(packet, ENABLED_LABEL);
        this.anonymousEnabled = Command.getCheckBoxFieldValue(packet, ANONYMOUS_ENABLED_LABEL);
        this.registerEnabled = Command.getCheckBoxFieldValue(packet, REGISTER_ENABLED_LABEL);
        Optional.ofNullable(Command.getFieldValue(packet, TLS_REQUIRED_LABEL)).ifPresent(s -> {
            this.tlsRequired = Boolean.parseBoolean(s);
        });
        tmp = Command.getFieldValue(packet, S2S_SECRET_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.s2sSecret = tmp;
        }
        tmp = Command.getFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL);
        try {
            this.domainFilter = DomainFilterPolicy.valueof(tmp);
            if (this.domainFilter == null && this.isDefault()) {
                this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
            }
            this.domainFilterDomains = this.domainFilter != null && this.domainFilter.isDomainListRequired() ? (String[])Optional.ofNullable(Command.getFieldValue(packet, DOMAIN_FILTER_POLICY_DOMAINS_LABEL)).map(String::trim).filter(s -> !s.isEmpty()).map(s -> StringUtilities.stringToArrayOfString((String)s, (String)";")).orElse(null) : null;
        }
        catch (Exception ex) {
            this.domainFilter = this.isDefault() ? DOMAIN_FILTER_POLICY_PROP_DEF : null;
            this.domainFilterDomains = null;
        }
        try {
            this.maxUsersNumber = Optional.ofNullable(Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL)).map(String::trim).filter(s -> !s.isEmpty()).map(Long::parseLong).orElse(this.isDefault() ? VHOST_MAX_USERS_PROP_DEF : null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        tmp = Command.getFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            try {
                this.presenceForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceForward = null;
                throw new IllegalArgumentException("Incorrect presence forward address: " + tmp, ex);
            }
        }
        if ((tmp = Command.getFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL)) != null && !tmp.trim().isEmpty()) {
            try {
                this.messageForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                throw new IllegalArgumentException("Incorrect message forward address: " + tmp, ex);
            }
        }
        this.otherDomainParams = Optional.ofNullable(Command.getFieldValue(packet, OTHER_PARAMS_LABEL)).filter(s -> !s.isEmpty()).orElse(null);
        tmp = Command.getFieldValue(packet, C2S_PORTS_ALLOWED_LABEL);
        this.c2sPortsAllowed = this.parseIntArray(tmp, ",");
        tmp = Command.getFieldValue(packet, SASL_MECHANISM_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            String[] split = tmp.split(",");
            for (String mechanism : split) {
                mechanism.trim();
            }
            this.setSaslAllowedMechanisms(split);
        }
        this.trustedJids = (tmps = Command.getFieldValues(packet, TRUSTED_JIDS_LABEL)) != null ? Arrays.stream(tmps).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()) : Collections.emptySet();
        this.extensionManager.newExtensionInstances().map(extension -> {
            extension.initFromCommand(extension.getId(), packet);
            return extension;
        }).forEach(extension -> this.extensions.put((Class<? extends VHostItemExtension>)extension.getClass(), (VHostItemExtension)extension));
        for (DataType type : dataTypes.values()) {
            Object value;
            String valueStr = Command.getFieldValue(packet, type.getName());
            Character typeId = DataTypes.typesMap.get(type.cls.getName());
            Object object = value = valueStr == null || valueStr.isEmpty() ? null : DataTypes.decodeValueType(typeId.charValue(), valueStr);
            if (value != null && type.getCollectionCls() != null) {
                try {
                    Collection collection = type.getCollectionCls().newInstance();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        collection.add(Array.get(value, i));
                    }
                    value = collection;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                }
            }
            this.setData(type.getKey(), value);
        }
        log.log(Level.FINE, "Initialized from command: {0}", this);
    }

    @Override
    public void initFromElement(Element elem) {
        List items;
        Element data;
        String comps_str;
        String tmp;
        if (elem.getName() != VHOST_ELEM) {
            throw new IllegalArgumentException("Incorrect element name, expected: vhost");
        }
        super.initFromElement(elem);
        this.setVHost(JID.jidInstanceNS((String)elem.getAttributeStaticStr(HOSTNAME_ATT)));
        this.enabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ENABLED_ATT));
        this.anonymousEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ANONYMOUS_ENABLED_ATT));
        this.registerEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(REGISTER_ENABLED_ATT));
        this.tlsRequired = Boolean.parseBoolean(elem.getAttributeStaticStr(TLS_REQUIRED_ATT));
        this.s2sSecret = elem.getAttributeStaticStr("s2s-secret");
        try {
            this.domainFilter = DomainFilterPolicy.valueof(elem.getAttributeStaticStr(DOMAIN_FILTER_POLICY_ATT));
            if (this.domainFilter == null && this.isDefault()) {
                this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
            }
            if (this.domainFilter != null && this.domainFilter.isDomainListRequired() && (tmp = elem.getAttributeStaticStr(DOMAIN_FILTER_POLICY_DOMAINS_ATT)) != null && !tmp.trim().isEmpty()) {
                this.domainFilterDomains = StringUtilities.stringToArrayOfString((String)tmp, (String)";");
            }
        }
        catch (Exception e) {
            this.domainFilter = this.isDefault() ? DOMAIN_FILTER_POLICY_PROP_DEF : null;
        }
        try {
            this.maxUsersNumber = Optional.ofNullable(elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT)).map(String::trim).filter(s -> !s.isEmpty()).map(Long::parseLong).orElse(this.isDefault() ? Long.getLong(VHOST_MAX_USERS_PROP_KEY, VHOST_MAX_USERS_PROP_DEF) : null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT));
            this.maxUsersNumber = this.isDefault() ? Long.getLong(VHOST_MAX_USERS_PROP_KEY, VHOST_MAX_USERS_PROP_DEF) : null;
        }
        tmp = elem.getAttributeStaticStr(PRESENCE_FORWARD_ADDRESS_ATT);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.presenceForward = JID.jidInstanceNS((String)tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(MESSAGE_FORWARD_ADDRESS_ATT)) != null && !tmp.trim().isEmpty()) {
            this.messageForward = JID.jidInstanceNS((String)tmp);
        }
        if ((comps_str = elem.getCDataStaticStr(VHOST_COMPONENTS_PATH)) != null && !comps_str.isEmpty()) {
            this.comps = comps_str.split(",");
        }
        this.otherDomainParams = Optional.ofNullable(elem.getCDataStaticStr(VHOST_OTHER_PARAMS_PATH)).map(String::trim).filter(s -> !s.isEmpty()).orElse(this.isDefault() ? "" : null);
        this.c2sPortsAllowed = this.parseIntArray(elem.getAttributeStaticStr(C2S_PORTS_ALLOWED_ATT), ",");
        tmp = elem.getAttributeStaticStr(SASL_MECHANISM_ATT);
        if (tmp != null) {
            this.setSaslAllowedMechanisms(tmp.split(";"));
        }
        if ((data = elem.getChild("data")) != null && (items = data.getChildren()) != null) {
            for (Element item : items) {
                DataType type = dataTypes.get(item.getName());
                Character typeChar = Character.valueOf(type != null ? DataTypes.typesMap.get(type.getCls().getName()).charValue() : item.getAttributeStaticStr("type").charAt(0));
                Object value = DataTypes.decodeValueType(typeChar.charValue(), item.getCData());
                if (type != null && type.getCollectionCls() != null && value != null) {
                    try {
                        Collection collection = type.getCollectionCls().newInstance();
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            collection.add(Array.get(value, i));
                        }
                        value = collection;
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                    }
                }
                this.setData(item.getName(), value);
            }
        }
        if ((tmp = elem.getCDataStaticStr(new String[]{VHOST_ELEM, TRUSTED_JIDS_ATT})) == null) {
            tmp = (String)this.oldData.remove(TRUSTED_JIDS_ATT);
        }
        this.trustedJids = tmp != null && !tmp.isEmpty() ? Collections.unmodifiableSet(Arrays.stream(tmp.split(",")).map(String::trim).collect(Collectors.toSet())) : Collections.emptySet();
        List children = elem.getChildren();
        if (children != null) {
            this.unknownExtensions.putAll(children.stream().filter(child -> !bannedExtensionIds.contains(child.getName())).collect(Collectors.toConcurrentMap(Element::getName, Function.identity())));
        }
        this.extensionManager.newExtensionInstances().map(this::initExtension).forEach(extension -> this.extensions.put((Class<? extends VHostItemExtension>)extension.getClass(), (VHostItemExtension)extension));
        log.log(Level.FINE, "Initialized from element: {0}", this);
    }

    protected VHostItemExtension initExtension(VHostItemExtension extension) {
        String id = extension.getId();
        Element extElem = this.unknownExtensions.remove(id);
        if (extElem != null) {
            try {
                extension.initFromElement(extElem);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not initialize " + extension.getClass().getCanonicalName() + " with data " + String.valueOf(extElem));
            }
        }
        if (extension instanceof VHostItemExtensionBackwardCompatible) {
            try {
                ((VHostItemExtensionBackwardCompatible)((Object)extension)).initFromData(this.oldData);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not initialize " + extension.getClass().getCanonicalName() + " with oldData " + String.valueOf(this.oldData), ex);
            }
        }
        return extension;
    }

    @Override
    public void setKey(String key) {
        this.setVHost(JID.jidInstanceNS((String)key));
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        try {
            this.setVHost(props[0]);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Domain misconfiguration, cannot parse it: " + props[0], ex);
        }
        for (String tmp : props) {
            String[] mu;
            String[] c;
            String comps_str;
            boolean val = true;
            if (tmp.startsWith("-")) {
                val = false;
            }
            if (tmp.endsWith(ANONYMOUS_ENABLED_ATT)) {
                this.anonymousEnabled = val;
            }
            if (tmp.endsWith(REGISTER_ENABLED_ATT)) {
                this.registerEnabled = val;
            }
            if (tmp.endsWith(TLS_REQUIRED_ATT)) {
                this.tlsRequired = val;
            }
            if (tmp.startsWith("s2s-secret")) {
                String[] s2 = tmp.split("=");
                this.s2sSecret = s2[1];
            }
            if (tmp.startsWith("comps") && !(comps_str = (c = tmp.split("="))[1]).isEmpty()) {
                this.comps = comps_str.split(";");
            }
            if (tmp.startsWith(DOMAIN_FILTER_POLICY_ATT)) {
                this.domainFilter = VHostItemImpl.getPolicyFromConfString(tmp);
                if (this.domainFilter == null && this.isDefault()) {
                    this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
                }
                if (this.domainFilter.isDomainListRequired()) {
                    this.domainFilterDomains = VHostItemImpl.getDomainsFromConfString(tmp);
                }
            }
            if (tmp.startsWith(MAX_USERS_NUMBER_ATT)) {
                mu = tmp.split("=");
                try {
                    this.maxUsersNumber = Long.parseLong(mu[1]);
                }
                catch (NumberFormatException ex) {
                    this.maxUsersNumber = 0L;
                    log.log(Level.WARNING, "Incorrect max users number for vhost settings, number parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(PRESENCE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.presenceForward = JID.jidInstance((String)mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.presenceForward = null;
                    log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(MESSAGE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.messageForward = JID.jidInstance((String)mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.messageForward = null;
                    log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(C2S_PORTS_ALLOWED_ATT)) {
                mu = tmp.split("=");
                this.c2sPortsAllowed = this.parseIntArray(mu[1], ";");
            }
            if (tmp.startsWith(SASL_MECHANISM_ATT)) {
                mu = tmp.split("=");
                this.setSaslAllowedMechanisms(mu[1].split(";"));
            }
            if ((mu = tmp.split("=")) == null || mu.length != 2) continue;
            if (dataTypes.containsKey(mu[0])) {
                this.parseDataValue(mu[0], mu[1]);
                continue;
            }
            if (!mu[0].equals(TRUSTED_JIDS_ATT)) continue;
            this.trustedJids = mu[1].contains(",") ? Collections.unmodifiableSet(Arrays.stream(mu[1].split(",")).map(String::trim).collect(Collectors.toSet())) : Collections.unmodifiableSet(Arrays.stream(mu[1].split(";")).map(String::trim).collect(Collectors.toSet()));
        }
        if (this.trustedJids == null) {
            this.trustedJids = Collections.EMPTY_SET;
        }
        if (this.extensionManager != null) {
            this.extensionManager.newExtensionInstances().map(this::initExtension).forEach(extension -> this.extensions.put((Class<? extends VHostItemExtension>)extension.getClass(), (VHostItemExtension)extension));
        }
        log.log(Level.FINE, "Initialized from property string: {0}", this);
    }

    @Override
    public Element toElement() {
        String other_params;
        Element elem = super.toElement();
        Object comps_str = "";
        if (this.comps != null && this.comps.length > 0) {
            for (String comp : this.comps) {
                if (!((String)comps_str).isEmpty()) {
                    comps_str = (String)comps_str + ",";
                }
                comps_str = (String)comps_str + comp;
            }
        }
        String string = other_params = this.otherDomainParams != null ? this.otherDomainParams : "";
        if (comps_str != null && !((String)comps_str).isEmpty()) {
            elem.addChild((XMLNodeIfc)new Element("comps", (String)comps_str));
        }
        if (other_params != null && !other_params.isEmpty()) {
            elem.addChild((XMLNodeIfc)new Element(OTHER_PARAMS_ELEM, other_params));
        }
        elem.addAttribute(HOSTNAME_ATT, this.vhost.getDomain());
        elem.addAttribute(ENABLED_ATT, "" + this.enabled);
        elem.addAttribute(ANONYMOUS_ENABLED_ATT, "" + this.anonymousEnabled);
        if (this.saslAllowedMechanisms != null) {
            elem.addAttribute(SASL_MECHANISM_ATT, StringUtilities.stringArrayToString((String[])this.saslAllowedMechanisms, (String)";"));
        }
        elem.addAttribute(REGISTER_ENABLED_ATT, "" + this.registerEnabled);
        elem.addAttribute(TLS_REQUIRED_ATT, "" + this.tlsRequired);
        if (this.s2sSecret != null) {
            elem.addAttribute("s2s-secret", this.s2sSecret);
        }
        if (this.domainFilter != null) {
            elem.addAttribute(DOMAIN_FILTER_POLICY_ATT, this.domainFilter.toString());
        }
        if (this.domainFilterDomains != null) {
            elem.addAttribute(DOMAIN_FILTER_POLICY_DOMAINS_ATT, StringUtilities.stringArrayToString((String[])this.domainFilterDomains, (String)";"));
        }
        if (this.maxUsersNumber != null) {
            elem.addAttribute(MAX_USERS_NUMBER_ATT, "" + this.maxUsersNumber);
        }
        if (this.presenceForward != null) {
            elem.addAttribute(PRESENCE_FORWARD_ADDRESS_ATT, this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            elem.addAttribute(MESSAGE_FORWARD_ADDRESS_ATT, this.messageForward.toString());
        }
        if (this.c2sPortsAllowed != null) {
            String c2sPortsAllowedStr = this.intArrayToString(this.c2sPortsAllowed, ",");
            elem.addAttribute(C2S_PORTS_ALLOWED_ATT, c2sPortsAllowedStr);
        }
        if (this.trustedJids != null && !this.trustedJids.isEmpty()) {
            elem.addChild((XMLNodeIfc)new Element(TRUSTED_JIDS_ATT, StringUtilities.stringArrayToString((String[])this.trustedJids.toArray(new String[0]), (String)",")));
        }
        this.extensions.entrySet().stream().sorted(Comparator.comparing(e -> ((Class)e.getKey()).getSimpleName())).map(Map.Entry::getValue).map(VHostItemExtensionIfc::toElement).filter(Objects::nonNull).forEach(arg_0 -> ((Element)elem).addChild(arg_0));
        this.unknownExtensions.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> elem.addChild((XMLNodeIfc)((Element)e.getValue())));
        if (!this.oldData.isEmpty()) {
            Element data = new Element("data");
            for (Map.Entry<String, Object> e2 : this.oldData.entrySet()) {
                Element item = new Element(e2.getKey());
                item.addAttribute("type", String.valueOf(DataTypes.getTypeId(e2.getValue())));
                Object val = e2.getValue();
                DataType type = dataTypes.get(e2.getKey());
                if (type != null && val instanceof Collection && type.getCollectionCls() != null) {
                    Collection collection = (Collection)val;
                    val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                    int i = 0;
                    for (Object v : collection) {
                        Array.set(val, i, v);
                        ++i;
                    }
                }
                item.setCData(DataTypes.valueToString(val));
                data.addChild((XMLNodeIfc)item);
            }
            elem.addChild((XMLNodeIfc)data);
        }
        return elem;
    }

    @Override
    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vhost.toString());
        if (!this.anonymousEnabled) {
            sb.append(":-").append(ANONYMOUS_ENABLED_ATT);
        }
        if (!this.registerEnabled) {
            sb.append(":-").append(REGISTER_ENABLED_ATT);
        }
        if (!this.tlsRequired) {
            sb.append(":-").append(TLS_REQUIRED_ATT);
        }
        if (this.s2sSecret != null) {
            sb.append(':').append("s2s-secret").append('=').append(this.s2sSecret);
        }
        sb.append(':').append(DOMAIN_FILTER_POLICY_ATT).append('=').append(this.domainFilter.toString());
        if (this.domainFilterDomains != null) {
            sb.append("=").append(StringUtilities.stringArrayToString((String[])this.domainFilterDomains, (String)";"));
        }
        if (this.maxUsersNumber != null && this.maxUsersNumber > 0L) {
            sb.append(':').append(MAX_USERS_NUMBER_ATT).append('=').append(this.maxUsersNumber);
        }
        if (this.presenceForward != null) {
            sb.append(':').append(PRESENCE_FORWARD_ADDRESS_ATT).append('=').append(this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            sb.append(':').append(MESSAGE_FORWARD_ADDRESS_ATT).append('=').append(this.messageForward.toString());
        }
        if (this.c2sPortsAllowed != null) {
            sb.append(':').append(C2S_PORTS_ALLOWED_ATT).append('=').append(this.intArrayToString(this.c2sPortsAllowed, ";"));
        }
        if (this.saslAllowedMechanisms != null) {
            sb.append(':').append(SASL_MECHANISM_ATT).append('=').append(StringUtilities.stringArrayToString((String[])this.saslAllowedMechanisms, (String)";"));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = VHostItemImpl.toString(this);
        for (Map.Entry<String, Object> e : this.oldData.entrySet()) {
            Object val = e.getValue();
            DataType type = dataTypes.get(e.getKey());
            if (type != null && val instanceof Collection && type.getCollectionCls() != null) {
                Collection collection = (Collection)val;
                val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                int i = 0;
                for (Object v : collection) {
                    Array.set(val, i, v);
                    ++i;
                }
            }
            sb.append(", ").append(e.getKey()).append(": ").append(DataTypes.valueToString(val));
        }
        return sb.toString();
    }

    protected static StringBuilder toString(VHostItem item) {
        StringBuilder sb = new StringBuilder();
        sb.append("Domain: ").append(item.getVhost());
        sb.append(", enabled: ").append(item.isEnabled());
        sb.append(", anonym: ").append(item.isAnonymousEnabled());
        sb.append(", register: ").append(item.isRegisterEnabled());
        sb.append(", tls: ").append(item.isTlsRequired());
        if (item.getMaxUsersNumber() != null) {
            sb.append(", maxusers: ").append(item.getMaxUsersNumber());
        }
        if (item.getS2sSecret() != null) {
            sb.append(", s2sSecret: ").append(item.getS2sSecret());
        }
        if (item.getDomainFilter() != null) {
            sb.append(", domainFilter: ").append((Object)item.getDomainFilter());
        }
        if (item.getDomainFilterDomains() != null && item.getDomainFilterDomains().length > 0) {
            sb.append(", domainFilterDomains: ").append(StringUtilities.stringArrayToString((String[])item.getDomainFilterDomains(), (String)";"));
        }
        if (item.getC2SPortsAllowed() != null && item.getC2SPortsAllowed().length > 0) {
            sb.append(", c2sPortsAllowed: ").append(Arrays.toString(item.getC2SPortsAllowed()));
        }
        if (item.getSaslAllowedMechanisms() != null && item.getSaslAllowedMechanisms().length > 0) {
            sb.append(", saslAllowedMechanisms: ").append(Arrays.toString(item.getSaslAllowedMechanisms()));
        }
        if (item.getTrustedJIDs() != null && !item.getTrustedJIDs().isEmpty()) {
            sb.append(", trustedJids: ").append(item.getTrustedJIDs());
        }
        if (item.getMessageForward() != null) {
            sb.append(", messageForward: ").append(item.getMessageForward());
        }
        if (item.getPresenceForward() != null) {
            sb.append(", presenceForward: ").append(item.getPresenceForward());
        }
        if (!item.getExtensions().isEmpty()) {
            sb.append(item.getExtensions().stream().map(VHostItemExtension::toString).collect(Collectors.joining(", ", "; Extensions: [", "]")));
        }
        return sb;
    }

    @Override
    public String[] getComps() {
        return this.comps;
    }

    public void setComps(String[] comps) {
        this.comps = comps;
    }

    @Override
    public int[] getC2SPortsAllowed() {
        return this.c2sPortsAllowed;
    }

    public void setC2SPortsAllowed(int[] ports) {
        this.c2sPortsAllowed = ports;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    public <T> T getData(String key) {
        DataType type;
        Object val = this.oldData.get(key);
        if (val == null && (type = dataTypes.get(key)) != null) {
            val = type.getDefValue();
        }
        return (T)val;
    }

    @Override
    public DomainFilterPolicy getDomainFilter() {
        return this.domainFilter;
    }

    public void setDomainFilter(DomainFilterPolicy domainFilter) {
        this.domainFilter = domainFilter;
    }

    @Override
    public String[] getDomainFilterDomains() {
        return this.domainFilterDomains;
    }

    public void setDomainFilterDomains(String[] domainFilterDomains) {
        this.domainFilterDomains = StringUtilities.internStringArray((String[])domainFilterDomains);
    }

    @Override
    public String getElemName() {
        return VHOST_ELEM;
    }

    @Override
    public <T extends VHostItemExtension> T getExtension(Class<T> clazz) {
        return (T)this.extensions.computeIfAbsent(clazz, key -> {
            if (this.extensionManager == null) {
                return null;
            }
            Object ext = this.extensionManager.newExtensionInstanceForClass(key);
            if (ext != null) {
                this.initExtension((VHostItemExtension)ext);
            }
            return ext;
        });
    }

    @Override
    public <T extends VHostItemExtension> Set<T> getExtensions() {
        Collection<VHostItemExtension> values = this.extensions.values();
        HashSet<VHostItemExtension> vHostItemExtensions = new HashSet<VHostItemExtension>(values);
        return Collections.unmodifiableSet(vHostItemExtensions);
    }

    @Override
    public Set<Class<? extends VHostItemExtension>> getExtensionClasses() {
        return new HashSet<Class<? extends VHostItemExtension>>(this.extensions.keySet());
    }

    @Override
    public String getKey() {
        return this.vhost == null ? null : this.vhost.getDomain();
    }

    @Override
    public Long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public void setMaxUsersNumber(long maxUsersNumber) {
        this.maxUsersNumber = maxUsersNumber;
    }

    @Override
    public JID getMessageForward() {
        return this.messageForward;
    }

    public void setMessageForward(JID messageForward) {
        this.messageForward = messageForward;
    }

    @Override
    public JID getMessageForwardAddress() {
        return this.messageForward;
    }

    @Override
    public String getOtherDomainParams() {
        return this.otherDomainParams;
    }

    public void setOtherDomainParams(String otherParams) {
        this.otherDomainParams = otherParams;
    }

    @Override
    public JID getPresenceForward() {
        return this.presenceForward;
    }

    public void setPresenceForward(JID presenceForward) {
        this.presenceForward = presenceForward;
    }

    @Override
    public JID getPresenceForwardAddress() {
        return this.presenceForward;
    }

    @Override
    public String getS2sSecret() {
        return this.s2sSecret;
    }

    public void setS2sSecret(String s2sSecret) {
        this.s2sSecret = s2sSecret;
    }

    @Override
    public Set<String> getTrustedJIDs() {
        return this.trustedJids;
    }

    @Override
    public JID getVhost() {
        return this.vhost;
    }

    @Override
    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public void setAnonymousEnabled(boolean value) {
        this.anonymousEnabled = value;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    public boolean isData(String key) {
        if (this.oldData.containsKey(key)) {
            return (Boolean)this.oldData.get(key);
        }
        DataType type = dataTypes.get(key);
        Boolean defValue = type == null ? null : (Boolean)type.getDefValue();
        return defValue != null ? defValue : false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean value) {
        this.registerEnabled = value;
    }

    @Override
    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean value) {
        this.tlsRequired = value;
    }

    public void setData(String key, Object value) {
        if (value == null) {
            this.oldData.remove(key);
        } else {
            this.oldData.put(key, value);
        }
    }

    public void parseDataValue(String key, String valueStr) {
        DataType type = dataTypes.get(key);
        if (type == null) {
            throw new RuntimeException("Key " + key + " is not registered");
        }
        if (valueStr == null) {
            this.oldData.remove(key);
        } else {
            Object value;
            char typeId = DataTypes.typesMap.get(type.cls.getName()).charValue();
            if (valueStr.contains(";")) {
                valueStr = valueStr.replace(';', ',');
            }
            Object object = value = valueStr == null || valueStr.isEmpty() ? null : DataTypes.decodeValueType(typeId, valueStr);
            if (type.getCollectionCls() != null && value != null) {
                try {
                    Collection collection = type.getCollectionCls().newInstance();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        collection.add(Array.get(value, i));
                    }
                    value = collection;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                }
            }
            this.setData(type.getKey(), value);
        }
    }

    public void setVHost(String vhost) throws TigaseStringprepException {
        if (vhost == null) {
            vhost = "";
        }
        this.vhost = JID.jidInstance((String)vhost);
    }

    public void setVHost(JID vhost) {
        this.vhost = vhost;
    }

    @Override
    public String[] getSaslAllowedMechanisms() {
        return this.saslAllowedMechanisms;
    }

    public void setSaslAllowedMechanisms(String[] saslAllowedMechanisms) {
        this.saslAllowedMechanisms = saslAllowedMechanisms == null || saslAllowedMechanisms.length == 0 ? null : saslAllowedMechanisms;
    }

    protected void initializeFromDefaults(VHostItemDefaults vhostDefaults) {
        if (this.comps == null) {
            this.comps = new String[0];
        }
        if (vhostDefaults.getTrusted() != null) {
            this.trustedJids = vhostDefaults.getTrusted();
        } else if (this.trustedJids == null) {
            this.trustedJids = Collections.EMPTY_SET;
        }
        this.maxUsersNumber = vhostDefaults.getMaxUsersNumber();
        this.messageForward = vhostDefaults.getMessageForward();
        this.presenceForward = vhostDefaults.getPresenceForward();
        this.tlsRequired = vhostDefaults.isTlsRequired();
        this.s2sSecret = vhostDefaults.getS2sSecret();
        this.registerEnabled = vhostDefaults.isRegisterEnabled();
        this.domainFilter = vhostDefaults.getDomainFilter();
        this.domainFilterDomains = vhostDefaults.getDomainFilterDomains();
        this.anonymousEnabled = vhostDefaults.isAnonymousEnabled();
        if (this.s2sSecret == null) {
            this.s2sSecret = UUID.randomUUID().toString();
        }
    }

    private int[] parseIntArray(String tmp, String separator) {
        int[] c2s_ports_allowed = null;
        if (tmp != null && !tmp.isEmpty()) {
            String[] tmpPorts = tmp.split(separator);
            c2s_ports_allowed = new int[tmpPorts.length];
            int filled = 0;
            for (String portStr : tmpPorts) {
                try {
                    c2s_ports_allowed[filled] = Integer.parseInt(portStr);
                    ++filled;
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Can not parse allowed c2s port: {0}", portStr);
                }
            }
            if (filled == 0) {
                c2s_ports_allowed = null;
            } else if (filled < c2s_ports_allowed.length) {
                c2s_ports_allowed = Arrays.copyOf(c2s_ports_allowed, filled);
            }
            if (c2s_ports_allowed != null) {
                Arrays.sort(c2s_ports_allowed);
            }
        }
        return c2s_ports_allowed;
    }

    private String intArrayToString(int[] arr, String separator) {
        if (arr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static class DataType {
        private final Class cls;
        private final Class collectionCls;
        private final Object defValue;
        private final String key;
        private final String name;
        private final Object[] options;
        private final String[] optionsNames;

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue, Object[] options, String[] optionsNames) {
            this.key = key;
            this.name = name;
            this.cls = cls;
            this.collectionCls = collectionCls;
            this.defValue = defValue;
            this.options = options;
            this.optionsNames = optionsNames;
            if (defValue != null && !cls.isAssignableFrom(defValue.getClass())) {
                throw new IllegalArgumentException("default value parameter must be of class " + cls.getCanonicalName());
            }
            if (options != null) {
                for (Object option : options) {
                    if (option == null || cls.isAssignableFrom(option.getClass())) continue;
                    throw new IllegalArgumentException("option values must of class " + cls.getCanonicalName());
                }
                if (optionsNames != null && options.length != optionsNames.length) {
                    throw new IllegalArgumentException("if passed options name must be specified for each option");
                }
            }
        }

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue, Object[] options) {
            this(key, name, cls, collectionCls, defValue, options, null);
        }

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue) {
            this(key, name, cls, collectionCls, defValue, null, null);
        }

        public DataType(String key, String name, Class cls, Object defValue, Object[] options) {
            this(key, name, cls, null, defValue, options, null);
        }

        public DataType(String key, String name, Class cls, Object defValue) {
            this(key, name, cls, null, defValue, null, null);
        }

        public <E extends Enum<E>> DataType(String key, String name, Class<? extends Enum<E>> e, E defValue) {
            String[] options = new String[defValue != null ? e.getEnumConstants().length : e.getEnumConstants().length + 1];
            int idx = 0;
            if (defValue == null) {
                options[idx++] = null;
            }
            for (Enum<E> en : e.getEnumConstants()) {
                options[idx++] = en.name();
            }
            this.key = key;
            this.name = name;
            this.cls = String.class;
            this.collectionCls = null;
            this.defValue = defValue != null ? defValue.name() : null;
            this.options = options;
            this.optionsNames = null;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public Class getCls() {
            return this.cls;
        }

        public Class<? extends Collection> getCollectionCls() {
            return this.collectionCls;
        }

        public <T> T getDefValue() {
            return (T)this.defValue;
        }

        public <T> T[] getOptions() {
            return this.options;
        }

        public String[] getOptionsNames() {
            return this.optionsNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key).append(':');
            sb.append(this.name).append(" @ ");
            sb.append(this.cls);
            return sb.toString();
        }
    }

    protected static class VHostItemWrapper
    implements VHostItem {
        private VHostItem defaultVHost;
        private VHostItem item;
        private VHostItemDefaults vhostDefaults;
        private boolean anonymousEnabled = false;
        private int[] c2sPortsAllowed = null;
        private String[] comps;
        private DomainFilterPolicy domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
        private String[] domainFilterDomains = null;
        private Long maxUsersNumber = VHOST_MAX_USERS_PROP_DEF;
        private JID messageForward = JID.jidInstanceNS((String)VHOST_MESSAGE_FORWARD_PROP_DEF);
        private String otherDomainParams = null;
        private JID presenceForward = JID.jidInstanceNS((String)VHOST_PRESENCE_FORWARD_PROP_DEF);
        private boolean registerEnabled = VHOST_REGISTER_ENABLED_PROP_DEF;
        private String s2sSecret = S2S_SECRET_PROP_DEF;
        private String[] saslAllowedMechanisms = null;
        private boolean tlsRequired = VHOST_TLS_REQUIRED_PROP_DEF;
        private Set<String> trustedJids = null;
        private Map<Class<? extends VHostItemExtension>, VHostItemExtension> extensions = new ConcurrentHashMap<Class<? extends VHostItemExtension>, VHostItemExtension>();
        private boolean editable = true;

        public void setItem(VHostItem item) {
            this.item = item;
        }

        public void setDefaultVHost(VHostItem item) {
            this.defaultVHost = VHostItemWrapper.unwrap(item);
            this.refresh();
        }

        public void setVHostDefaults(VHostItemDefaults vHostDefaults) {
            this.vhostDefaults = vHostDefaults;
        }

        private static VHostItem unwrap(VHostItem item) {
            return item instanceof VHostItemWrapper ? ((VHostItemWrapper)item).item : item;
        }

        public void refresh() {
            if (this.defaultVHost == null || this.item == null) {
                return;
            }
            if (this.item.getKey() != null && this.item.getKey().equals("default")) {
                this.overrideSettingsWithNewDefaults(this.item);
            } else {
                this.mergeSettingsWithUpdatedDefaults(this.item, this.defaultVHost);
            }
        }

        private void overrideSettingsWithNewDefaults(VHostItem item) {
            this.defaultVHost = item;
            this.comps = this.defaultVHost.getComps();
            this.c2sPortsAllowed = this.defaultVHost.getC2SPortsAllowed();
            this.domainFilter = Optional.ofNullable(this.defaultVHost.getDomainFilter()).orElse(DOMAIN_FILTER_POLICY_PROP_DEF);
            this.domainFilterDomains = this.defaultVHost.getDomainFilterDomains();
            this.maxUsersNumber = this.defaultVHost.getMaxUsersNumber();
            this.messageForward = this.defaultVHost.getMessageForward();
            this.otherDomainParams = this.defaultVHost.getOtherDomainParams();
            this.presenceForward = this.defaultVHost.getPresenceForward();
            this.registerEnabled = this.defaultVHost.isRegisterEnabled();
            this.s2sSecret = this.defaultVHost.getS2sSecret();
            this.trustedJids = this.defaultVHost.getTrustedJIDs();
            this.saslAllowedMechanisms = this.defaultVHost.getSaslAllowedMechanisms();
            this.tlsRequired = this.defaultVHost.isTlsRequired();
            this.anonymousEnabled = this.defaultVHost.isAnonymousEnabled();
            this.extensions.clear();
            this.extensions = this.defaultVHost.getExtensionClasses().stream().map(this.defaultVHost::getExtension).collect(Collectors.toMap(Object::getClass, Function.identity()));
        }

        private void mergeSettingsWithUpdatedDefaults(VHostItem item, VHostItem defaultVHost) {
            this.comps = (String[])Stream.concat(Arrays.stream(item.getComps()), Arrays.stream(defaultVHost.getComps())).toArray(String[]::new);
            this.c2sPortsAllowed = Optional.ofNullable(item.getC2SPortsAllowed()).orElseGet(defaultVHost::getC2SPortsAllowed);
            this.domainFilter = Optional.ofNullable(item.getDomainFilter()).orElseGet(defaultVHost::getDomainFilter);
            this.domainFilterDomains = this.domainFilter.isDomainListRequired() ? Optional.ofNullable(item.getDomainFilterDomains()).orElseGet(defaultVHost::getDomainFilterDomains) : null;
            this.maxUsersNumber = Optional.ofNullable(Optional.ofNullable(item.getMaxUsersNumber()).orElseGet(defaultVHost::getMaxUsersNumber)).orElse(VHOST_MAX_USERS_PROP_DEF);
            this.messageForward = Optional.ofNullable(item.getMessageForward()).orElseGet(defaultVHost::getMessageForward);
            this.otherDomainParams = Optional.ofNullable(item.getOtherDomainParams()).orElseGet(defaultVHost::getOtherDomainParams);
            this.presenceForward = Optional.ofNullable(item.getPresenceForward()).orElseGet(defaultVHost::getPresenceForward);
            this.registerEnabled = defaultVHost.isRegisterEnabled() && item.isRegisterEnabled();
            this.s2sSecret = item.getS2sSecret();
            this.trustedJids = Collections.unmodifiableSet(Stream.concat(item.getTrustedJIDs().stream(), defaultVHost.getTrustedJIDs().stream()).collect(Collectors.toSet()));
            this.saslAllowedMechanisms = Optional.ofNullable(item.getSaslAllowedMechanisms()).orElseGet(defaultVHost::getSaslAllowedMechanisms);
            this.tlsRequired = defaultVHost.isTlsRequired() || item.isTlsRequired();
            this.anonymousEnabled = defaultVHost.isAnonymousEnabled() && item.isAnonymousEnabled();
            this.extensions.clear();
            for (Class<? extends VHostItemExtension> extClass : item.getExtensionClasses()) {
                VHostItemExtension defaultsExtension = defaultVHost.getExtension(extClass);
                VHostItemExtension itemExtension = item.getExtension(extClass);
                this.extensions.put(extClass, itemExtension.mergeWithDefaults(defaultsExtension));
            }
        }

        @Override
        public String[] getComps() {
            return this.comps;
        }

        @Override
        public int[] getC2SPortsAllowed() {
            return this.c2sPortsAllowed;
        }

        @Override
        public <T> T getData(String key) {
            return this.item.getData(key);
        }

        @Override
        public DomainFilterPolicy getDomainFilter() {
            return this.domainFilter;
        }

        @Override
        public String[] getDomainFilterDomains() {
            return this.domainFilterDomains;
        }

        @Override
        public <T extends VHostItemExtension> T getExtension(Class<T> clazz) {
            return (T)this.extensions.computeIfAbsent(clazz, cls -> {
                Object ext = this.item.getExtension(cls);
                if (ext != null) {
                    ((VHostItemExtension)ext).mergeWithDefaults(this.defaultVHost.getExtension(cls));
                }
                return ext;
            });
        }

        @Override
        public <T extends VHostItemExtension> Set<T> getExtensions() {
            Collection<VHostItemExtension> values = this.extensions.values();
            HashSet<VHostItemExtension> vHostItemExtensions = new HashSet<VHostItemExtension>(values);
            return Collections.unmodifiableSet(vHostItemExtensions);
        }

        @Override
        public Set<Class<? extends VHostItemExtension>> getExtensionClasses() {
            return new HashSet<Class<? extends VHostItemExtension>>(this.extensions.keySet());
        }

        @Override
        public Long getMaxUsersNumber() {
            return this.maxUsersNumber;
        }

        @Override
        public JID getMessageForward() {
            return this.messageForward;
        }

        @Override
        public String getOtherDomainParams() {
            return this.otherDomainParams;
        }

        @Override
        public JID getPresenceForward() {
            return this.presenceForward;
        }

        @Override
        public String getS2sSecret() {
            return this.s2sSecret;
        }

        @Override
        public Set<String> getTrustedJIDs() {
            return this.trustedJids;
        }

        @Override
        public JID getVhost() {
            return this.item.getVhost();
        }

        @Override
        public boolean isAnonymousEnabled() {
            return this.anonymousEnabled;
        }

        @Override
        public boolean isData(String key) {
            return this.item.isData(key);
        }

        @Override
        public boolean isEnabled() {
            return this.item.isEnabled();
        }

        @Override
        public boolean isRegisterEnabled() {
            return this.registerEnabled;
        }

        @Override
        public boolean isTlsRequired() {
            return this.tlsRequired;
        }

        @Override
        public String[] getSaslAllowedMechanisms() {
            return this.saslAllowedMechanisms;
        }

        @Override
        public void addCommandFields(Packet packet) {
            List fields;
            Element x;
            Element commandEl;
            this.item.addCommandFields(packet);
            if (this.vhostDefaults.isTlsRequired() && (commandEl = packet.getElement().getChild("command", "http://jabber.org/protocol/commands")) != null && (x = commandEl.getChild("x", "jabber:x:data")) != null && (fields = x.getChildren()) != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    Element field = (Element)fields.get(i);
                    x.removeChild(field);
                    if (VHostItemImpl.TLS_REQUIRED_LABEL.equals(field.getAttributeStaticStr("var"))) {
                        field = new Element("field", new String[]{"var", "type"}, new String[]{"TLS", "fixed"});
                        field.addChild((XMLNodeIfc)new Element("value", XMLUtils.escape((String)"This installation forces VHost to require TLS. If you need to use unencrypted connections set 'vhost-tls-required' property to 'false' in the installation configuration file")));
                        x.addChild((XMLNodeIfc)field);
                        continue;
                    }
                    x.addChild((XMLNodeIfc)field);
                }
            }
        }

        @Override
        public String[] getAdmins() {
            return this.item.getAdmins();
        }

        @Override
        public void setAdmins(String[] admins) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getKey() {
            return this.item.getKey();
        }

        @Override
        public void setKey(String domain) {
            if (!this.editable) {
                throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
            }
            this.item.setKey(domain);
        }

        @Override
        public String getOwner() {
            return this.item.getOwner();
        }

        @Override
        public void setOwner(String owner) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void initFromCommand(Packet packet) {
            if (!this.editable) {
                throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
            }
            this.item.initFromCommand(packet);
            this.refresh();
        }

        @Override
        public void initFromElement(Element elem) {
            if (!this.editable) {
                throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
            }
            this.item.initFromElement(elem);
            this.refresh();
        }

        @Override
        public void initFromPropertyString(String propString) {
            if (!this.editable) {
                throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
            }
            this.item.initFromPropertyString(propString);
            this.refresh();
        }

        @Override
        public boolean isOwner(String id) {
            return this.item.isOwner(id);
        }

        @Override
        public Element toElement() {
            return this.item.toElement();
        }

        @Override
        public String toPropertyString() {
            return this.item.toPropertyString();
        }

        protected void readOnly() {
            this.editable = false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("(Wrapped)");
            sb.append((CharSequence)VHostItemImpl.toString(this));
            return sb.toString();
        }
    }
}

