/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tigase.kernel.BeanUtils;

public class ReflectionHelper {
    public static boolean boundMatch(Class c1, TypeVariable t2) {
        Type[] b2 = t2.getBounds();
        if (b2.length != 1) {
            return false;
        }
        return b2[0] instanceof Class && ((Class)b2[0]).isAssignableFrom(c1);
    }

    public static boolean boundMatch(TypeVariable t1, TypeVariable t2) {
        Type[] b2;
        Type[] b1 = t1.getBounds();
        if (b1.length != (b2 = t2.getBounds()).length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < b1.length; ++i) {
            match &= b1[i].equals(b2[i]) || b1[i] instanceof Class && b2[i] instanceof Class && ((Class)b1[i]).isAssignableFrom((Class)b2[i]);
        }
        return match;
    }

    public static boolean classMatchesClassWithParameters(Class clazz, final Class requiredType, final Type[] requiredTypeParams) {
        ParameterizedType pt = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return requiredTypeParams;
            }

            @Override
            public Type getRawType() {
                return requiredType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        return ReflectionHelper.compareTypes(pt, clazz, null, null);
    }

    public static boolean classMatchesType(Class clazz, Type required) {
        if (required instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)required;
            Class rt = (Class)pt.getRawType();
            Type[] ap = pt.getActualTypeArguments();
            return ReflectionHelper.classMatchesClassWithParameters(clazz, rt, ap);
        }
        if (required instanceof Class) {
            return ((Class)required).isAssignableFrom(clazz);
        }
        return false;
    }

    public static <A extends Annotation, T> Collection<T> collectAnnotatedMethods(Object consumer, Class<A> annotationCls, Handler<A, T> handler) {
        Method[] methods;
        ArrayList<T> result = new ArrayList<T>();
        for (Method method : methods = BeanUtils.getAllMethods(consumer.getClass())) {
            A annotation = method.getAnnotation(annotationCls);
            if (annotation == null) continue;
            result.add(handler.process(consumer, method, annotation));
        }
        return result;
    }

    private static boolean compareParameterizedTypes(ParameterizedType expected, ParameterizedType actual, Map<TypeVariable<?>, Type> ownerExpectedTypesMap, Map<TypeVariable<?>, Type> ownerActualTypesMap) {
        Type[] expectedTypes;
        Class actualRawType;
        Class expectedRawType = (Class)expected.getRawType();
        if (!expectedRawType.isAssignableFrom(actualRawType = (Class)actual.getRawType())) {
            return false;
        }
        boolean result = true;
        Type[] actualTypes = actual.getActualTypeArguments();
        if (actualTypes.length == (expectedTypes = expected.getActualTypeArguments()).length) {
            for (int i = 0; i < expectedTypes.length; ++i) {
                Type actualType;
                Type expectedType = ReflectionHelper.resolveType(expectedTypes[i], ownerExpectedTypesMap);
                if (ReflectionHelper.compareTypes(expectedType, actualType = ReflectionHelper.resolveType(actualTypes[i], ownerActualTypesMap), ownerExpectedTypesMap, ownerActualTypesMap)) continue;
                result = false;
            }
            if (result) {
                return true;
            }
        } else if (actualRawType.isInterface()) {
            for (Type ifc : actualRawType.getGenericInterfaces()) {
                if (!ReflectionHelper.compareTypes(expected, ifc, ownerExpectedTypesMap, ownerActualTypesMap)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean compareTypes(Type expectedType, Type actualType, Map<TypeVariable<?>, Type> ownerExpectedTypesMap, Map<TypeVariable<?>, Type> ownerActualTypesMap) {
        if (expectedType.equals(actualType)) {
            return true;
        }
        if (expectedType instanceof WildcardType) {
            return true;
        }
        if (expectedType instanceof TypeVariable) {
            if ((expectedType = ReflectionHelper.resolveType(expectedType, ownerExpectedTypesMap)) instanceof TypeVariable) {
                if (actualType instanceof TypeVariable) {
                    return ReflectionHelper.boundMatch((TypeVariable)expectedType, (TypeVariable)actualType);
                }
                if (actualType instanceof Class) {
                    Type expectedBound = ((TypeVariable)expectedType).getBounds()[0];
                    return ReflectionHelper.compareTypes(expectedBound, actualType, ownerExpectedTypesMap, ownerActualTypesMap);
                }
            } else {
                return ReflectionHelper.compareTypes(expectedType, actualType, ownerExpectedTypesMap, ownerActualTypesMap);
            }
        }
        if (expectedType instanceof Class) {
            if (actualType instanceof Class) {
                return ((Class)expectedType).isAssignableFrom((Class)actualType);
            }
            if (actualType instanceof ParameterizedType) {
                return expectedType.equals(((ParameterizedType)actualType).getRawType());
            }
            if (actualType instanceof TypeVariable) {
                return ReflectionHelper.boundMatch((Class)expectedType, (TypeVariable)actualType);
            }
            return false;
        }
        if (expectedType instanceof ParameterizedType) {
            if (actualType instanceof ParameterizedType) {
                return ReflectionHelper.compareParameterizedTypes((ParameterizedType)expectedType, (ParameterizedType)actualType, ownerExpectedTypesMap, ownerActualTypesMap);
            }
            if (actualType instanceof Class) {
                Type tmp = actualType;
                if (ownerActualTypesMap == null) {
                    ownerActualTypesMap = ReflectionHelper.createGenericsTypeMap((Class)actualType);
                }
                Class expectedClass = (Class)((ParameterizedType)expectedType).getRawType();
                while (tmp != null) {
                    Class classToCheck;
                    if (tmp instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)tmp;
                        if (ReflectionHelper.compareParameterizedTypes((ParameterizedType)expectedType, pt, ownerExpectedTypesMap, ownerActualTypesMap)) {
                            return true;
                        }
                        classToCheck = (Class)pt.getRawType();
                    } else {
                        classToCheck = tmp instanceof Class ? (Class)tmp : null;
                    }
                    if (classToCheck != null) {
                        Type[] ifcs;
                        for (Type ifc : ifcs = classToCheck.getGenericInterfaces()) {
                            if (!(ifc instanceof ParameterizedType) || !ReflectionHelper.compareParameterizedTypes((ParameterizedType)expectedType, (ParameterizedType)ifc, ownerExpectedTypesMap, ownerActualTypesMap)) continue;
                            return true;
                        }
                        if (expectedClass.equals(classToCheck) && ReflectionHelper.compareParameterizedTypes((ParameterizedType)expectedType, (ParameterizedType)tmp, ownerExpectedTypesMap, ownerActualTypesMap)) {
                            return true;
                        }
                        tmp = classToCheck.getGenericSuperclass();
                        continue;
                    }
                    tmp = null;
                }
                return false;
            }
        }
        return false;
    }

    public static Map<TypeVariable<?>, Type> createGenericsTypeMap(Class<?> cls) {
        HashMap map = new HashMap();
        ReflectionHelper.createGenericsTypeMap(map, cls.getGenericInterfaces());
        Type genericType = cls.getGenericSuperclass();
        for (Class<?> type = cls.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            if (genericType instanceof ParameterizedType) {
                ReflectionHelper.createGenericsTypeMap(map, (ParameterizedType)genericType);
            }
            ReflectionHelper.createGenericsTypeMap(map, type.getGenericInterfaces());
            genericType = type.getGenericSuperclass();
        }
        return map;
    }

    private static void createGenericsTypeMap(Map<TypeVariable<?>, Type> map, Type[] ifcs) {
        for (Type ifc : ifcs) {
            if (!(ifc instanceof ParameterizedType)) continue;
            ReflectionHelper.createGenericsTypeMap(map, (ParameterizedType)ifc);
        }
    }

    private static Map<TypeVariable<?>, Type> createGenericsTypeMap(Map<TypeVariable<?>, Type> map, ParameterizedType type) {
        TypeVariable<Class<T>>[] tvs = ((Class)type.getRawType()).getTypeParameters();
        Type[] ap = type.getActualTypeArguments();
        for (int i = 0; i < tvs.length; ++i) {
            map.put(tvs[i], ap[i]);
        }
        return map;
    }

    public static Type getCollectionParamter(Type genericType, Class clazz) {
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> getItemClassOfGenericCollection(Field f) {
        Type genericType = f.getGenericType();
        if (genericType == null || !(genericType instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
        if (actualTypeArguments == null || actualTypeArguments.length != 1) {
            return null;
        }
        Type type = actualTypeArguments[0];
        return type instanceof Class ? (Class)type : null;
    }

    private static Type resolveType(Type t, Map<TypeVariable<?>, Type> ownerMap) {
        if (ownerMap == null) {
            return t;
        }
        while (t instanceof TypeVariable && ownerMap.containsKey(t)) {
            t = ownerMap.get(t);
        }
        if (t instanceof TypeVariable && ((TypeVariable)t).getBounds() != null && ((TypeVariable)t).getBounds().length > 0) {
            t = ((TypeVariable)t).getBounds()[0];
        }
        return t;
    }

    public static interface Handler<A extends Annotation, T> {
        public T process(Object var1, Method var2, A var3);
    }
}

