/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.historyCache;

public class LongHistoryCache {
    private long[] buffer = null;
    private int count = 0;
    private int start = 0;

    public LongHistoryCache(int limit) {
        this.buffer = new long[limit];
    }

    public synchronized void addItem(long item) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = item;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
    }

    public synchronized long[] getCurrentHistory() {
        long[] result = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
        }
        return result;
    }
}

