/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.time.LocalDate;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;

public class MaxDailyCounterQueue<E extends Number>
extends AbstractQueue<E> {
    private final int maxQueueLength;
    private ConcurrentLinkedDeque<E> deque = new ConcurrentLinkedDeque();
    private LocalDate lastDailyStatsReset = LocalDate.now();
    private String toString = "[]";

    public MaxDailyCounterQueue(int maxQueueLength) {
        this.maxQueueLength = maxQueueLength;
    }

    public Optional<E> getMaxValue() {
        return this.getMaxValueInRange(this.maxQueueLength);
    }

    public Optional<E> getMaxValueInRange(int range) {
        Number result = null;
        Iterator<E> iterator = this.deque.descendingIterator();
        for (range = Math.min(range, this.maxQueueLength); iterator.hasNext() && range > 0; --range) {
            Number next = (Number)iterator.next();
            if (result != null && ((Comparable)((Object)next)).compareTo(result) <= 0) continue;
            result = next;
        }
        return Optional.ofNullable(result);
    }

    public boolean isLimitSurpassed(E limit) {
        return this.isLimitSurpassed(this.maxQueueLength, limit);
    }

    public boolean isLimitSurpassed(int range, E limit) {
        return this.getMaxValueInRange(range).filter(e -> ((Comparable)((Object)e)).compareTo(limit) > 0).isPresent();
    }

    public boolean isLimitSurpassedAllItems(E limit) {
        return this.isLimitSurpassedAllItems(this.maxQueueLength, limit);
    }

    public boolean isLimitSurpassedAllItems(int range, E limit) {
        boolean result = true;
        range = Math.min(range, this.maxQueueLength);
        Iterator<E> iter = this.deque.descendingIterator();
        while (iter.hasNext() && range > 0) {
            --range;
            Number next = (Number)iter.next();
            if (((Comparable)((Object)next)).compareTo(limit) > 0) continue;
            result &= false;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.deque.iterator();
    }

    @Override
    public boolean offer(E added) {
        if (this.isNextItem() || this.deque.peekLast() == null) {
            this.deque.offer(added);
        } else if (((Comparable)((Object)((Number)this.deque.peekLast()))).compareTo(added) < 0) {
            this.deque.pollLast();
            this.deque.offer(added);
        }
        while (this.deque.size() > this.maxQueueLength) {
            this.deque.remove();
        }
        this.toString = this.deque.toString();
        return true;
    }

    @Override
    public E peek() {
        return (E)((Number)this.deque.peek());
    }

    @Override
    public E poll() {
        return (E)((Number)this.deque.poll());
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    public ArrayDeque<E> subQueue(int range) {
        ArrayDeque<Number> result = new ArrayDeque<Number>(range);
        Iterator<E> iter = this.deque.descendingIterator();
        for (range = Math.min(range, this.maxQueueLength); iter.hasNext() && range > 0; --range) {
            result.add((Number)iter.next());
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    protected boolean isNextItem() {
        LocalDate now = LocalDate.now();
        if (now.getYear() != this.lastDailyStatsReset.getYear() || now.getDayOfYear() != this.lastDailyStatsReset.getDayOfYear()) {
            this.lastDailyStatsReset = LocalDate.now();
            return true;
        }
        return false;
    }
}

