/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.vhosts.DefaultAwareVHostManagerIfc;
import tigase.xmpp.jid.JID;

@Bean(name="KnownDomainsListProvider", parent=Kernel.class, active=true, exportable=true)
public class KnownDomainsListProvider {
    private static final Logger log = Logger.getLogger(KnownDomainsListProvider.class.getCanonicalName());
    @ConfigField(desc="Static list of domains that are to be provided instead of dynamic ones")
    private HashSet<String> staticDomainsSet = new HashSet();
    @ConfigField(desc="Use only static list of domains for both local and remote domains")
    private boolean useOnlyStaticDomainsList = false;
    @Inject
    private DefaultAwareVHostManagerIfc vHostManagerIfc;
    protected Set<String> authenticatedRemoteDomains = new CopyOnWriteArraySet<String>();

    public void addRemoteDomain(String remoteHost) {
        if (this.staticDomainsSet.isEmpty()) {
            this.authenticatedRemoteDomains.add(remoteHost);
        }
    }

    public Set<String> getAuthenticatedRemoteDomains() {
        if (!this.staticDomainsSet.isEmpty()) {
            return Collections.unmodifiableSet(this.staticDomainsSet);
        }
        return Collections.unmodifiableSet(this.authenticatedRemoteDomains);
    }

    public Set<String> getAllLocalDomains() {
        if (this.useOnlyStaticDomainsList) {
            return Collections.unmodifiableSet(this.staticDomainsSet);
        }
        return this.vHostManagerIfc.getAllVHosts(false).stream().map(JID::toString).collect(Collectors.toSet());
    }
}

