/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.events.ShutdownEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHost;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="seeOtherHost", parent=ClientConnectionManager.class, active=true)
@ClusterModeRequired(active=true)
public class SeeOtherHostHashed
extends SeeOtherHost {
    private static final Logger log = Logger.getLogger(SeeOtherHostHashed.class.getName());
    protected List<BareJID> connectedNodes = new CopyOnWriteArrayList<BareJID>();

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        int hash = Math.abs(jid.hashCode());
        if (this.defaultHost != null && !this.defaultHost.isEmpty() && this.connectedNodes.contains(this.defaultHost.get(hash % this.defaultHost.size()))) {
            return (BareJID)this.defaultHost.get(hash % this.defaultHost.size());
        }
        if (this.connectedNodes.size() > 0) {
            return this.connectedNodes.get(hash % this.connectedNodes.size());
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNodes(List<JID> connectedNodes) {
        SeeOtherHostHashed seeOtherHostHashed = this;
        synchronized (seeOtherHostHashed) {
            JID[] arr_in = connectedNodes.toArray(new JID[connectedNodes.size()]);
            ArrayList<BareJID> list_out = new ArrayList<BareJID>();
            for (int i = 0; i < arr_in.length; ++i) {
                BareJID jid = BareJID.bareJIDInstanceNS(null, (String)arr_in[i].getDomain());
                list_out.add(jid);
            }
            this.setConnectedNodes(list_out);
        }
        super.setNodes(connectedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeShutdown(ShutdownEvent event) {
        super.nodeShutdown(event);
        SeeOtherHostHashed seeOtherHostHashed = this;
        synchronized (seeOtherHostHashed) {
            this.setConnectedNodes(new ArrayList<BareJID>(this.connectedNodes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectedNodes(List<BareJID> connectedNodes) {
        connectedNodes = this.filterNodes(connectedNodes);
        SeeOtherHostHashed seeOtherHostHashed = this;
        synchronized (seeOtherHostHashed) {
            Collections.sort(connectedNodes);
            this.connectedNodes = new CopyOnWriteArrayList<BareJID>(connectedNodes);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "setting list of connected nodes: {0}", this.connectedNodes);
        }
    }

    private List<BareJID> filterNodes(List<BareJID> list) {
        Iterator<BareJID> it = list.iterator();
        while (it.hasNext()) {
            BareJID jid = it.next();
            if (!this.isNodeShutdown(jid)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "removing node {0} from see-other-host list as it is during shutdown", jid);
            }
            it.remove();
        }
        return list;
    }
}

