/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.beans.SDRepositoryBean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.xmppclient.SeeOtherHostHashed;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class SeeOtherHostDB
extends SeeOtherHostHashed
implements RegistrarBean {
    public static final String SEE_OTHER_HOST_TABLE = "tig_see_other_hosts";
    public static final String SEE_OTHER_HOST_DB_URL_KEY = "cm-see-other-host/db-url";
    public static final String SEE_OTHER_HOST_DB_QUERY_KEY = "cm-see-other-host/get-host-query";
    public static final String DB_GET_ALL_DATA_DB_QUERY_KEY = "cm-see-other-host/get-all-data-query";
    public static final String GET_ALL_QUERY_TIMEOUT_QUERY_KEY = "cm-see-other-host/get-all-query-timeout";
    public static final String SERIAL_ID = "sid";
    public static final String USER_ID = "uid";
    public static final String NODE_ID = "node_id";
    private static final Logger log = Logger.getLogger(SeeOtherHostDB.class.getName());
    @Inject
    private SeeOtherHostRepository repo;

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        BareJID see_other_host = this.repo.getHostFor(jid);
        if (see_other_host != null && !this.isNodeShutdown(see_other_host)) {
            return see_other_host;
        }
        try {
            see_other_host = this.repo.queryDBFor(jid);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "DB lookup failed, fallback to SeeOtherHostHashed: ", ex);
        }
        if (see_other_host == null || this.isNodeShutdown(see_other_host)) {
            log.log(Level.FINE, "DB lookup failed or selected node is being stopped, fallback to SeeOtherHostHashed for {0}", jid);
            see_other_host = super.findHostForJID(jid, host);
        }
        return see_other_host;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    private void checkDB() throws SQLException {
    }

    public static interface SeeOtherHostRepository<DS extends DataSource>
    extends DataSourceAware<DS> {
        public BareJID getHostFor(BareJID var1);

        public BareJID queryDBFor(BareJID var1) throws UserNotFoundException, SQLException, TigaseStringprepException;
    }

    public static class SeeOtherHostDBSDRepositoryBean
    extends SDRepositoryBean<SeeOtherHostRepository> {
        @Override
        protected Class<?> findClassForDataSource(DataSource dataSource) throws DBInitException {
            return DataSourceHelper.getDefaultClass(SeeOtherHostRepository.class, dataSource.getResourceUri());
        }
    }

    @Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
    public static class JDBCSeeOtherHostRepository
    implements SeeOtherHostRepository<DataRepository> {
        public static final String DEF_DB_GET_HOST_QUERY = " select * from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid and user_id = ?";
        private static final String DEF_DB_GET_ALL_DATA_QUERY = "select user_id, node_id from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid";
        private static final String CREATE_STATS_TABLE = "create table tig_see_other_hosts ( sid serial,uid bigint unsigned NOT NULL, node_id varchar(2049) NOT NULL,  primary key (sid),  constraint tig_see_other_host_constr foreign key (uid) references tig_users (uid))";
        private static final String DERBY_CREATE_STATS_TABLE = "create table tig_see_other_hosts ( sid bigint generated by default as identity not null,uid bigint  NOT NULL, node_id varchar(2049) NOT NULL,  primary key (sid),  constraint tig_see_other_host_constr foreign key (uid) references tig_users (uid))";
        private static final String SQLSERVER_CREATE_STATS_TABLE = "create table tig_see_other_hosts ( sid [bigint] IDENTITY(1,1),uid bigint NOT NULL, node_id nvarchar(2049) NOT NULL,  primary key (sid),  constraint tig_see_other_host_constr foreign key (uid) references tig_users (uid))";
        private static final int DEF_QUERY_TIME_OUT = 0;
        private DataRepository data_repo;
        @ConfigField(desc="Query to load mapping data", alias="get-all-data-query")
        private String get_all_data_query = "select user_id, node_id from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid";
        @ConfigField(desc="Query to find host for JID", alias="get-host-query")
        private String get_host_query = " select * from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid and user_id = ?";
        private Map<BareJID, BareJID> redirectsMap = new ConcurrentSkipListMap<BareJID, BareJID>();

        @Override
        public BareJID getHostFor(BareJID jid) {
            return this.redirectsMap.get(jid);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BareJID queryDBFor(BareJID user) throws UserNotFoundException, SQLException, TigaseStringprepException {
            PreparedStatement get_host = this.data_repo.getPreparedStatement(user, this.get_host_query);
            ResultSet rs = null;
            PreparedStatement preparedStatement = get_host;
            synchronized (preparedStatement) {
                block5: {
                    BareJID bareJID;
                    try {
                        get_host.setString(1, user.toString());
                        rs = get_host.executeQuery();
                        if (!rs.next()) break block5;
                        bareJID = BareJID.bareJIDInstance((String)rs.getString(SeeOtherHostDB.NODE_ID));
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    return bareJID;
                }
                throw new UserNotFoundException("Item does not exist for user: " + String.valueOf(user));
            }
        }

        @Override
        public void setDataSource(DataRepository data_repo) throws RepositoryException {
            try {
                DataRepository.dbTypes databaseType = data_repo.getDatabaseType();
                switch (databaseType) {
                    case derby: {
                        data_repo.checkTable(SeeOtherHostDB.SEE_OTHER_HOST_TABLE, DERBY_CREATE_STATS_TABLE);
                        break;
                    }
                    case jtds: 
                    case sqlserver: {
                        data_repo.checkTable(SeeOtherHostDB.SEE_OTHER_HOST_TABLE, SQLSERVER_CREATE_STATS_TABLE);
                        break;
                    }
                    default: {
                        data_repo.checkTable(SeeOtherHostDB.SEE_OTHER_HOST_TABLE, CREATE_STATS_TABLE);
                    }
                }
                data_repo.initPreparedStatement(this.get_host_query, this.get_host_query);
                data_repo.initPreparedStatement(this.get_all_data_query, this.get_all_data_query);
                this.data_repo = data_repo;
                this.queryAllDB();
            }
            catch (SQLException ex) {
                throw new TigaseDBException("Could not initialize repository", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queryAllDB() throws SQLException {
            PreparedStatement get_all = this.data_repo.getPreparedStatement(null, this.get_all_data_query);
            get_all.setQueryTimeout(0);
            ResultSet rs = null;
            PreparedStatement preparedStatement = get_all;
            synchronized (preparedStatement) {
                try {
                    rs = get_all.executeQuery();
                    while (rs.next()) {
                        String user_jid = rs.getString("user_id");
                        String node_jid = rs.getString(SeeOtherHostDB.NODE_ID);
                        try {
                            BareJID user = BareJID.bareJIDInstance((String)user_jid);
                            BareJID node = BareJID.bareJIDInstance((String)node_jid);
                            this.redirectsMap.put(user, node);
                        }
                        catch (TigaseStringprepException ex) {
                            log.warning("Invalid user's or node's JID: " + user_jid + ", " + node_jid);
                        }
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
            log.log(Level.CONFIG, "Loaded " + this.redirectsMap.size() + " redirect definitions from database.");
        }
    }
}

