/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.xml.Element;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.BareJID;

@Bean(name="ws2s", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.ConnectionManagersMode})
@ClusterModeRequired(active=false)
public class WebSocketClientConnectionManager
extends ClientConnectionManager {
    private static final Logger log = Logger.getLogger(WebSocketClientConnectionManager.class.getName());
    private static final String XMLNS_FRAMING = "urn:ietf:params:xml:ns:xmpp-framing";
    @Inject
    private WebSocketProtocolIfc[] enabledProtocolVersions;

    public WebSocketClientConnectionManager() {
        this.watchdogPingType = ConnectionManager.WATCHDOG_PING_TYPE.XMPP;
    }

    @Override
    public void setWatchdogPingType(ConnectionManager.WATCHDOG_PING_TYPE watchdogPingType) {
        super.setWatchdogPingType(watchdogPingType);
        if (watchdogPingType.equals((Object)ConnectionManager.WATCHDOG_PING_TYPE.WHITESPACE)) {
            log.log(Level.SEVERE, "Setting watchdog ping type as WHITESPACE for WebSocket connection manager violates RFC7395 specification and can break numerous clients");
        }
    }

    @Override
    public String getDiscoDescription() {
        return "Websocket connection manager";
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5290};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new WebSocketXMPPIOService<Object>(this.enabledProtocolVersions);
    }

    @Override
    protected String prepareStreamClose(XMPPIOService<Object> serv) {
        if (this.isPreRFC(serv)) {
            return super.prepareStreamClose(serv);
        }
        return "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing' />";
    }

    @Override
    protected String prepareStreamOpen(XMPPIOService<Object> serv, String id, String hostname, @Nullable String to) {
        if (this.isPreRFC(serv)) {
            return super.prepareStreamOpen(serv, id, hostname, to);
        }
        return "<open xmlns='urn:ietf:params:xml:ns:xmpp-framing' from='" + hostname + "'" + (String)(to == null ? "" : " to='" + to + "'") + " id='" + id + "' version='1.0' xml:lang='en' />";
    }

    @Override
    protected String prepareStreamError(XMPPIOService<Object> serv, List<Element> err_el) {
        if (this.isPreRFC(serv)) {
            return super.prepareStreamError(serv, err_el);
        }
        StreamError streamError = StreamError.getByCondition(err_el.get(0).getName());
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, streamError);
        }
        return "<stream:error xmlns:stream=\"http://etherx.jabber.org/streams\">" + err_el.stream().map(Element::toString).collect(Collectors.joining()) + "</stream:error>";
    }

    @Override
    protected String[] prepareStreamError(XMPPIOService<Object> serv, StreamError streamError, String hostname) {
        if (this.isPreRFC(serv)) {
            return super.prepareStreamError(serv, streamError, hostname);
        }
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, streamError);
        }
        return new String[]{"<open xmlns='urn:ietf:params:xml:ns:xmpp-framing' from='" + hostname + "' id='tigase-error-tigase' version='1.0' xml:lang='en' />", "<stream:error xmlns:stream=\"http://etherx.jabber.org/streams\"><" + streamError.getCondition() + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error>", "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing'/>"};
    }

    @Override
    protected String[] prepareSeeOtherHost(XMPPIOService<Object> serv, String hostname, BareJID see_other_host) {
        if (this.isPreRFC(serv)) {
            return super.prepareSeeOtherHost(serv, hostname, see_other_host);
        }
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, StreamError.SeeOtherHost);
        }
        boolean ssl = SocketType.ssl == (SocketType)((Object)serv.getSessionData().get("socket"));
        int localPort = serv.getLocalPort();
        String see_other_uri = (ssl ? "wss://" : "ws://") + String.valueOf(see_other_host) + ":" + localPort + "/";
        return new String[]{"<open xmlns='urn:ietf:params:xml:ns:xmpp-framing' from='" + String.valueOf(hostname != null ? hostname : this.getDefVHostItem()) + "' id='tigase-error-tigase' version='1.0' xml:lang='en' />", "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing' see-other-uri='" + see_other_uri + "' />"};
    }

    @Override
    protected void preprocessStreamFeatures(XMPPIOService<Object> serv, Element elem_features) {
        Element starttlsEl;
        if (!this.isPreRFC(serv)) {
            elem_features.setAttribute("xmlns:stream", "http://etherx.jabber.org/streams");
        }
        if ((starttlsEl = elem_features.findChild(el -> "starttls" == el.getName() && "urn:ietf:params:xml:ns:xmpp-tls" == el.getXMLNS())) != null) {
            elem_features.removeChild(starttlsEl);
        }
    }

    private boolean isPreRFC(XMPPIOService<Object> serv) {
        return serv == null || ((WebSocketXMPPIOService)serv).getWebSocketXMPPSpec() == WebSocketXMPPIOService.WebSocketXMPPSpec.hybi;
    }
}

