/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.test;

import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.test.TestComponent;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="test-generator-module", parent=TestComponent.class, active=true)
public class TestGeneratorModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(TestGeneratorModule.class.getCanonicalName());
    private Criteria CRITERIA = ElementCriteria.name((String)"message");
    @Inject
    private TestComponent component;

    @Override
    public Criteria getModuleCriteria() {
        return this.CRITERIA;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet);
        } else {
            String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
            this.write(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "This is response to your message: [" + body + "]", "Response", null, packet.getStanzaId()));
        }
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void runCommand(Packet packet) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        String[] body_split = body.split(" |\n|\r");
        command comm = command.valueOf(body_split[0].substring(2));
        switch (comm.ordinal()) {
            case 0: {
                try {
                    int number = Integer.parseInt(body_split[1]);
                    String domain = packet.getStanzaFrom().getDomain();
                    for (int i = 0; i < number; ++i) {
                        this.write(Message.getMessage(packet.getStanzaTo(), JID.jidInstance((String)("nonename_" + i + "@" + domain)), StanzaType.normal, "Traffic generattion: " + number, "Internal load test", null, packet.getStanzaId()));
                    }
                    this.write(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Completed " + number, "Response", null, packet.getStanzaId()));
                    break;
                }
                catch (Exception e) {
                    this.write(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Incorrect command parameter: " + (body_split.length > 1 ? body_split[1] : null) + ", expecting Integer.", "Response", null, packet.getStanzaId()));
                }
            }
        }
    }

    private static enum command {
        genn;

    }
}

