/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl.adhoc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.TigaseDBException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.rtbl.RTBL;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLFetchModule;
import tigase.server.rtbl.RTBLSubscribeModule;
import tigase.server.rtbl.adhoc.AbstractAdHocCommand;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="rtbl-command-add", parent=RTBLComponent.class, active=true)
public class RTBLAddCommand
extends AbstractAdHocCommand {
    private static final Logger log = Logger.getLogger(RTBLAddCommand.class.getCanonicalName());
    @Inject
    private RTBLSubscribeModule subscribeModule;
    @Inject
    private RTBLFetchModule fetchModule;

    @Override
    public String getName() {
        return "Add real-time blocklist";
    }

    @Override
    public String getNode() {
        return "rtbl-add";
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("form", "Add real-time blocklist", "Fill out and submit this form to add a new real-time blocklist");
        form.addField(Field.fieldJidSingle((String)"pubsubJid", (String)"", (String)"Service address (JID)"));
        form.addField(Field.fieldTextSingle((String)"node", (String)"", (String)"Node"));
        form.addField(Field.fieldTextSingle((String)"hash", (String)"SHA-256", (String)"Hashing algorithm"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        try {
            BareJID jid = BareJID.bareJIDInstance((String)this.assertNotEmpty(form.getAsString("pubsubJid"), "Service address is required!"));
            String node = this.assertNotEmpty(form.getAsString("node"), "Node is required!");
            String hash = this.assertNotEmpty(form.getAsString("hash"), "Hash algorithm is required!");
            MessageDigest.getInstance(hash);
            RTBL rtbl = this.getRepository().getBlockList(jid, node);
            if (rtbl != null) {
                throw new AdHocCommandException(Authorization.CONFLICT, "This blocklist was already added.");
            }
            this.getRepository().add(jid, node, hash);
            this.subscribeModule.subscribe(jid, node);
            this.fetchModule.fetch(jid, node);
            return null;
        }
        catch (TigaseStringprepException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "could not parse JID", e);
            }
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Invalid service address");
        }
        catch (NoSuchAlgorithmException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "could not find hash algorithm", e);
            }
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported hashing algorithm");
        }
        catch (TigaseDBException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "failed to update database", e);
            }
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
        }
    }
}

