/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.rtbl.RTBLComponent;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class RTBLIqModule<RCTX>
extends AbstractModule
implements Initializable,
UnregisterAware {
    private final Criteria criteria = new Or(new Criteria[]{ElementCriteria.nameType((String)"iq", (String)"result"), ElementCriteria.nameType((String)"iq", (String)"error")});
    @Inject(bean="rtbl-component")
    private RTBLComponent component;
    @Inject
    private VHostManager vHostManager;
    private final String requestPrefix;
    private ConcurrentHashMap<RequestKey, RCTX> activeRequests = new ConcurrentHashMap();

    public RTBLIqModule(String requestPrefix) {
        this.requestPrefix = requestPrefix;
    }

    public RTBLComponent getComponent() {
        return this.component;
    }

    @Override
    public Criteria getModuleCriteria() {
        return this.criteria;
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll(this);
        }
    }

    protected JID getOwnJID() {
        return JID.jidInstanceNS((String)this.component.getName(), (String)this.vHostManager.getDefVHostItem().getDomain());
    }

    protected <T> void sendIq(BareJID to, StanzaType type, Consumer<Element> consumer, Supplier<RCTX> handleContextSupplier) {
        String id = this.requestPrefix + UUID.randomUUID().toString();
        Element iqEl = new Element("iq").withAttribute("type", type.name()).withAttribute("id", id);
        consumer.accept(iqEl);
        RequestKey requestKey = new RequestKey(to, id);
        this.activeRequests.put(requestKey, handleContextSupplier.get());
        try {
            this.write(new Iq(iqEl, this.getOwnJID(), JID.jidInstance((BareJID)to)));
        }
        catch (Throwable ex) {
            this.activeRequests.remove(requestKey);
        }
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID from = packet.getStanzaFrom();
        if (from == null) {
            return;
        }
        String id = packet.getAttributeStaticStr("id");
        if (id == null) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        if (!id.startsWith(this.requestPrefix)) {
            return;
        }
        ResultEvent.Result result = ResultEvent.Result.fromPacket(packet);
        if (result == ResultEvent.Result.success) {
            this.handleSuccess((Iq)packet);
        }
        this.getEventBus().fire(new ResultEvent(this.getClass(), from.getBareJID(), id, result));
    }

    protected void handleSuccess(Iq iq) {
    }

    @HandleEvent
    public void handleResultEvent(ResultEvent event) {
        RCTX ctx;
        if (event.isForClass(this.getClass()) && (ctx = this.activeRequests.remove(new RequestKey(event.getJid(), event.getId()))) != null) {
            this.handleResult(event, ctx);
        }
    }

    protected abstract void handleResult(ResultEvent var1, RCTX var2);

    public static class RequestKey {
        private final BareJID jid;
        private final String id;

        public RequestKey(BareJID jid, String id) {
            this.jid = jid;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestKey)) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return Objects.equals(this.jid, that.jid) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.jid, this.id);
        }
    }

    public static class ResultEvent
    implements Serializable,
    EventBusEvent {
        private BareJID jid;
        private String id;
        private Result result;
        private String className;

        public ResultEvent() {
        }

        public ResultEvent(Class<? extends RTBLIqModule> forClazz, BareJID jid, String id, Result result) {
            this.className = forClazz.getSimpleName();
            this.jid = jid;
            this.id = id;
            this.result = result;
        }

        public BareJID getJid() {
            return this.jid;
        }

        public void setJid(BareJID jid) {
            this.jid = jid;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public boolean isForClass(Class<? extends RTBLIqModule> clazz) {
            return clazz.getSimpleName().equals(this.className);
        }

        public static enum Result {
            success,
            failureRetry,
            failureNoRetry;


            public static Result fromPacket(Packet packet) throws ComponentException {
                StanzaType type = packet.getType();
                if (type == null) {
                    throw new ComponentException(Authorization.BAD_REQUEST);
                }
                return switch (type) {
                    case StanzaType.result -> success;
                    case StanzaType.error -> {
                        Element error = packet.getElemChild("error");
                        if (error != null) {
                            if (Stream.of(Authorization.INTERNAL_SERVER_ERROR, Authorization.REMOTE_SERVER_NOT_FOUND, Authorization.REMOTE_SERVER_TIMEOUT).map(Authorization::getCondition).anyMatch(name -> error.getChild(name, "urn:ietf:params:xml:ns:xmpp-stanzas") != null)) {
                                yield failureRetry;
                            }
                            yield failureNoRetry;
                        }
                        yield failureNoRetry;
                    }
                    default -> throw new ComponentException(Authorization.BAD_REQUEST);
                };
            }
        }
    }
}

