/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.util.List;
import java.util.stream.Collectors;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.rtbl.RTBL;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLIqModule;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.common.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="rtblFetchModule", parent=RTBLComponent.class, active=true)
public class RTBLFetchModule
extends RTBLIqModule<String> {
    private static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";
    @Inject
    private RTBLRepository repository;

    public RTBLFetchModule() {
        super("fetch-");
    }

    public void fetch(BareJID jid, String node) {
        this.sendIq(jid, StanzaType.get, iqEl -> iqEl.withElement("pubsub", PUBSUB_XMLNS, pubsubEl -> pubsubEl.withElement("items", itemsEl -> itemsEl.withAttribute("node", node))), () -> node);
    }

    @Override
    protected void handleResult(final RTBLIqModule.ResultEvent event, final String node) {
        switch (event.getResult()) {
            case failureRetry: {
                this.getComponent().addTimerTask(new TimerTask(){

                    @Override
                    public void run() {
                        RTBLFetchModule.this.fetch(event.getJid(), node);
                    }
                }, 10000L);
                break;
            }
        }
    }

    @Override
    protected void handleSuccess(Iq iq) {
        Element pubsubEl = iq.getElemChild("pubsub", PUBSUB_XMLNS);
        if (pubsubEl == null) {
            return;
        }
        Element itemsEl = pubsubEl.getChild("items");
        if (itemsEl == null) {
            return;
        }
        String node = itemsEl.getAttributeStaticStr("node");
        List items = itemsEl.findChildren(el -> "item".equals(el.getName()));
        if (node == null || items == null) {
            return;
        }
        RTBL existingRTBL = this.repository.getBlockList(iq.getStanzaFrom().getBareJID(), node);
        if (existingRTBL != null) {
            RTBL rtbl = new RTBL(iq.getStanzaFrom().getBareJID(), node, existingRTBL.getHash(), items.stream().map(it -> it.getAttributeStaticStr("id")).collect(Collectors.toSet()));
            this.repository.update(rtbl);
        }
    }
}

