/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentConnection;
import tigase.server.ext.ComponentIOService;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.server.ext.StreamOpenHandler;
import tigase.server.ext.handlers.BindProcessor;
import tigase.server.ext.handlers.ComponentAcceptStreamOpenHandler;
import tigase.server.ext.handlers.ComponentConnectStreamOpenHandler;
import tigase.server.ext.handlers.HandshakeProcessor;
import tigase.server.ext.handlers.JabberClientStreamOpenHandler;
import tigase.server.ext.handlers.SASLProcessor;
import tigase.server.ext.handlers.StartTLSProcessor;
import tigase.server.ext.handlers.StreamFeaturesProcessor;
import tigase.server.ext.handlers.UnknownXMLNSStreamOpenHandler;
import tigase.server.ext.lb.LoadBalancerIfc;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

@Bean(name="ext", parent=Kernel.class, active=false)
public class ComponentProtocol
extends ConnectionManager<ComponentIOService>
implements ComponentProtocolHandler,
UnregisterAware,
RepositoryChangeListenerIfc<CompRepoItem> {
    public static final String AUTHENTICATION_TIMEOUT_PROP_KEY = "auth-timeout";
    public static final String CLOSE_ON_SEQUENCE_ERROR_PROP_KEY = "close-on-seq-error";
    public static final String EXTCOMP_BIND_HOSTNAMES = "--bind-ext-hostnames";
    public static final String EXTCOMP_REPO_CLASS_PROP_KEY = "repository-class";
    public static final String EXTCOMP_REPO_CLASS_PROP_VAL = "tigase.server.ext.ServerCompDBRepository";
    public static final String EXTCOMP_REPO_CLASS_PROPERTY = "--extcomp-repo-class";
    public static final String IDENTITY_TYPE_KEY = "identity-type";
    public static final String IDENTITY_TYPE_VAL = "generic";
    public static final String MAX_AUTH_ATTEMPTS_PROP_KEY = "max-auth-attempts";
    public static final String PACK_ROUTED_KEY = "pack-routed";
    public static final String RETURN_SERVICE_DISCO_KEY = "service-disco";
    public static final boolean RETURN_SERVICE_DISCO_VAL = true;
    private static final Logger log = Logger.getLogger(ComponentProtocol.class.getName());
    @ConfigField(desc="Authentication timeout", alias="auth-timeout")
    private long authenticationTimeOut = 15L;
    @ConfigField(desc="Close stream on sequence error", alias="close-on-seq-error")
    private boolean closeOnSequenceError = true;
    private Map<String, CopyOnWriteArrayList<ComponentConnection>> connections = new ConcurrentHashMap<String, CopyOnWriteArrayList<ComponentConnection>>();
    @ConfigField(desc="Enable experimental features")
    private boolean experimental = false;
    @ConfigField(desc="Hostnames to bind", alias="bind-ext-hostnames")
    private String[] hostnamesToBind = new String[0];
    @ConfigField(desc="Identitiy type", alias="identity-type")
    private String identity_type = "generic";
    @ConfigField(desc="Max number of authentication attempts", alias="max-auth-attempts")
    private int maxAuthenticationAttempts = 1;
    private Map<String, ExtProcessor> processors = new LinkedHashMap<String, ExtProcessor>(10);
    @Inject
    private ComponentRepository<CompRepoItem> repo = null;
    private Map<String, StreamOpenHandler> streamOpenHandlers = new LinkedHashMap<String, StreamOpenHandler>();
    private UnknownXMLNSStreamOpenHandler unknownXMLNSHandler = new UnknownXMLNSStreamOpenHandler();
    private ConcurrentHashMap<String, List<ConnectionOpenListener>> activeConnections = new ConcurrentHashMap();

    public ComponentProtocol() {
        StreamOpenHandler handler = new JabberClientStreamOpenHandler();
        if (handler.getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
        if ((handler = new ComponentAcceptStreamOpenHandler()).getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
        if ((handler = new ComponentConnectStreamOpenHandler()).getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
        this.processors = new LinkedHashMap<String, ExtProcessor>();
        ExtProcessor proc = new HandshakeProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new StreamFeaturesProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new StartTLSProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new SASLProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new BindProcessor();
        this.processors.put(proc.getId(), proc);
    }

    @Override
    public void authenticated(ComponentIOService serv) {
        serv.setAuthenticated(true);
        super.serviceConnected(serv);
        String hostname = (String)serv.getSessionData().get("hostname-key");
        this.bindHostname(hostname, serv);
        if (this.hostnamesToBind != null) {
            serv.getSessionData().put("bind-ext-hostnames", this.hostnamesToBind);
            ExtProcessor proc = this.getProcessor("bind");
            if (proc != null) {
                ArrayDeque<Packet> results = new ArrayDeque<Packet>();
                proc.startProcessing(null, serv, this, results);
                this.writePacketsToSocket(serv, results);
            }
        }
    }

    @Override
    public void authenticationFailed(ComponentIOService serv, Packet packet) {
        this.writePacketToSocket(serv, packet);
        Integer fails = (Integer)serv.getSessionData().get("auth-fails");
        fails = fails == null ? Integer.valueOf(1) : Integer.valueOf(fails + 1);
        if (fails >= this.maxAuthenticationAttempts) {
            serv.stop();
        }
    }

    @Override
    public void bindHostname(String hostname, ComponentIOService serv) {
        String[] routings = new String[]{hostname, ".*@" + hostname, ".*\\." + hostname};
        if (serv.connectionType() == ConnectionType.connect) {
            routings = new String[]{".*"};
        }
        serv.setRoutings(routings[0]);
        this.updateRoutings(routings, true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Authenticated: " + hostname);
        }
        this.updateServiceDiscoveryItem(hostname, null, "ext-comp connected", false);
        if (this.experimental) {
            this.updateServiceDiscoForConnection(hostname, serv);
        }
        this.addComponentConnection(hostname, serv);
        this.addComponentDomain(hostname);
    }

    @Override
    protected boolean enableServiceConnectedTimeout(ComponentIOService service) {
        return true;
    }

    @Override
    public CompRepoItem getCompRepoItem(String hostname) {
        return this.repo.getItem(hostname);
    }

    @Override
    public String getDiscoCategoryType() {
        return this.identity_type;
    }

    @Override
    public String getDiscoDescription() {
        return "External component";
    }

    @Override
    public ExtProcessor getProcessor(String key) {
        return this.processors.get(key);
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Number of external domains", this.connections.size(), Level.FINE);
        int size = 0;
        for (CopyOnWriteArrayList<ComponentConnection> conns : this.connections.values()) {
            size += conns.size();
        }
        list.add(this.getName(), "Number of external component connections", size, Level.FINER);
    }

    @Override
    public List<Element> getStreamFeatures(ComponentIOService serv) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (ExtProcessor proc : this.processors.values()) {
            List<Element> proc_res = proc.getStreamFeatures(serv, this);
            if (proc_res == null) continue;
            results.addAll(proc_res);
        }
        return results;
    }

    @Override
    public StreamOpenHandler getStreamOpenHandler(String xmlns) {
        return this.streamOpenHandlers.get(xmlns);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.repo);
    }

    @Override
    public void register(Kernel kernel) {
        super.register(kernel);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void beforeUnregister() {
    }

    @Override
    public Queue<Packet> processSocketData(ComponentIOService serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
        while ((p = packets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0}, from socket: {1}", new Object[]{p, serv});
            }
            boolean processed = false;
            for (ExtProcessor proc : this.processors.values()) {
                processed |= proc.process(p, serv, this, results);
                this.writePacketsToSocket(serv, results);
            }
            if (processed) continue;
            if (serv.isAuthenticated()) {
                Packet result = p;
                if (p.isRouted()) {
                    try {
                        result = p.unpackRouted();
                    }
                    catch (TigaseStringprepException ex) {
                        log.log(Level.WARNING, "Packet stringprep addressing problem, dropping packet: {0}", p);
                        return null;
                    }
                }
                result.getElement().setXMLNS("jabber:client");
                if (result.getStanzaFrom() != null) {
                    serv.addRecentJID(result.getStanzaFrom());
                }
                this.addOutPacket(result);
                continue;
            }
            try {
                Packet error = Authorization.NOT_AUTHORIZED.getResponseMessage(p, "Connection not yet authorized to send this packet.", true);
                this.writePacketToSocket(serv, error);
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINE, "Received an error packet from unauthorized connection: {0}", p);
            }
            if (!this.closeOnSequenceError) continue;
            serv.stop();
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
        this.addPacket(packet);
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    @Override
    public void serviceStarted(ComponentIOService serv) {
        super.serviceStarted(serv);
        this.addTimerTask((TimerTask)new AuthenticationTimerTask(this, serv), this.authenticationTimeOut, TimeUnit.SECONDS);
        String xmlns = ((CompRepoItem)serv.getSessionData().get("repo-item")).getXMLNS();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Connection started: " + serv.getRemoteAddress() + ", xmlns: " + xmlns + ", type: " + serv.connectionType().toString() + ", id=" + serv.getUniqueId());
        }
        StreamOpenHandler handler = this.streamOpenHandlers.get(xmlns);
        String result = null;
        if (handler == null) {
            log.fine("XMLNS not set, accepting a new connection with xmlns auto-detection.");
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "cid: {0}, sending: {1}, sessionData: {2}", new Object[]{serv.getSessionData().get("cid"), result, serv.getSessionData()});
            }
            result = handler.serviceStarted(serv);
        }
        if (result != null) {
            serv.xmppStreamOpen(result);
        }
    }

    @Override
    public boolean serviceStopped(ComponentIOService service) {
        boolean result = super.serviceStopped(service);
        if (result) {
            ConcurrentMap<String, Object> sessionData = service.getSessionData();
            String hostname = (String)sessionData.get("hostname-key");
            if (hostname != null && !hostname.isEmpty()) {
                List conns = (List)service.getRefObject();
                if (conns != null) {
                    for (ComponentConnection conn : conns) {
                        boolean moreConnections = this.removeComponentConnection(conn.getDomain(), conn);
                        if (moreConnections) continue;
                        this.removeRoutings(conn.getDomain());
                    }
                } else {
                    log.finer("Closing XMPPIOService has not yet set ComponentConnection as RefObject: " + hostname + ", id: " + service.getUniqueId());
                }
            } else {
                log.finer("Stopped service which hasn't sent initial stream open yet" + service.getUniqueId());
            }
            ConnectionType type = service.connectionType();
            if (type == ConnectionType.connect) {
                CompRepoItem connItem = (CompRepoItem)sessionData.get("repo-item");
                if (connItem == null) {
                    this.addWaitingTask(sessionData);
                } else {
                    CompRepoItem newItem = this.repo.getItem(connItem.getKey());
                    if (newItem == connItem) {
                        this.addWaitingTask(sessionData);
                    }
                }
            }
        }
        return result;
    }

    public void setRepo(ComponentRepository<CompRepoItem> repo) {
        this.repo = repo;
        repo.addRepoChangeListener(this);
    }

    @Override
    public void start() {
        super.start();
        for (CompRepoItem repoItem : this.repo) {
            this.itemUpdated(repoItem);
        }
    }

    @Override
    public void tlsHandshakeCompleted(ComponentIOService service) {
    }

    @Override
    public void unbindHostname(String hostname, ComponentIOService serv) {
        CopyOnWriteArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns != null) {
            boolean moreConnections;
            ComponentConnection conn = null;
            for (ComponentConnection componentConnection : conns) {
                if (componentConnection.getService() != serv) continue;
                conn = componentConnection;
            }
            if (conn != null && !(moreConnections = this.removeComponentConnection(conn.getDomain(), conn))) {
                this.removeRoutings(conn.getDomain());
            }
        }
    }

    @Override
    public boolean writePacketToSocket(ComponentIOService ios, Packet p) {
        p.getElement().removeAttribute("xmlns");
        return super.writePacketToSocket(ios, p);
    }

    @Override
    public void xmppStreamClosed(ComponentIOService serv) {
    }

    @Override
    public String[] xmppStreamOpened(ComponentIOService serv, Map<String, String> attribs) {
        String[] stringArray;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stream opened: " + serv.getRemoteAddress() + ", xmlns: " + attribs.get("xmlns") + ", type: " + serv.connectionType().toString() + ", uniqueId=" + serv.getUniqueId() + ", to=" + attribs.get("to"));
        }
        String s_xmlns = attribs.get("xmlns");
        String result = null;
        StreamOpenHandler handler = this.streamOpenHandlers.get(s_xmlns);
        if (handler == null || s_xmlns == null) {
            log.finest("unknownXMLNSHandler is processing request");
            result = this.unknownXMLNSHandler.streamOpened(serv, attribs, this);
        } else {
            log.finest(handler.getClass().getName() + " is processing request");
            result = handler.streamOpened(serv, attribs, this);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending back: " + result);
        }
        if (result == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = result;
        }
        return stringArray;
    }

    @Override
    public void itemAdded(CompRepoItem repoItem) {
        if (repoItem.getPort() > 0) {
            String[] remote_host = this.PORT_IFC_PROP_VAL;
            String remote_domain = repoItem.getRemoteHost();
            if (repoItem.getRemoteHost() != null) {
                remote_host = repoItem.getRemoteHost().split(";");
                remote_domain = remote_host[0];
                if (remote_host.length > 1) {
                    String[] remote_host_copy = new String[remote_host.length - 1];
                    System.arraycopy(remote_host, 1, remote_host_copy, 0, remote_host_copy.length);
                    remote_host = remote_host_copy;
                }
            }
            ArrayList<ConnectionManager.ConnectionListenerImpl> listeners = new ArrayList<ConnectionManager.ConnectionListenerImpl>();
            for (String r_host : remote_host) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>();
                port_props.put("port-no", repoItem.getPort());
                if (repoItem.getDomain() != null) {
                    port_props.put("local-host", repoItem.getDomain());
                }
                port_props.put("remote-host", remote_domain);
                port_props.put("hostname-key", remote_domain);
                port_props.put("type", (Object)repoItem.getConnectionType());
                port_props.put("socket", (Object)repoItem.getSocket());
                port_props.put("ifc", new String[]{r_host});
                port_props.put("max-reconnects", 0x6DDD00);
                port_props.put("repo-item", repoItem);
                log.config("Starting connection: " + String.valueOf(port_props));
                ConnectionManager.ConnectionListenerImpl connectionOpenListener = this.startService(port_props);
                if (connectionOpenListener == null) continue;
                listeners.add(connectionOpenListener);
            }
            this.activeConnections.put(repoItem.getKey(), listeners);
        }
    }

    @Override
    public void itemUpdated(CompRepoItem item) {
        this.itemRemoved(item);
        this.itemAdded(item);
    }

    @Override
    public void itemRemoved(CompRepoItem item) {
        List<ConnectionOpenListener> listeners = this.activeConnections.get(item.getKey());
        if (listeners != null) {
            for (ConnectionOpenListener connectionOpenListener : listeners) {
                this.releaseListener(connectionOpenListener);
            }
        }
        for (List list : this.connections.values()) {
            for (ComponentConnection connection : list) {
                CompRepoItem connItem = (CompRepoItem)connection.getService().getSessionData().get("repo-item");
                if (!connItem.getKey().equals(item.getKey())) continue;
                connection.getService().stop();
            }
        }
    }

    @Override
    protected String getDefTrafficThrottling() {
        return "xmpp:25m:0:disc,bin:20000m:0:disc";
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected ComponentIOService getXMPPIOService(Packet p) {
        if (p.getStanzaTo() == null) {
            return null;
        }
        ComponentIOService result = null;
        String hostname = p.getStanzaTo().getDomain();
        CopyOnWriteArrayList<ComponentConnection> conns = this.connections.get(hostname);
        for (CopyOnWriteArrayList<ComponentConnection> c : this.connections.values()) {
            if (c.size() <= 0 || !".*".equals(c.get(0).getService().getRoutings())) continue;
            conns = c;
            break;
        }
        if (conns != null) {
            ComponentIOService serv;
            for (ComponentConnection componentConnection : conns) {
                serv = componentConnection.getService();
                if (serv == null || !serv.isConnected() || !serv.isRecentJID(p.getStanzaTo())) continue;
                result = serv;
                break;
            }
            if (result == null && conns.size() > 1) {
                CompRepoItem cmp_repo_item = this.getCompRepoItem(hostname);
                if (cmp_repo_item == null) {
                    cmp_repo_item = this.repo.getItem(p.getStanzaFrom().getDomain());
                }
                LoadBalancerIfc lb = cmp_repo_item.getLoadBalancer();
                result = lb.selectConnection(p, conns);
            }
            if (result == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("LB could not select connection, or there is only one connection, trying traditional way");
                }
                for (ComponentConnection componentConnection : conns) {
                    serv = componentConnection.getService();
                    if (serv != null) {
                        if (serv.isConnected()) {
                            result = serv;
                        } else {
                            log.log(Level.CONFIG, "Service is not connected for connection for hostname: " + hostname);
                        }
                    } else {
                        log.log(Level.CONFIG, "Service is null for connection for hostname: " + hostname);
                    }
                    if (result == null) continue;
                    break;
                }
            }
        } else {
            log.log(Level.CONFIG, "No ext connection for hostname: " + hostname);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Selected connection: " + String.valueOf(result));
        }
        return result;
    }

    @Override
    protected ComponentIOService getXMPPIOServiceInstance() {
        return new ComponentIOService();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    private void updateServiceDiscoForConnection(String hostname, ComponentIOService serv) {
        int idx = hostname.indexOf(".");
        String newhostname = hostname.substring(idx + 1);
        if (!this.isLocalDomain(newhostname)) {
            this.updateServiceDiscoveryItem(newhostname, "ext", serv.getUniqueId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addComponentConnection(String hostname, ComponentIOService s) {
        boolean result;
        ComponentConnection conn = new ComponentConnection(hostname, s);
        CopyOnWriteArrayList<Object> refObject = (CopyOnWriteArrayList<ComponentConnection>)s.getRefObject();
        if (refObject == null) {
            refObject = new CopyOnWriteArrayList<ComponentConnection>();
        }
        CopyOnWriteArrayList<ComponentConnection> copyOnWriteArrayList = refObject;
        synchronized (copyOnWriteArrayList) {
            refObject.add(conn);
            Object[] arr_list = refObject.toArray(new ComponentConnection[refObject.size()]);
            Arrays.sort(arr_list);
            refObject = new CopyOnWriteArrayList<Object>(arr_list);
        }
        s.setRefObject(refObject);
        CopyOnWriteArrayList<Object> conns = this.connections.get(hostname);
        if (conns == null) {
            conns = new CopyOnWriteArrayList();
        }
        CopyOnWriteArrayList<ComponentConnection> copyOnWriteArrayList2 = conns;
        synchronized (copyOnWriteArrayList2) {
            result = conns.add(conn);
            Object[] arr_list = conns.toArray(new ComponentConnection[conns.size()]);
            Arrays.sort(arr_list);
            conns = new CopyOnWriteArrayList<Object>(arr_list);
        }
        this.connections.put(hostname, conns);
        if (result) {
            log.finer("A new component connection added for: " + hostname);
        } else {
            log.fine("A new component connection NOT added for: " + hostname);
        }
    }

    private synchronized boolean removeComponentConnection(String hostname, ComponentConnection conn) {
        boolean result = false;
        CopyOnWriteArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns != null) {
            boolean removed = conns.remove(conn);
            if (removed) {
                log.finer("A component connection removed for: " + hostname);
            } else {
                log.fine("A component connection NOT removed for: " + hostname);
            }
            for (ComponentConnection compCon : conns) {
                ComponentIOService serv = compCon.getService();
                if (serv != null && serv.isConnected()) {
                    result = true;
                    continue;
                }
                log.warning("Null or disconnected service for ComponentConnection for host: " + hostname);
            }
        } else {
            log.warning("That should not happen, ComponentConnection is not null but the collection is: " + hostname);
        }
        return result;
    }

    private void removeRoutings(String hostname) {
        String[] routings = new String[]{hostname, ".*@" + hostname, ".*\\." + hostname};
        this.updateRoutings(routings, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Disonnected from: " + hostname);
        }
        this.updateServiceDiscoveryItem(hostname, null, "XEP-0114 disconnected", false);
        this.removeComponentDomain(hostname);
    }

    private void updateRoutings(String[] routings, boolean add) {
        if (add) {
            for (String route : routings) {
                try {
                    this.addRegexRouting(route);
                }
                catch (Exception e) {
                    log.warning("Can not add regex routing '" + route + "' : " + String.valueOf(e));
                }
            }
        } else {
            for (String route : routings) {
                try {
                    this.removeRegexRouting(route);
                    log.fine("Removed routings: " + route);
                }
                catch (Exception e) {
                    log.warning("Can not remove regex routing '" + route + "' : " + String.valueOf(e));
                }
            }
        }
        log.finest("All regex routings: " + this.getRegexRoutings().toString());
    }

    private class AuthenticationTimerTask
    extends TimerTask {
        private ComponentIOService serv = null;

        private AuthenticationTimerTask(ComponentProtocol componentProtocol, ComponentIOService serv) {
            this.serv = serv;
        }

        @Override
        public void run() {
            if (!this.serv.isAuthenticated()) {
                this.serv.stop();
            }
        }
    }
}

