/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.RepositoryFactory;
import tigase.db.beans.DataSourceBean;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.ext.CompConfigRepository;
import tigase.server.ext.CompRepoItem;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

@Deprecated
@TigaseDeprecated(since="8.0.0")
public class CompSQLRepository
implements ComponentRepository<CompRepoItem>,
DataSourceAware<DataRepository>,
Initializable,
UnregisterAware {
    public static final String REPO_URI_PROP_KEY = "repo-uri";
    public static final String TABLE_NAME = "external_component";
    private static final String CONNECTION_TYPE_COLUMN = "connection_type";
    private static final String DOMAIN_COLUMN = "domain";
    private static final Logger log = Logger.getLogger(CompSQLRepository.class.getName());
    private static final String OTHER_DATA_COLUMN = "other_data";
    private static final String PASSWORD_COLUMN = "password";
    private static final String PORT_COLUMN = "port";
    private static final String PROTOCOL_COLUMN = "protocol";
    private static final String REMOTE_DOMAIN_COLUMN = "remote_domain";
    private static final String GET_ITEM_QUERY = "select * from external_component where domain = ?";
    private static final String GET_ALL_ITEMS_QUERY = "select * from external_component";
    private static final String DELETE_ITEM_QUERY = "delete from external_component where (domain = ?)";
    private static final String CREATE_TABLE_QUERY = "create table external_component (  domain varchar(255) NOT NULL,  password varchar(255) NOT NULL,  connection_type varchar(127),  port int,  remote_domain varchar(255),  protocol varchar(127),  other_data TEXT,  primary key(domain))";
    private static final String CHECK_TABLE_QUERY = "select count(*) from external_component";
    private static final String ADD_ITEM_QUERY = "insert into external_component (domain, password, connection_type, port, remote_domain, protocol, other_data)  (select ?, ?, ?, ?, ?, ?, ? from external_component where domain = ? HAVING count(*)=0) ";
    private CompConfigRepository configRepo = new CompConfigRepository();
    @Inject
    private DataSourceBean dataSourceBean;
    @ConfigField(desc="Name of data source to use")
    private String dataSourceName = "default";
    private DataRepository data_repo = null;
    @Inject
    private EventBus eventBus;
    private String tableName = "external_component";

    public void setDataSourceBean(DataSourceBean dataSourceBean) {
        this.dataSourceBean = dataSourceBean;
        DataSource ds = dataSourceBean.getRepository(this.dataSourceName);
        if (ds != null && ds instanceof DataRepository) {
            ds.checkSchemaVersion(this, true);
            this.setDataSource((DataRepository)ds);
        } else {
            log.log(Level.WARNING, "Could not retrieve data source named ''{0}''", new Object[]{this.dataSourceName});
        }
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    public void onDataSourceChange(DataSourceBean.DataSourceChangedEvent event) {
        if (!event.isCorrectSender(this.dataSourceBean)) {
            return;
        }
        DataSource ds = event.getNewDataSource();
        if (ds != null && ds instanceof DataRepository) {
            ds.checkSchemaVersion(this, true);
            this.setDataSource((DataRepository)ds);
        } else {
            log.log(Level.WARNING, "Could not retrieve data source named ''{0}''", new Object[]{this.dataSourceName});
        }
    }

    @Override
    public void addRepoChangeListener(RepositoryChangeListenerIfc<CompRepoItem> repoChangeListener) {
        this.configRepo.addRepoChangeListener(repoChangeListener);
    }

    @Override
    public void removeRepoChangeListener(RepositoryChangeListenerIfc<CompRepoItem> repoChangeListener) {
        this.configRepo.removeRepoChangeListener(repoChangeListener);
    }

    @Override
    public void addItemNoStore(CompRepoItem item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(CompRepoItem item) {
        try {
            PreparedStatement addItemSt;
            PreparedStatement preparedStatement = addItemSt = this.data_repo.getPreparedStatement(null, ADD_ITEM_QUERY);
            synchronized (preparedStatement) {
                if (item.getDomain() == null || item.getDomain().isEmpty()) {
                    throw new NullPointerException("Null or empty domain name is not allowed");
                }
                addItemSt.setString(1, item.getDomain());
                addItemSt.setString(8, item.getDomain());
                if (item.getAuthPasswd() == null) {
                    throw new NullPointerException("Null password is not allowed");
                }
                addItemSt.setString(2, item.getAuthPasswd());
                if (item.getConnectionType() != null) {
                    addItemSt.setString(3, item.getConnectionType().name());
                } else {
                    addItemSt.setNull(3, 12);
                }
                if (item.getPort() > 0) {
                    addItemSt.setInt(4, item.getPort());
                } else {
                    addItemSt.setNull(4, 4);
                }
                if (item.getRemoteHost() != null && !item.getRemoteHost().isEmpty()) {
                    addItemSt.setString(5, item.getRemoteHost());
                } else {
                    addItemSt.setNull(5, 12);
                }
                if (item.getXMLNS() != null) {
                    addItemSt.setString(6, item.getXMLNS());
                } else {
                    addItemSt.setNull(6, 12);
                }
                String other_data = item.toElement().toString();
                if (other_data != null) {
                    addItemSt.setString(7, other_data);
                } else {
                    addItemSt.setNull(7, 12);
                }
                addItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding a new item to DB: " + String.valueOf(item.toElement()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CompRepoItem> allItems() {
        ArrayList<CompRepoItem> result = new ArrayList<CompRepoItem>();
        result.addAll(this.configRepo.allItems());
        try {
            PreparedStatement getAllItemsSt;
            ResultSet rs = null;
            PreparedStatement preparedStatement = getAllItemsSt = this.data_repo.getPreparedStatement(null, GET_ALL_ITEMS_QUERY);
            synchronized (preparedStatement) {
                try {
                    rs = getAllItemsSt.executeQuery();
                    while (rs.next()) {
                        result.add(this.createItemFromRS(rs));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
        return result;
    }

    @Override
    public boolean contains(String key) {
        boolean result = this.configRepo.contains(key);
        return result;
    }

    @Override
    public void destroy() {
    }

    @Override
    @Deprecated
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        this.configRepo.getDefaults(defs, params);
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(REPO_URI_PROP_KEY, repo_uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompRepoItem getItem(String key) {
        CompRepoItem result = (CompRepoItem)this.configRepo.getItem(key);
        if (result == null) {
            try {
                PreparedStatement getItemSt;
                ResultSet rs = null;
                PreparedStatement preparedStatement = getItemSt = this.data_repo.getPreparedStatement(null, GET_ITEM_QUERY);
                synchronized (preparedStatement) {
                    try {
                        getItemSt.setString(1, key);
                        rs = getItemSt.executeQuery();
                        if (rs.next()) {
                            result = this.createItemFromRS(rs);
                        }
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting element from DB for domain: " + key, e);
            }
        }
        return result;
    }

    @Override
    public CompRepoItem getItemInstance() {
        return this.configRepo.getItemInstance();
    }

    @Override
    public void setDataSource(DataRepository data_repo) {
        try {
            this.checkDB();
            data_repo.initPreparedStatement(CHECK_TABLE_QUERY, CHECK_TABLE_QUERY);
            data_repo.initPreparedStatement(GET_ITEM_QUERY, GET_ITEM_QUERY);
            data_repo.initPreparedStatement(GET_ALL_ITEMS_QUERY, GET_ALL_ITEMS_QUERY);
            data_repo.initPreparedStatement(ADD_ITEM_QUERY, ADD_ITEM_QUERY);
            data_repo.initPreparedStatement(DELETE_ITEM_QUERY, DELETE_ITEM_QUERY);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not initialize database: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
            this.data_repo.checkSchemaVersion(this, true);
            this.setDataSource(this.data_repo);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem initializing database: ", e);
        }
    }

    @Override
    public Iterator<CompRepoItem> iterator() {
        return this.allItems().iterator();
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(String key) {
        this.configRepo.removeItem(key);
        try {
            PreparedStatement deleteItemSt;
            PreparedStatement preparedStatement = deleteItemSt = this.data_repo.getPreparedStatement(null, DELETE_ITEM_QUERY);
            synchronized (preparedStatement) {
                deleteItemSt.setString(1, key);
                deleteItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Can''t remove item: " + key, e);
        }
    }

    @Override
    public void removeItemNoStore(String key) {
    }

    @Override
    @Deprecated
    public void setProperties(Map<String, Object> properties) {
        this.configRepo.setProperties(properties);
        String repo_uri = (String)properties.get(REPO_URI_PROP_KEY);
        try {
            this.initRepository(repo_uri, null);
        }
        catch (DBInitException ex) {
            log.log(Level.WARNING, "Problem initializing database.", ex);
        }
    }

    @Override
    public int size() {
        int result = this.configRepo.size();
        return result;
    }

    @Override
    public void store() {
    }

    @Override
    public String validateItem(CompRepoItem item) {
        return null;
    }

    @Override
    public void setAutoloadTimer(long delay) {
    }

    private void checkDB() throws SQLException {
        this.data_repo.checkTable(this.tableName, CREATE_TABLE_QUERY);
    }

    private CompRepoItem createItemFromRS(ResultSet rs) throws SQLException {
        String connection_type;
        String protocol;
        String remote_domain;
        int port;
        String password;
        String domain;
        Element elem_item;
        CompRepoItem result = this.getItemInstance();
        String other = rs.getString(OTHER_DATA_COLUMN);
        if (other != null && !other.isEmpty() && (elem_item = this.parseElement(other)) != null) {
            result.initFromElement(elem_item);
        }
        if ((domain = rs.getString(DOMAIN_COLUMN)) != null && !domain.isEmpty()) {
            result.setDomain(domain);
        }
        if ((password = rs.getString(PASSWORD_COLUMN)) != null && !password.isEmpty()) {
            result.setPassword(password);
        }
        if ((port = rs.getInt(PORT_COLUMN)) > 0) {
            result.setPort(port);
        }
        if ((remote_domain = rs.getString(REMOTE_DOMAIN_COLUMN)) != null && !remote_domain.isEmpty()) {
            result.setRemoteDomain(remote_domain);
        }
        if ((protocol = rs.getString(PROTOCOL_COLUMN)) != null && !protocol.isEmpty()) {
            result.setProtocol(protocol);
        }
        if ((connection_type = rs.getString(CONNECTION_TYPE_COLUMN)) != null && !connection_type.isEmpty()) {
            result.setConnectionType(connection_type);
        }
        return result;
    }

    private Element parseElement(String data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        SimpleParser parser = SingletonFactory.getParserInstance();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            return (Element)elems.poll();
        }
        return null;
    }
}

