/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.osgi.ModulesManager;
import tigase.xmpp.XMPPImplIfc;

public class ModulesManagerImpl
implements ModulesManager {
    private static final Logger log = Logger.getLogger(ModulesManagerImpl.class.getCanonicalName());
    private static ModulesManagerImpl instance = null;
    private boolean active = false;
    private AbstractBeanConfigurator beanConfigurator;
    private ConcurrentHashMap<String, Class<?>> classes = new ConcurrentHashMap();

    public static ModulesManagerImpl getInstance() {
        if (instance == null) {
            instance = new ModulesManagerImpl();
        }
        return instance;
    }

    private ModulesManagerImpl() {
    }

    public Collection<Class<?>> getClasses() {
        return this.classes.values();
    }

    @Override
    public void registerPluginClass(Class<? extends XMPPImplIfc> pluginCls) {
        this.registerClass(pluginCls);
    }

    @Override
    public void unregisterPluginClass(Class<? extends XMPPImplIfc> pluginClass) {
        this.unregisterClass(pluginClass);
    }

    @Override
    public void registerServerComponentClass(Class<? extends Configurable> compCls) {
        this.registerClass(compCls);
    }

    @Override
    public void unregisterServerComponentClass(Class<? extends Configurable> compCls) {
        this.unregisterClass(compCls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClass(Class<?> cls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String clsName = cls.getCanonicalName();
            this.classes.put(clsName, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterClass(Class<?> cls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String clsName = cls.getCanonicalName();
            this.classes.remove(clsName, cls);
        }
    }

    @Override
    public Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> cls;
        if ("tigase.cluster.strategy.OnlineUsersCachingStrategy".equals(className)) {
            log.warning("You are using old name for SM clustering strategy in property --sm-cluster-strategy-class\nYou are using name: " + className + "\n while name: tigase.server.cluster.strategy.OnlineUsersCachingStrategy should be used.");
            className = "tigase.server.cluster.strategy.OnlineUsersCachingStrategy";
        }
        if ((cls = this.classes.get(className)) == null) {
            cls = this.getClass().getClassLoader().loadClass(className);
        }
        return cls;
    }

    @Override
    public void update() {
        if (this.active && this.beanConfigurator != null) {
            this.beanConfigurator.configurationChanged();
        }
    }

    public void setBeanConfigurator(AbstractBeanConfigurator beanConfigurator) {
        this.beanConfigurator = beanConfigurator;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

