/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Map;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.monitor.tasks.TasksEvent;

@Bean(name="sample-task", parent=MonitorComponent.class, active=true)
public class SampleTask
extends AbstractConfigurableTimerTask
implements Initializable {
    @Inject
    private EventBus eventBus;
    private String message = "<->";

    @Override
    public Form getCurrentConfiguration() {
        Form x = super.getCurrentConfiguration();
        x.addField(Field.fieldTextSingle((String)"message", (String)"", (String)"Event message"));
        return x;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(SampleTaskEvent.class, "Sample task", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field m = form.get("message");
        this.message = m == null ? "<not found>" : m.getValue();
        super.setNewConfiguration(form);
    }

    @Override
    protected void enable() {
        super.enable();
        SampleTaskEvent event = new SampleTaskEvent(this.message);
        this.message = "<->";
        this.eventBus.fire(event);
        this.setEnabled(false);
    }

    @Override
    protected void run() {
    }

    public static class SampleTaskEvent
    extends TasksEvent {
        String message;

        public SampleTaskEvent(String name, String description) {
            super(name, description);
        }

        public SampleTaskEvent(String message) {
            super("SampleTaskEvent", "Sample task");
            this.message = message;
        }

        @Override
        public Map<String, String> getAdditionalData() {
            return Map.of("log", this.message);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

