/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.MonitorComponent;
import tigase.monitor.modules.ConfigureTaskCommand;
import tigase.monitor.modules.InfoTaskCommand;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="commands", parent=MonitorComponent.class, active=true)
public class AdHocCommandMonitorModule
extends AdHocCommandModule
implements Initializable {
    private final AdHocCommandManager customCommandsManager = new AdHocCommandManager();
    @Inject
    private ConfigureTaskCommand configCommand;
    @Inject
    private InfoTaskCommand infoCommand;
    @Inject(bean="kernel")
    private Kernel kernel;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void process(Packet packet) throws ComponentException {
        Object taskInstance;
        JID jid = packet.getStanzaTo();
        Object v0 = taskInstance = jid.getResource() != null ? this.kernel.getInstance(jid.getResource()) : null;
        if (jid.getResource() != null && taskInstance != null) {
            this.processCommand(packet, taskInstance);
        } else {
            if (jid.getResource() != null) {
                throw new ComponentException(Authorization.ITEM_NOT_FOUND);
            }
            if (jid.getResource() == null) {
                super.process(packet);
            } else {
                throw new ComponentException(Authorization.NOT_ACCEPTABLE);
            }
        }
    }

    private AdHocCommand getCommand(Object taskInstance, String node) {
        if (node.equals("x-info")) {
            return this.infoCommand;
        }
        if (node.equals("x-config")) {
            return this.configCommand;
        }
        return null;
    }

    private void processCommand(Packet packet, Object taskInstance) throws ComponentException {
        Element element = packet.getElement();
        JID senderJid = packet.getStanzaFrom();
        Element command2 = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command2.getAttributeStaticStr("node");
        String action = command2.getAttributeStaticStr("action");
        String sessionId = command2.getAttributeStaticStr("sessionid");
        AdHocCommand adHocCommand = this.getCommand(taskInstance, node);
        try {
            this.customCommandsManager.process(packet, command2, node, action, sessionId, adHocCommand, this.writer::write);
        }
        catch (AdHocCommandException e) {
            throw new ComponentException(e.getErrorCondition(), e.getMessage());
        }
    }
}

